/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.wall.WallSqlFunctionStat;
import com.alibaba.druid.wall.WallSqlStat;
import com.alibaba.druid.wall.WallSqlTableStat;
import java.util.HashMap;
import java.util.Map;

public class WallContext {
    private static final ThreadLocal<WallContext> contextLocal = new ThreadLocal();
    private WallSqlStat sqlStat;
    private Map<String, WallSqlTableStat> tableStats;
    private Map<String, WallSqlFunctionStat> functionStats;
    private final String dbType;
    private int commentCount;
    private int warnnings = 0;
    private int unionWarnnings = 0;
    private int updateNoneConditionWarnnings = 0;
    private int deleteNoneConditionWarnnings = 0;
    private int likeNumberWarnnings = 0;

    public WallContext(String dbType) {
        this.dbType = dbType;
    }

    public void incrementFunctionInvoke(String tableName) {
        String lowerCaseName;
        WallSqlFunctionStat stat;
        if (this.functionStats == null) {
            this.functionStats = new HashMap<String, WallSqlFunctionStat>();
        }
        if ((stat = this.functionStats.get(lowerCaseName = tableName.toLowerCase())) == null) {
            if (this.functionStats.size() > 100) {
                return;
            }
            stat = new WallSqlFunctionStat();
            this.functionStats.put(tableName, stat);
        }
        stat.incrementInvokeCount();
    }

    public WallSqlTableStat getTableStat(String tableName) {
        String lowerCaseName;
        WallSqlTableStat stat;
        if (this.tableStats == null) {
            this.tableStats = new HashMap<String, WallSqlTableStat>(2);
        }
        if ((stat = this.tableStats.get(lowerCaseName = tableName.toLowerCase())) == null) {
            if (this.tableStats.size() > 100) {
                return null;
            }
            stat = new WallSqlTableStat();
            this.tableStats.put(tableName, stat);
        }
        return stat;
    }

    public static WallContext createIfNotExists(String dbType) {
        WallContext context = contextLocal.get();
        if (context == null) {
            context = new WallContext(dbType);
            contextLocal.set(context);
        }
        return context;
    }

    public static WallContext create(String dbType) {
        WallContext context = new WallContext(dbType);
        contextLocal.set(context);
        return context;
    }

    public static WallContext current() {
        return contextLocal.get();
    }

    public static void clearContext() {
        contextLocal.remove();
    }

    public static void setContext(WallContext context) {
        contextLocal.set(context);
    }

    public WallSqlStat getSqlStat() {
        return this.sqlStat;
    }

    public void setSqlStat(WallSqlStat sqlStat) {
        this.sqlStat = sqlStat;
    }

    public Map<String, WallSqlTableStat> getTableStats() {
        return this.tableStats;
    }

    public Map<String, WallSqlFunctionStat> getFunctionStats() {
        return this.functionStats;
    }

    public String getDbType() {
        return this.dbType;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public void incrementCommentCount() {
        if (this.commentCount == 0) {
            ++this.warnnings;
        }
        ++this.commentCount;
    }

    public int getWarnnings() {
        return this.warnnings;
    }

    public void incrementWarnnings() {
        ++this.warnnings;
    }

    public int getLikeNumberWarnnings() {
        return this.likeNumberWarnnings;
    }

    public void incrementLikeNumberWarnnings() {
        if (this.likeNumberWarnnings == 0) {
            ++this.warnnings;
        }
        ++this.likeNumberWarnnings;
    }

    public int getUnionWarnnings() {
        return this.unionWarnnings;
    }

    public void incrementUnionWarnnings() {
        if (this.unionWarnnings == 0) {
            this.incrementWarnnings();
        }
        ++this.unionWarnnings;
    }

    public int getUpdateNoneConditionWarnnings() {
        return this.updateNoneConditionWarnnings;
    }

    public void incrementUpdateNoneConditionWarnnings() {
        if (this.updateNoneConditionWarnnings == 0) {
            this.incrementWarnnings();
        }
        ++this.updateNoneConditionWarnnings;
    }

    public int getDeleteNoneConditionWarnnings() {
        return this.deleteNoneConditionWarnnings;
    }

    public void incrementDeleteNoneConditionWarnnings() {
        if (this.deleteNoneConditionWarnnings == 0) {
            this.incrementWarnnings();
        }
        ++this.deleteNoneConditionWarnnings;
    }
}

