/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.filter.config;

import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.config.ConfigTools;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.PublicKey;
import java.sql.SQLException;
import java.util.Properties;

public class ConfigFilter
extends FilterAdapter {
    private static Log LOG = LogFactory.getLog(ConfigFilter.class);
    public static final String CONFIG_FILE = "config.file";
    public static final String CONFIG_DECRYPT = "config.decrypt";
    public static final String CONFIG_KEY = "config.decrypt.key";
    public static final String SYS_PROP_CONFIG_FILE = "druid.config.file";
    public static final String SYS_PROP_CONFIG_DECRYPT = "druid.config.decrypt";
    public static final String SYS_PROP_CONFIG_KEY = "druid.config.decrypt.key";

    @Override
    public void init(DataSourceProxy dataSourceProxy) {
        if (!(dataSourceProxy instanceof DruidDataSource)) {
            LOG.error("ConfigLoader only support DruidDataSource");
        }
        DruidDataSource dataSource = (DruidDataSource)dataSourceProxy;
        Properties connectinProperties = dataSource.getConnectProperties();
        Properties configFileProperties = this.loadPropertyFromConfigFile(connectinProperties);
        boolean decrypt = this.isDecrypt(connectinProperties, configFileProperties);
        if (configFileProperties == null) {
            if (decrypt) {
                this.decrypt(dataSource, null);
            }
            return;
        }
        if (decrypt) {
            this.decrypt(dataSource, configFileProperties);
        }
        try {
            DruidDataSourceFactory.config(dataSource, configFileProperties);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Config DataSource error.", e);
        }
    }

    public boolean isDecrypt(Properties connectinProperties, Properties configFileProperties) {
        boolean decrypt = false;
        String decrypterId = connectinProperties.getProperty(CONFIG_DECRYPT);
        if ((decrypterId == null || decrypterId.length() == 0) && configFileProperties != null) {
            decrypterId = configFileProperties.getProperty(CONFIG_DECRYPT);
        }
        if (decrypterId == null || decrypterId.length() == 0) {
            decrypterId = System.getProperty(SYS_PROP_CONFIG_DECRYPT);
        }
        if ("true".equals(decrypterId)) {
            decrypt = true;
        }
        return decrypt;
    }

    Properties loadPropertyFromConfigFile(Properties connectinProperties) {
        String configFile = connectinProperties.getProperty(CONFIG_FILE);
        if (configFile == null) {
            configFile = System.getProperty(SYS_PROP_CONFIG_FILE);
        }
        if (configFile != null && configFile.length() > 0) {
            Properties info;
            if (LOG.isInfoEnabled()) {
                LOG.info("DruidDataSource Config File load from : " + configFile);
            }
            if ((info = this.loadConfig(configFile)) == null) {
                throw new IllegalArgumentException("Cannot load remote config file from the [config.file=" + configFile + "].");
            }
            return info;
        }
        return null;
    }

    public void decrypt(DruidDataSource dataSource, Properties info) {
        try {
            String encryptedPassword = null;
            if (info != null) {
                encryptedPassword = info.getProperty("password");
            }
            if (encryptedPassword == null || encryptedPassword.length() == 0) {
                encryptedPassword = dataSource.getConnectProperties().getProperty("password");
            }
            if (encryptedPassword == null || encryptedPassword.length() == 0) {
                encryptedPassword = dataSource.getPassword();
            }
            PublicKey publicKey = this.getPublicKey(dataSource.getConnectProperties(), info);
            String passwordPlainText = ConfigTools.decrypt(publicKey, encryptedPassword);
            if (info != null) {
                info.setProperty("password", passwordPlainText);
            } else {
                dataSource.setPassword(passwordPlainText);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decrypt.", e);
        }
    }

    public PublicKey getPublicKey(Properties connectinProperties, Properties configFileProperties) {
        String key = connectinProperties.getProperty(CONFIG_KEY);
        if (StringUtils.isEmpty(key) && connectinProperties != null) {
            key = connectinProperties.getProperty(CONFIG_KEY);
        }
        if (StringUtils.isEmpty(key)) {
            key = System.getProperty(SYS_PROP_CONFIG_KEY);
        }
        return ConfigTools.getPublicKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadConfig(String filePath) {
        Properties properties;
        boolean xml;
        InputStream inStream;
        Properties properties2;
        block9: {
            properties2 = new Properties();
            inStream = null;
            xml = false;
            if (filePath.startsWith("http://") || filePath.startsWith("https://") || filePath.startsWith("file:/")) {
                URL url = new URL(filePath);
                inStream = url.openStream();
                xml = url.getPath().endsWith(".xml");
            } else {
                File file = new File(filePath);
                inStream = file.exists() ? new FileInputStream(file) : Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
                xml = filePath.endsWith(".xml");
            }
            if (inStream != null) break block9;
            LOG.error("load config file error, file : " + filePath);
            properties = null;
            JdbcUtils.close(inStream);
            return properties;
        }
        try {
            if (xml) {
                properties2.loadFromXML(inStream);
            } else {
                properties2.load(inStream);
            }
            properties = properties2;
        }
        catch (Exception ex) {
            try {
                LOG.error("load config file error, file : " + filePath, ex);
                properties = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(inStream);
                throw throwable;
            }
            JdbcUtils.close(inStream);
            return properties;
        }
        JdbcUtils.close(inStream);
        return properties;
    }
}

