/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ha.MultiConnectionHolder;
import com.alibaba.druid.pool.ha.MultiDataSource;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class DataSourceHolder
implements Closeable {
    private final MultiDataSource multiDataSource;
    private final DruidDataSource dataSource;
    private boolean enable = true;
    private final AtomicLong connectCount = new AtomicLong();
    private final AtomicLong connectErrorCount = new AtomicLong();
    private boolean fail = false;
    private int weight = 1;
    private transient int weightRegionBegin;
    private transient int weightRegionEnd;
    private boolean writable = true;

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public int getWeightRegionBegin() {
        return this.weightRegionBegin;
    }

    public void setWeightRegionBegin(int weightRegionBegin) {
        this.weightRegionBegin = weightRegionBegin;
    }

    public int getWeightRegionEnd() {
        return this.weightRegionEnd;
    }

    public void setWeightRegionEnd(int weightReginEnd) {
        this.weightRegionEnd = weightReginEnd;
    }

    public DataSourceHolder(MultiDataSource multiDataSource, DruidDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource is null");
        }
        this.multiDataSource = multiDataSource;
        this.dataSource = dataSource;
    }

    public void resetState() {
        this.connectCount.set(0L);
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isEnable() {
        return this.enable && !this.fail;
    }

    public void setEnable(boolean enable) {
        if (this.enable != enable) {
            this.enable = enable;
            this.multiDataSource.afterDataSourceChanged(null);
        }
    }

    public boolean isFail() {
        return this.fail;
    }

    public void setFail(boolean fail) {
        if (this.fail != fail) {
            this.fail = fail;
            this.multiDataSource.afterDataSourceChanged(null);
        }
    }

    public DruidDataSource getDataSource() {
        return this.dataSource;
    }

    public long getConnectCount() {
        return this.connectCount.get();
    }

    public void incrementConnectCount() {
        this.connectCount.incrementAndGet();
    }

    public String getUrl() {
        return this.dataSource.getUrl();
    }

    public MultiConnectionHolder getConnection() throws SQLException {
        this.connectCount.incrementAndGet();
        try {
            DruidPooledConnection conn = this.dataSource.getConnection();
            return new MultiConnectionHolder(this, conn);
        }
        catch (SQLException ex) {
            this.connectErrorCount.incrementAndGet();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.connectErrorCount.incrementAndGet();
            throw ex;
        }
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    public void restart() {
        this.dataSource.restart();
    }
}

