/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.balance;

import com.alibaba.druid.pool.ha.DataSourceChangedEvent;
import com.alibaba.druid.pool.ha.DataSourceHolder;
import com.alibaba.druid.pool.ha.MultiConnectionHolder;
import com.alibaba.druid.pool.ha.MultiDataSource;
import com.alibaba.druid.pool.ha.MultiDataSourceConnection;
import com.alibaba.druid.pool.ha.balance.AbstractBalancer;
import com.alibaba.druid.util.ThreadLocalRandom;
import java.sql.SQLException;

public class WeightBalancer
extends AbstractBalancer {
    private int totalWeight = 0;

    @Override
    public void afterDataSourceChanged(DataSourceChangedEvent event) {
        this.computeTotalWeight();
    }

    public int produceRandomNumber() {
        if (this.totalWeight == 0) {
            return 0;
        }
        return ThreadLocalRandom.current().nextInt(this.totalWeight);
    }

    public void computeTotalWeight() {
        int totalWeight = 0;
        for (DataSourceHolder holder : this.getMultiDataSource().getDataSources().values()) {
            if (!holder.isEnable()) {
                holder.setWeightRegionBegin(-1);
                holder.setWeightRegionEnd(-1);
                continue;
            }
            holder.setWeightRegionBegin(totalWeight);
            holder.setWeightRegionEnd(totalWeight += holder.getWeight());
        }
        this.totalWeight = totalWeight;
        this.getMultiDataSource().notFailSignal();
    }

    @Override
    public MultiConnectionHolder getConnection(MultiDataSourceConnection conn, String sql) throws SQLException {
        MultiDataSource multiDataSource = conn.getMultiDataSource();
        DataSourceHolder dataSource = null;
        int randomNumber = this.produceRandomNumber();
        DataSourceHolder first = null;
        for (DataSourceHolder item : multiDataSource.getDataSources().values()) {
            if (!item.isEnable()) continue;
            if (first == null) {
                first = item;
            }
            if (randomNumber < item.getWeightRegionBegin() || randomNumber >= item.getWeightRegionEnd() || !item.isEnable()) continue;
            if (item.getDataSource().isBusy()) {
                multiDataSource.incrementBusySkipCount();
                break;
            }
            dataSource = item;
        }
        if (dataSource == null) {
            dataSource = first;
        }
        if (dataSource == null) {
            throw new SQLException("cannot get connection. enabledDataSourceCount " + multiDataSource.getEnabledDataSourceCount());
        }
        return dataSource.getConnection();
    }
}

