/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAddColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAddIndex;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAddUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableCharacter;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableOption;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlBinlogStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCommitStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateIndexStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDescribeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDropTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDropUser;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDropViewStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExecuteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHelpStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadDataInFileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadXmlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLockTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlResetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRollbackStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetCharSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetNamesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetTransactionIsolationLevelStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowAuthorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinaryLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCharacterSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCollationStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowContributorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTriggerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateViewStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEngineStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEnginesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowErrorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowGrantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowIndexesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowKeysStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowOpenTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPluginsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPrivilegesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcessListStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfilesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowRelayLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveHostsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTableStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTriggersStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowVariantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowWarningsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStartTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnlockTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlCreateTableParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class MySqlStatementParser
extends SQLStatementParser {
    private static final String COLLATE2 = "COLLATE";
    private static final String CASCADE = "CASCADE";
    private static final String RESTRICT = "RESTRICT";
    private static final String CHAIN = "CHAIN";
    private static final String ENGINES = "ENGINES";
    private static final String ENGINE = "ENGINE";
    private static final String BINLOG = "BINLOG";
    private static final String EVENTS = "EVENTS";
    private static final String CHARACTER = "CHARACTER";
    private static final String SESSION = "SESSION";
    private static final String GLOBAL = "GLOBAL";
    private static final String VARIABLES = "VARIABLES";
    private static final String ERRORS = "ERRORS";
    private static final String STATUS = "STATUS";
    private static final String IGNORE = "IGNORE";
    private static final String RESET = "RESET";
    private static final String DESCRIBE = "DESCRIBE";
    private static final String DESC = "DESC";
    private static final String WRITE = "WRITE";
    private static final String READ = "READ";
    private static final String LOCAL = "LOCAL";
    private static final String TABLES = "TABLES";
    private static final String TEMPORARY = "TEMPORARY";
    private static final String USER = "USER";
    private static final String SPATIAL = "SPATIAL";
    private static final String FULLTEXT = "FULLTEXT";
    private static final String REPLACE = "REPLACE";
    private static final String DELAYED = "DELAYED";
    private static final String LOW_PRIORITY = "LOW_PRIORITY";

    public MySqlStatementParser(String sql) {
        super(new MySqlExprParser(sql));
    }

    public MySqlStatementParser(Lexer lexer) {
        super(new MySqlExprParser(lexer));
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        MySqlCreateTableParser parser = new MySqlCreateTableParser(this.exprParser);
        return parser.parseCrateTable();
    }

    @Override
    public SQLSelectStatement parseSelect() {
        return new SQLSelectStatement(new MySqlSelectParser(this.exprParser).select());
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        MySqlUpdateStatement stmt = this.createUpdateStatement();
        if (this.lexer.token() == Token.UPDATE) {
            this.lexer.nextToken();
            if (this.identifierEquals(LOW_PRIORITY)) {
                this.lexer.nextToken();
                stmt.setLowPriority(true);
            }
            if (this.identifierEquals(IGNORE)) {
                this.lexer.nextToken();
                stmt.setIgnore(true);
            }
            SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
            stmt.setTableSource(tableSource);
        }
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = new SQLUpdateSetItem();
            item.setColumn(this.exprParser.name());
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            } else {
                this.accept(Token.COLONEQ);
            }
            item.setValue(this.exprParser.expr());
            stmt.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            stmt.setWhere(this.exprParser.expr());
        }
        stmt.setOrderBy(this.exprParser.parseOrderBy());
        stmt.setLimit(this.parseLimit());
        return stmt;
    }

    @Override
    protected MySqlUpdateStatement createUpdateStatement() {
        return new MySqlUpdateStatement();
    }

    @Override
    public MySqlDeleteStatement parseDeleteStatement() {
        MySqlDeleteStatement deleteStatement = new MySqlDeleteStatement();
        if (this.lexer.token() == Token.DELETE) {
            SQLTableSource tableSource;
            this.lexer.nextToken();
            if (this.identifierEquals(LOW_PRIORITY)) {
                deleteStatement.setLowPriority(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("QUICK")) {
                deleteStatement.setQuick(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals(IGNORE)) {
                deleteStatement.setIgnore(true);
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                deleteStatement.setTableSource(this.createSQLSelectParser().parseTableSource());
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    tableSource = this.createSQLSelectParser().parseTableSource();
                    deleteStatement.setFrom(tableSource);
                }
            } else if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                deleteStatement.setTableSource(this.createSQLSelectParser().parseTableSource());
            }
            if (this.identifierEquals("USING")) {
                this.lexer.nextToken();
                tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setUsing(tableSource);
            }
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            deleteStatement.setOrderBy(orderBy);
        }
        deleteStatement.setLimit(this.parseLimit());
        return deleteStatement;
    }

    @Override
    public SQLStatement parseCreate() {
        this.accept(Token.CREATE);
        List<SQLCommentHint> hints = this.exprParser.parseHints();
        if (this.lexer.token() == Token.TABLE || this.identifierEquals(TEMPORARY)) {
            MySqlCreateTableParser parser = new MySqlCreateTableParser(this.exprParser);
            MySqlCreateTableStatement stmt = parser.parseCrateTable(false);
            stmt.setHints(hints);
            return stmt;
        }
        if (this.lexer.token() == Token.DATABASE) {
            return this.parseCreateDatabase();
        }
        if (this.lexer.token() == Token.UNIQUE || this.lexer.token() == Token.INDEX || this.identifierEquals(FULLTEXT) || this.identifierEquals(SPATIAL)) {
            return this.parseCreateIndex();
        }
        if (this.identifierEquals(USER)) {
            return this.parseCreateUser();
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateIndex() {
        MySqlCreateIndexStatement stmt = new MySqlCreateIndexStatement();
        if (this.lexer.token() == Token.UNIQUE) {
            stmt.setType("UNIQUE");
            this.lexer.nextToken();
        } else if (this.identifierEquals(FULLTEXT)) {
            stmt.setType(FULLTEXT);
            this.lexer.nextToken();
        } else if (this.identifierEquals(SPATIAL)) {
            stmt.setType(SPATIAL);
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        stmt.setName(this.exprParser.name());
        this.parseCreateIndexUsing(stmt);
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            stmt.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        this.parseCreateIndexUsing(stmt);
        return stmt;
    }

    private void parseCreateIndexUsing(MySqlCreateIndexStatement stmt) {
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            if (this.identifierEquals("BTREE")) {
                stmt.setUsing("BTREE");
                this.lexer.nextToken();
            } else if (this.identifierEquals("HASH")) {
                stmt.setUsing("HASH");
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
        }
    }

    public SQLStatement parseCreateUser() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier(USER);
        MySqlCreateUserStatement stmt = new MySqlCreateUserStatement();
        while (true) {
            MySqlCreateUserStatement.UserSpecification userSpec = new MySqlCreateUserStatement.UserSpecification();
            SQLExpr expr = this.exprParser.primary();
            userSpec.setUser(expr);
            if (this.lexer.token() == Token.IDENTIFIED) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.BY) {
                    this.lexer.nextToken();
                    if (this.identifierEquals("PASSWORD")) {
                        this.lexer.nextToken();
                    }
                    SQLCharExpr password = (SQLCharExpr)this.exprParser.expr();
                    userSpec.setPassword(password);
                } else if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    SQLCharExpr text = (SQLCharExpr)this.exprParser.expr();
                    userSpec.setAuthPlugin(text);
                }
            }
            stmt.getUsers().add(userSpec);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseKill() {
        this.accept(Token.KILL);
        MySqlKillStatement stmt = new MySqlKillStatement();
        if (this.identifierEquals("CONNECTION")) {
            stmt.setType(MySqlKillStatement.Type.CONNECTION);
            this.lexer.nextToken();
        } else if (this.identifierEquals("QUERY")) {
            stmt.setType(MySqlKillStatement.Type.QUERY);
            this.lexer.nextToken();
        } else {
            throw new ParserException("not support kill type " + (Object)((Object)this.lexer.token()));
        }
        SQLExpr threadId = this.exprParser.expr();
        stmt.setThreadId(threadId);
        return stmt;
    }

    public SQLStatement parseBinlog() {
        this.acceptIdentifier("binlog");
        MySqlBinlogStatement stmt = new MySqlBinlogStatement();
        SQLExpr expr = this.exprParser.expr();
        stmt.setExpr(expr);
        return stmt;
    }

    public SQLStatement parseReset() {
        this.acceptIdentifier(RESET);
        MySqlResetStatement stmt = new MySqlResetStatement();
        while (this.lexer.token() == Token.IDENTIFIER) {
            if (this.identifierEquals("QUERY")) {
                this.lexer.nextToken();
                this.acceptIdentifier("CACHE");
                stmt.getOptions().add("QUERY CACHE");
            } else {
                stmt.getOptions().add(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.KILL) {
            SQLStatement stmt = this.parseKill();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("PREPARE")) {
            MySqlPrepareStatement stmt = this.parsePrepare();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("EXECUTE")) {
            MySqlExecuteStatement stmt = this.parseExecute();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("LOAD")) {
            SQLStatement stmt = this.parseLoad();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals(REPLACE)) {
            MySqlReplaceStatement stmt = this.parseReplicate();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("START")) {
            MySqlStartTransactionStatement stmt = this.parseStart();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("SHOW")) {
            SQLStatement stmt = this.parseShow();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals(BINLOG)) {
            SQLStatement stmt = this.parseBinlog();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals(RESET)) {
            SQLStatement stmt = this.parseReset();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("HELP")) {
            this.lexer.nextToken();
            MySqlHelpStatement stmt = new MySqlHelpStatement();
            stmt.setContent(this.exprParser.primary());
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals(DESC) || this.identifierEquals(DESCRIBE)) {
            MySqlDescribeStatement stmt = this.parseDescribe();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.LOCK) {
            this.lexer.nextToken();
            this.acceptIdentifier(TABLES);
            MySqlLockTableStatement stmt = new MySqlLockTableStatement();
            stmt.setTableSource(this.exprParser.name());
            if (this.identifierEquals(READ)) {
                this.lexer.nextToken();
                if (this.identifierEquals(LOCAL)) {
                    this.lexer.nextToken();
                    stmt.setLockType(MySqlLockTableStatement.LockType.READ_LOCAL);
                } else {
                    stmt.setLockType(MySqlLockTableStatement.LockType.READ);
                }
            } else if (this.identifierEquals(WRITE)) {
                stmt.setLockType(MySqlLockTableStatement.LockType.WRITE);
            } else if (this.identifierEquals(LOW_PRIORITY)) {
                this.lexer.nextToken();
                this.acceptIdentifier(WRITE);
                stmt.setLockType(MySqlLockTableStatement.LockType.LOW_PRIORITY_WRITE);
            }
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("UNLOCK")) {
            this.lexer.nextToken();
            this.acceptIdentifier(TABLES);
            statementList.add(new MySqlUnlockTablesStatement());
            return true;
        }
        return false;
    }

    public MySqlDescribeStatement parseDescribe() {
        if (this.lexer.token() != Token.DESC && !this.identifierEquals(DESCRIBE)) {
            throw new ParserException("expect DESC, actual " + (Object)((Object)this.lexer.token()));
        }
        this.lexer.nextToken();
        MySqlDescribeStatement stmt = new MySqlDescribeStatement();
        stmt.setObject(this.exprParser.name());
        return stmt;
    }

    @Override
    public SQLStatement parseShow() {
        this.acceptIdentifier("SHOW");
        if (this.lexer.token() == Token.FULL) {
            this.lexer.nextToken();
            if (this.identifierEquals("PROCESSLIST")) {
                this.lexer.nextToken();
                MySqlShowProcessListStatement stmt = new MySqlShowProcessListStatement();
                stmt.setFull(true);
                return stmt;
            }
            this.acceptIdentifier("COLUMNS");
            MySqlShowColumnsStatement stmt = this.parseShowColumns();
            stmt.setFull(true);
            return stmt;
        }
        if (this.identifierEquals("COLUMNS")) {
            this.lexer.nextToken();
            MySqlShowColumnsStatement stmt = this.parseShowColumns();
            return stmt;
        }
        if (this.identifierEquals(TABLES)) {
            this.lexer.nextToken();
            MySqlShowTablesStatement stmt = this.parseShowTabless();
            return stmt;
        }
        if (this.identifierEquals("DATABASES")) {
            this.lexer.nextToken();
            MySqlShowDatabasesStatement stmt = this.parseShowDatabases();
            return stmt;
        }
        if (this.identifierEquals("WARNINGS")) {
            this.lexer.nextToken();
            MySqlShowWarningsStatement stmt = this.parseShowWarnings();
            return stmt;
        }
        if (this.identifierEquals("COUNT")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.accept(Token.STAR);
            this.accept(Token.RPAREN);
            if (this.identifierEquals(ERRORS)) {
                this.lexer.nextToken();
                MySqlShowErrorsStatement stmt = new MySqlShowErrorsStatement();
                stmt.setCount(true);
                return stmt;
            }
            this.acceptIdentifier("WARNINGS");
            MySqlShowWarningsStatement stmt = new MySqlShowWarningsStatement();
            stmt.setCount(true);
            return stmt;
        }
        if (this.identifierEquals(ERRORS)) {
            this.lexer.nextToken();
            MySqlShowErrorsStatement stmt = new MySqlShowErrorsStatement();
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals(STATUS)) {
            this.lexer.nextToken();
            MySqlShowStatusStatement stmt = this.parseShowStatus();
            return stmt;
        }
        if (this.identifierEquals(VARIABLES)) {
            this.lexer.nextToken();
            MySqlShowVariantsStatement stmt = this.parseShowVariants();
            return stmt;
        }
        if (this.identifierEquals(GLOBAL)) {
            this.lexer.nextToken();
            if (this.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                MySqlShowStatusStatement stmt = this.parseShowStatus();
                stmt.setGlobal(true);
                return stmt;
            }
            if (this.identifierEquals(VARIABLES)) {
                this.lexer.nextToken();
                MySqlShowVariantsStatement stmt = this.parseShowVariants();
                stmt.setGlobal(true);
                return stmt;
            }
        }
        if (this.identifierEquals(SESSION)) {
            this.lexer.nextToken();
            if (this.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                MySqlShowStatusStatement stmt = this.parseShowStatus();
                stmt.setSession(true);
                return stmt;
            }
            if (this.identifierEquals(VARIABLES)) {
                this.lexer.nextToken();
                MySqlShowVariantsStatement stmt = this.parseShowVariants();
                stmt.setSession(true);
                return stmt;
            }
        }
        if (this.identifierEquals("COBAR_STATUS")) {
            this.lexer.nextToken();
            return new CobarShowStatus();
        }
        if (this.identifierEquals("AUTHORS")) {
            this.lexer.nextToken();
            return new MySqlShowAuthorsStatement();
        }
        if (this.identifierEquals("BINARY")) {
            this.lexer.nextToken();
            this.acceptIdentifier("LOGS");
            return new MySqlShowBinaryLogsStatement();
        }
        if (this.identifierEquals("MASTER")) {
            this.lexer.nextToken();
            if (this.identifierEquals("LOGS")) {
                this.lexer.nextToken();
                return new MySqlShowMasterLogsStatement();
            }
            this.acceptIdentifier(STATUS);
            return new MySqlShowMasterStatusStatement();
        }
        if (this.identifierEquals(CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            MySqlShowCharacterSetStatement stmt = new MySqlShowCharacterSetStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setPattern(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("COLLATION")) {
            this.lexer.nextToken();
            MySqlShowCollationStatement stmt = new MySqlShowCollationStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setPattern(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals(BINLOG)) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowBinLogEventsStatement stmt = new MySqlShowBinLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setIn(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.expr());
            }
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals("CONTRIBUTORS")) {
            this.lexer.nextToken();
            return new MySqlShowContributorsStatement();
        }
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DATABASE) {
                this.lexer.nextToken();
                MySqlShowCreateDatabaseStatement stmt = new MySqlShowCreateDatabaseStatement();
                stmt.setDatabase(this.exprParser.name());
                return stmt;
            }
            if (this.identifierEquals("EVENT")) {
                this.lexer.nextToken();
                MySqlShowCreateEventStatement stmt = new MySqlShowCreateEventStatement();
                stmt.setEventName(this.exprParser.name());
                return stmt;
            }
            if (this.identifierEquals("FUNCTION")) {
                this.lexer.nextToken();
                MySqlShowCreateFunctionStatement stmt = new MySqlShowCreateFunctionStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.identifierEquals("PROCEDURE")) {
                this.lexer.nextToken();
                MySqlShowCreateProcedureStatement stmt = new MySqlShowCreateProcedureStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                MySqlShowCreateTableStatement stmt = new MySqlShowCreateTableStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.VIEW) {
                this.lexer.nextToken();
                MySqlShowCreateViewStatement stmt = new MySqlShowCreateViewStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.identifierEquals("TRIGGER")) {
                this.lexer.nextToken();
                MySqlShowCreateTriggerStatement stmt = new MySqlShowCreateTriggerStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            throw new ParserException("TODO " + this.lexer.stringVal());
        }
        if (this.identifierEquals(ENGINE)) {
            this.lexer.nextToken();
            MySqlShowEngineStatement stmt = new MySqlShowEngineStatement();
            stmt.setName(this.exprParser.name());
            stmt.setOption(MySqlShowEngineStatement.Option.valueOf(this.lexer.stringVal().toUpperCase()));
            this.lexer.nextToken();
            return stmt;
        }
        if (this.identifierEquals("STORAGE")) {
            this.lexer.nextToken();
            this.acceptIdentifier(ENGINES);
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            stmt.setStorage(true);
            return stmt;
        }
        if (this.identifierEquals(ENGINES)) {
            this.lexer.nextToken();
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            return stmt;
        }
        if (this.identifierEquals(EVENTS)) {
            this.lexer.nextToken();
            MySqlShowEventsStatement stmt = new MySqlShowEventsStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setSchema(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("FUNCTION")) {
            this.lexer.nextToken();
            if (this.identifierEquals("CODE")) {
                this.lexer.nextToken();
                MySqlShowFunctionCodeStatement stmt = new MySqlShowFunctionCodeStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            this.acceptIdentifier(STATUS);
            MySqlShowFunctionStatusStatement stmt = new MySqlShowFunctionStatusStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals(ENGINE)) {
            this.lexer.nextToken();
            MySqlShowEngineStatement stmt = new MySqlShowEngineStatement();
            stmt.setName(this.exprParser.name());
            stmt.setOption(MySqlShowEngineStatement.Option.valueOf(this.lexer.stringVal().toUpperCase()));
            this.lexer.nextToken();
            return stmt;
        }
        if (this.identifierEquals("STORAGE")) {
            this.lexer.nextToken();
            this.acceptIdentifier(ENGINES);
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            stmt.setStorage(true);
            return stmt;
        }
        if (this.identifierEquals(ENGINES)) {
            this.lexer.nextToken();
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            return stmt;
        }
        if (this.identifierEquals("GRANTS")) {
            this.lexer.nextToken();
            MySqlShowGrantsStatement stmt = new MySqlShowGrantsStatement();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                stmt.setUser(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.token() == Token.INDEX || this.identifierEquals("INDEXES")) {
            this.lexer.nextToken();
            MySqlShowIndexesStatement stmt = new MySqlShowIndexesStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                SQLName table = this.exprParser.name();
                stmt.setTable(table);
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName database = this.exprParser.name();
                    stmt.setDatabase(database);
                }
            }
            return stmt;
        }
        if (this.identifierEquals("KEYS")) {
            this.lexer.nextToken();
            MySqlShowKeysStatement stmt = new MySqlShowKeysStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                SQLName table = this.exprParser.name();
                stmt.setTable(table);
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName database = this.exprParser.name();
                    stmt.setDatabase(database);
                }
            }
            return stmt;
        }
        if (this.identifierEquals("OPEN")) {
            this.lexer.nextToken();
            this.acceptIdentifier(TABLES);
            MySqlShowOpenTablesStatement stmt = new MySqlShowOpenTablesStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("PLUGINS")) {
            this.lexer.nextToken();
            MySqlShowPluginsStatement stmt = new MySqlShowPluginsStatement();
            return stmt;
        }
        if (this.identifierEquals("PRIVILEGES")) {
            this.lexer.nextToken();
            MySqlShowPrivilegesStatement stmt = new MySqlShowPrivilegesStatement();
            return stmt;
        }
        if (this.identifierEquals("PROCEDURE")) {
            this.lexer.nextToken();
            if (this.identifierEquals("CODE")) {
                this.lexer.nextToken();
                MySqlShowProcedureCodeStatement stmt = new MySqlShowProcedureCodeStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            this.acceptIdentifier(STATUS);
            MySqlShowProcedureStatusStatement stmt = new MySqlShowProcedureStatusStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("PROCESSLIST")) {
            this.lexer.nextToken();
            MySqlShowProcessListStatement stmt = new MySqlShowProcessListStatement();
            return stmt;
        }
        if (this.identifierEquals("PROFILES")) {
            this.lexer.nextToken();
            MySqlShowProfilesStatement stmt = new MySqlShowProfilesStatement();
            return stmt;
        }
        if (this.identifierEquals("PROFILE")) {
            this.lexer.nextToken();
            MySqlShowProfileStatement stmt = new MySqlShowProfileStatement();
            while (true) {
                if (this.lexer.token() == Token.ALL) {
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.ALL);
                    this.lexer.nextToken();
                } else if (this.identifierEquals("BLOCK")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("IO");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.BLOCK_IO);
                } else if (this.identifierEquals("CONTEXT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("SWITCHES");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.CONTEXT_SWITCHES);
                } else if (this.identifierEquals("CPU")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.CPU);
                } else if (this.identifierEquals("IPC")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.IPC);
                } else if (this.identifierEquals("MEMORY")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.MEMORY);
                } else if (this.identifierEquals("PAGE")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("FAULTS");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.PAGE_FAULTS);
                } else if (this.identifierEquals("SOURCE")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.SOURCE);
                } else {
                    if (!this.identifierEquals("SWAPS")) break;
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.SWAPS);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                this.acceptIdentifier("QUERY");
                stmt.setForQuery(this.exprParser.primary());
            }
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals("RELAYLOG")) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowRelayLogEventsStatement stmt = new MySqlShowRelayLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setLogName(this.exprParser.primary());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.primary());
            }
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals("RELAYLOG")) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowRelayLogEventsStatement stmt = new MySqlShowRelayLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setLogName(this.exprParser.primary());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.primary());
            }
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals("SLAVE")) {
            this.lexer.nextToken();
            if (this.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                return new MySqlShowSlaveStatusStatement();
            }
            this.acceptIdentifier("HOSTS");
            MySqlShowSlaveHostsStatement stmt = new MySqlShowSlaveHostsStatement();
            return stmt;
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            this.acceptIdentifier(STATUS);
            MySqlShowTableStatusStatement stmt = new MySqlShowTableStatusStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("TRIGGERS")) {
            this.lexer.nextToken();
            MySqlShowTriggersStatement stmt = new MySqlShowTriggersStatement();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                SQLExpr like = this.exprParser.expr();
                stmt.setLike(like);
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                SQLExpr where = this.exprParser.expr();
                stmt.setWhere(where);
            }
            return stmt;
        }
        throw new ParserException("TODO " + this.lexer.stringVal());
    }

    private MySqlShowStatusStatement parseShowStatus() {
        MySqlShowStatusStatement stmt = new MySqlShowStatusStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowVariantsStatement parseShowVariants() {
        MySqlShowVariantsStatement stmt = new MySqlShowVariantsStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowWarningsStatement parseShowWarnings() {
        MySqlShowWarningsStatement stmt = new MySqlShowWarningsStatement();
        stmt.setLimit(this.parseLimit());
        return stmt;
    }

    private MySqlShowDatabasesStatement parseShowDatabases() {
        MySqlShowDatabasesStatement stmt = new MySqlShowDatabasesStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowTablesStatement parseShowTabless() {
        MySqlShowTablesStatement stmt = new MySqlShowTablesStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLName database = this.exprParser.name();
            stmt.setDatabase(database);
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowColumnsStatement parseShowColumns() {
        MySqlShowColumnsStatement stmt = new MySqlShowColumnsStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLName table = this.exprParser.name();
            stmt.setTable(table);
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    public MySqlStartTransactionStatement parseStart() {
        this.acceptIdentifier("START");
        this.acceptIdentifier("TRANSACTION");
        MySqlStartTransactionStatement stmt = new MySqlStartTransactionStatement();
        if (this.identifierEquals("WITH")) {
            this.lexer.nextToken();
            this.acceptIdentifier("CONSISTENT");
            this.acceptIdentifier("SNAPSHOT");
            stmt.setConsistentSnapshot(true);
        }
        if (this.identifierEquals("BEGIN")) {
            this.lexer.nextToken();
            stmt.setBegin(true);
            if (this.identifierEquals("WORK")) {
                this.lexer.nextToken();
                stmt.setWork(true);
            }
        }
        return stmt;
    }

    @Override
    public MySqlRollbackStatement parseRollback() {
        this.acceptIdentifier("ROLLBACK");
        MySqlRollbackStatement stmt = new MySqlRollbackStatement();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.FALSE);
            } else {
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.TRUE);
            }
        }
        if (this.identifierEquals("TO")) {
            this.lexer.nextToken();
            if (this.identifierEquals("SAVEPOINT")) {
                this.lexer.nextToken();
            }
            stmt.setTo(this.exprParser.name());
        }
        return stmt;
    }

    @Override
    public MySqlCommitStatement parseCommit() {
        this.acceptIdentifier("COMMIT");
        MySqlCommitStatement stmt = new MySqlCommitStatement();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.FALSE);
            } else {
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.TRUE);
            }
        }
        return stmt;
    }

    public MySqlReplaceStatement parseReplicate() {
        SQLInsertStatement.ValuesClause values;
        SQLQueryExpr queryExpr;
        MySqlReplaceStatement stmt = new MySqlReplaceStatement();
        this.acceptIdentifier(REPLACE);
        if (this.identifierEquals(LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(DELAYED)) {
            stmt.setDelayed(true);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        }
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                queryExpr = (SQLQueryExpr)this.exprParser.expr();
                stmt.setQuery(queryExpr);
            } else {
                this.exprParser.exprList(stmt.getColumns());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.identifierEquals("VALUE")) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                values = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(values.getValues());
                stmt.getValuesList().add(values);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            values = new SQLInsertStatement.ValuesClause();
            stmt.getValuesList().add(values);
            while (true) {
                stmt.getColumns().add(this.exprParser.name());
                if (this.lexer.token() == Token.COLONEQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.EQ);
                }
                values.getValues().add(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    protected SQLStatement parseLoad() {
        this.acceptIdentifier("LOAD");
        if (this.identifierEquals("DATA")) {
            MySqlLoadDataInFileStatement stmt = this.parseLoadDataInFile();
            return stmt;
        }
        if (this.identifierEquals("XML")) {
            MySqlLoadXmlStatement stmt = this.parseLoadXml();
            return stmt;
        }
        throw new ParserException("TODO");
    }

    protected MySqlLoadXmlStatement parseLoadXml() {
        this.acceptIdentifier("XML");
        MySqlLoadXmlStatement stmt = new MySqlLoadXmlStatement();
        if (this.identifierEquals(LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("CONCURRENT")) {
            stmt.setConcurrent(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(LOCAL)) {
            stmt.setLocal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("INFILE");
        SQLLiteralExpr fileName = (SQLLiteralExpr)this.exprParser.expr();
        stmt.setFileName(fileName);
        if (this.identifierEquals(REPLACE)) {
            stmt.setReplicate(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(IGNORE)) {
            stmt.setIgnore(true);
            this.lexer.nextToken();
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.identifierEquals(CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException("syntax error, illegal charset");
            }
            String charset = this.lexer.stringVal();
            this.lexer.nextToken();
            stmt.setCharset(charset);
        }
        if (this.identifierEquals("ROWS")) {
            this.lexer.nextToken();
            this.accept(Token.IDENTIFIED);
            this.accept(Token.BY);
            SQLExpr rowsIdentifiedBy = this.exprParser.expr();
            stmt.setRowsIdentifiedBy(rowsIdentifiedBy);
        }
        if (this.identifierEquals(IGNORE)) {
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.SET) {
            throw new ParserException("TODO");
        }
        return stmt;
    }

    protected MySqlLoadDataInFileStatement parseLoadDataInFile() {
        this.acceptIdentifier("DATA");
        MySqlLoadDataInFileStatement stmt = new MySqlLoadDataInFileStatement();
        if (this.identifierEquals(LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("CONCURRENT")) {
            stmt.setConcurrent(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(LOCAL)) {
            stmt.setLocal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("INFILE");
        SQLLiteralExpr fileName = (SQLLiteralExpr)this.exprParser.expr();
        stmt.setFileName(fileName);
        if (this.identifierEquals(REPLACE)) {
            stmt.setReplicate(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(IGNORE)) {
            stmt.setIgnore(true);
            this.lexer.nextToken();
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.identifierEquals(CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException("syntax error, illegal charset");
            }
            String charset = this.lexer.stringVal();
            this.lexer.nextToken();
            stmt.setCharset(charset);
        }
        if (this.identifierEquals("FIELDS") || this.identifierEquals("COLUMNS")) {
            throw new ParserException("TODO");
        }
        if (this.identifierEquals("LINES")) {
            throw new ParserException("TODO");
        }
        if (this.identifierEquals(IGNORE)) {
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.SET) {
            throw new ParserException("TODO");
        }
        return stmt;
    }

    public MySqlPrepareStatement parsePrepare() {
        this.acceptIdentifier("PREPARE");
        SQLName name = this.exprParser.name();
        this.accept(Token.FROM);
        SQLExpr from = this.exprParser.expr();
        return new MySqlPrepareStatement(name, from);
    }

    public MySqlExecuteStatement parseExecute() {
        this.acceptIdentifier("EXECUTE");
        MySqlExecuteStatement stmt = new MySqlExecuteStatement();
        SQLName statementName = this.exprParser.name();
        stmt.setStatementName(statementName);
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters());
        }
        return stmt;
    }

    @Override
    public SQLInsertStatement parseInsert() {
        SQLInsertStatement.ValuesClause values;
        SQLSelect select;
        MySqlInsertStatement insertStatement = new MySqlInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            if (this.identifierEquals(LOW_PRIORITY)) {
                insertStatement.setLowPriority(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals(DELAYED)) {
                insertStatement.setDelayed(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("HIGH_PRIORITY")) {
                insertStatement.setHighPriority(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals(IGNORE)) {
                insertStatement.setIgnore(true);
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token() == Token.IDENTIFIER && !this.identifierEquals("VALUE")) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                select = this.exprParser.createSelectParser().select();
                select.setParent(insertStatement);
                insertStatement.setQuery(select);
            } else {
                this.exprParser.exprList(insertStatement.getColumns());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.identifierEquals("VALUE")) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                values = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(values.getValues());
                insertStatement.getValuesList().add(values);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            values = new SQLInsertStatement.ValuesClause();
            insertStatement.getValuesList().add(values);
            while (true) {
                SQLName name = this.exprParser.name();
                insertStatement.getColumns().add(name);
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.COLONEQ);
                }
                values.getValues().add(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            select = this.exprParser.createSelectParser().select();
            select.setParent(insertStatement);
            insertStatement.setQuery(select);
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            select = this.exprParser.createSelectParser().select();
            select.setParent(insertStatement);
            insertStatement.setQuery(select);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier("DUPLICATE");
            this.accept(Token.KEY);
            this.accept(Token.UPDATE);
            this.exprParser.exprList(insertStatement.getDuplicateKeyUpdate());
        }
        return insertStatement;
    }

    @Override
    public SQLStatement parseDropUser() {
        this.acceptIdentifier(USER);
        MySqlDropUser stmt = new MySqlDropUser();
        while (true) {
            SQLExpr expr = this.exprParser.expr();
            stmt.getUsers().add(expr);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    protected SQLDropTableStatement parseDropTable(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        MySqlDropTableStatement stmt = new MySqlDropTableStatement();
        if (this.identifierEquals(TEMPORARY)) {
            this.lexer.nextToken();
            stmt.setTemporary(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addTableSource(name);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.identifierEquals(RESTRICT)) {
            stmt.setOption(RESTRICT);
            this.lexer.nextToken();
        } else if (this.identifierEquals(CASCADE)) {
            stmt.setOption(CASCADE);
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    protected SQLDropViewStatement parseDropView(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        MySqlDropViewStatement stmt = new MySqlDropViewStatement();
        this.accept(Token.VIEW);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addTableSource(name);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.identifierEquals(RESTRICT)) {
            stmt.setOption(RESTRICT);
            this.lexer.nextToken();
        } else if (this.identifierEquals(CASCADE)) {
            stmt.setOption(CASCADE);
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new MySqlSelectParser(this.exprParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLStatement parseSet() {
        this.accept(Token.SET);
        Boolean global = null;
        if (this.identifierEquals(GLOBAL)) {
            global = Boolean.TRUE;
            this.lexer.nextToken();
        } else if (this.identifierEquals(SESSION)) {
            global = Boolean.FALSE;
            this.lexer.nextToken();
        }
        if (this.identifierEquals("TRANSACTION")) {
            this.lexer.nextToken();
            this.acceptIdentifier("ISOLATION");
            this.acceptIdentifier("LEVEL");
            MySqlSetTransactionIsolationLevelStatement stmt = new MySqlSetTransactionIsolationLevelStatement();
            stmt.setGlobal(global);
            if (this.identifierEquals(READ)) {
                this.lexer.nextToken();
                if (this.identifierEquals("UNCOMMITTED")) {
                    stmt.setLevel("READ UNCOMMITTED");
                    this.lexer.nextToken();
                    return stmt;
                } else if (this.identifierEquals(WRITE)) {
                    stmt.setLevel("READ WRITE");
                    this.lexer.nextToken();
                    return stmt;
                } else if (this.identifierEquals("ONLY")) {
                    stmt.setLevel("READ ONLY");
                    this.lexer.nextToken();
                    return stmt;
                } else {
                    if (!this.identifierEquals("COMMITTED")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                    stmt.setLevel("READ COMMITTED");
                    this.lexer.nextToken();
                }
                return stmt;
            } else if (this.identifierEquals("SERIALIZABLE")) {
                stmt.setLevel("SERIALIZABLE");
                this.lexer.nextToken();
                return stmt;
            } else {
                if (!this.identifierEquals("REPEATABLE")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                this.lexer.nextToken();
                if (!this.identifierEquals(READ)) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                stmt.setLevel("REPEATABLE READ");
                this.lexer.nextToken();
            }
            return stmt;
        }
        if (this.identifierEquals("NAMES")) {
            this.lexer.nextToken();
            MySqlSetNamesStatement stmt = new MySqlSetNamesStatement();
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                stmt.setDefault(true);
                return stmt;
            } else {
                String charSet = this.lexer.stringVal();
                stmt.setCharSet(charSet);
                this.lexer.nextToken();
                if (!this.identifierEquals(COLLATE2)) return stmt;
                this.lexer.nextToken();
                String collate = this.lexer.stringVal();
                stmt.setCollate(collate);
                this.lexer.nextToken();
            }
            return stmt;
        }
        if (this.identifierEquals(CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            MySqlSetCharSetStatement stmt = new MySqlSetCharSetStatement();
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                stmt.setDefault(true);
                return stmt;
            } else {
                String charSet = this.lexer.stringVal();
                stmt.setCharSet(charSet);
                this.lexer.nextToken();
                if (!this.identifierEquals(COLLATE2)) return stmt;
                this.lexer.nextToken();
                String collate = this.lexer.stringVal();
                stmt.setCollate(collate);
                this.lexer.nextToken();
            }
            return stmt;
        }
        SQLSetStatement stmt = new SQLSetStatement();
        this.parseAssignItems(stmt.getItems());
        if (global == null || !global.booleanValue()) return stmt;
        SQLVariantRefExpr varRef = (SQLVariantRefExpr)stmt.getItems().get(0).getTarget();
        varRef.setGlobal(true);
        return stmt;
    }

    public MySqlSelectQueryBlock.Limit parseLimit() {
        return ((MySqlExprParser)this.exprParser).parseLimit();
    }

    @Override
    public SQLStatement parseAlter() {
        this.accept(Token.ALTER);
        boolean ignore = false;
        if (this.identifierEquals(IGNORE)) {
            ignore = true;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            MySqlAlterTableStatement stmt = new MySqlAlterTableStatement();
            stmt.setIgnore(ignore);
            stmt.setName(this.exprParser.name());
            while (true) {
                SQLObjectImpl item;
                if (this.identifierEquals("ADD")) {
                    SQLSelectOrderByItem column;
                    SQLColumnDefinition columnDef;
                    this.lexer.nextToken();
                    if (this.identifierEquals("COLUMN")) {
                        this.lexer.nextToken();
                        item = new MySqlAlterTableAddColumn();
                        columnDef = this.exprParser.parseColumn();
                        ((SQLAlterTableAddColumn)item).getColumns().add(columnDef);
                        if (this.identifierEquals("AFTER")) {
                            this.lexer.nextToken();
                            ((MySqlAlterTableAddColumn)item).setAfter(this.exprParser.name());
                        }
                        stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    } else if (this.lexer.token() == Token.INDEX) {
                        this.lexer.nextToken();
                        item = new MySqlAlterTableAddIndex();
                        if (this.lexer.token() == Token.LPAREN) {
                            this.lexer.nextToken();
                        } else {
                            ((SQLAlterTableAddIndex)item).setName(this.exprParser.name());
                            this.accept(Token.LPAREN);
                        }
                        while (true) {
                            column = this.exprParser.parseSelectOrderByItem();
                            ((SQLAlterTableAddIndex)item).getItems().add(column);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                        stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    } else if (this.lexer.token() == Token.UNIQUE) {
                        this.lexer.nextToken();
                        item = new MySqlAlterTableAddUnique();
                        if (this.lexer.token() == Token.LPAREN) {
                            this.lexer.nextToken();
                        } else {
                            ((SQLAlterTableAddIndex)item).setName(this.exprParser.name());
                            this.accept(Token.LPAREN);
                        }
                        while (true) {
                            column = this.exprParser.parseSelectOrderByItem();
                            ((SQLAlterTableAddIndex)item).getItems().add(column);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                        stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    } else {
                        if (this.lexer.token() == Token.KEY) {
                            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        }
                        if (this.lexer.token() == Token.CONSTRAINT) {
                            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        }
                        if (this.identifierEquals(FULLTEXT)) {
                            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        }
                        if (this.identifierEquals(SPATIAL)) {
                            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        }
                        item = new MySqlAlterTableAddColumn();
                        columnDef = this.exprParser.parseColumn();
                        ((SQLAlterTableAddColumn)item).getColumns().add(columnDef);
                        if (this.identifierEquals("AFTER")) {
                            this.lexer.nextToken();
                            ((MySqlAlterTableAddColumn)item).setAfter(this.exprParser.name());
                        }
                        stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    }
                } else {
                    if (this.identifierEquals("ALTER")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("CHANGE")) {
                        this.lexer.nextToken();
                        if (this.identifierEquals("COLUMN")) {
                            this.lexer.nextToken();
                        }
                        item = new MySqlAlterTableChangeColumn();
                        ((MySqlAlterTableChangeColumn)item).setColumnName(this.exprParser.name());
                        ((MySqlAlterTableChangeColumn)item).setNewColumnDefinition(this.exprParser.parseColumn());
                        if (this.identifierEquals("FIRST")) {
                            this.lexer.nextToken();
                            ((MySqlAlterTableChangeColumn)item).setFirst(true);
                        } else if (this.identifierEquals("AFTER")) {
                            this.lexer.nextToken();
                            ((MySqlAlterTableChangeColumn)item).setFirst(false);
                        }
                        stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    } else {
                        if (this.identifierEquals("MODIFY")) {
                            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        }
                        if (this.lexer.token() == Token.DROP) {
                            this.lexer.nextToken();
                            if (this.identifierEquals("COLUMN")) {
                                this.lexer.nextToken();
                            }
                            item = new SQLAlterTableDropColumnItem();
                            ((SQLAlterTableDropColumnItem)item).setColumnName(this.exprParser.name());
                            stmt.getItems().add((SQLAlterTableItem)((Object)item));
                        } else {
                            if (this.identifierEquals("DISABLE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("ENABLE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("RENAME")) {
                                this.lexer.nextToken();
                                MySqlRenameTableStatement renameStmt = new MySqlRenameTableStatement();
                                MySqlRenameTableStatement.Item item2 = new MySqlRenameTableStatement.Item();
                                item2.setName(stmt.getTableSource().getExpr());
                                item2.setTo(this.exprParser.name());
                                renameStmt.getItems().add(item2);
                                return renameStmt;
                            }
                            if (this.lexer.token() == Token.ORDER) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("CONVERT")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.lexer.token() == Token.DEFAULT) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("DISCARD")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("IMPORT")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("FORCE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("TRUNCATE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("COALESCE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("REORGANIZE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("EXCHANGE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("ANALYZE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("CHECK")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("OPTIMIZE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("REBUILD")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("REPAIR")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals("REMOVE")) {
                                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                            }
                            if (this.identifierEquals(ENGINE)) {
                                this.lexer.nextToken();
                                this.accept(Token.EQ);
                                stmt.getItems().add(new MySqlAlterTableOption(ENGINE, this.lexer.stringVal()));
                                this.lexer.nextToken();
                            } else if (this.identifierEquals(COLLATE2)) {
                                this.lexer.nextToken();
                                this.accept(Token.EQ);
                                stmt.getItems().add(new MySqlAlterTableOption(COLLATE2, this.lexer.stringVal()));
                                this.lexer.nextToken();
                            } else if (this.identifierEquals("PACK_KEYS")) {
                                this.lexer.nextToken();
                                this.accept(Token.EQ);
                                if (this.identifierEquals("PACK")) {
                                    this.lexer.nextToken();
                                    this.accept(Token.ALL);
                                    stmt.getItems().add(new MySqlAlterTableOption("PACK_KEYS", "PACK ALL"));
                                } else {
                                    stmt.getItems().add(new MySqlAlterTableOption("PACK_KEYS", this.lexer.stringVal()));
                                    this.lexer.nextToken();
                                }
                            } else {
                                if (!this.identifierEquals(CHARACTER)) break;
                                this.lexer.nextToken();
                                this.accept(Token.SET);
                                this.accept(Token.EQ);
                                item = new MySqlAlterTableCharacter();
                                ((MySqlAlterTableCharacter)item).setCharacterSet(this.exprParser.primary());
                                if (this.lexer.token() == Token.COMMA) {
                                    this.lexer.nextToken();
                                    this.acceptIdentifier(COLLATE2);
                                    this.accept(Token.EQ);
                                    ((MySqlAlterTableCharacter)item).setCollate(this.exprParser.primary());
                                }
                                stmt.getItems().add((SQLAlterTableItem)((Object)item));
                            }
                        }
                    }
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            return stmt;
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    @Override
    public SQLStatement parseRename() {
        MySqlRenameTableStatement stmt = new MySqlRenameTableStatement();
        this.acceptIdentifier("RENAME");
        this.accept(Token.TABLE);
        while (true) {
            MySqlRenameTableStatement.Item item = new MySqlRenameTableStatement.Item();
            item.setName(this.exprParser.name());
            this.acceptIdentifier("TO");
            item.setTo(this.exprParser.name());
            stmt.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCreateDatabase() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.accept(Token.DATABASE);
        SQLCreateDatabaseStatement stmt = new SQLCreateDatabaseStatement();
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
        }
        return stmt;
    }
}

