/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OraclePartitionByRangeClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleRangeValuesClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.Token;

public class OracleCreateTableParser
extends SQLCreateTableParser {
    public OracleCreateTableParser(Lexer lexer) {
        super(new OracleExprParser(lexer));
    }

    public OracleCreateTableParser(String sql) {
        super(new OracleExprParser(sql));
    }

    @Override
    protected OracleCreateTableStatement newCreateStatement() {
        return new OracleCreateTableStatement();
    }

    @Override
    public OracleCreateTableStatement parseCrateTable(boolean acceptCreate) {
        OracleCreateTableStatement stmt;
        block29: {
            stmt = (OracleCreateTableStatement)super.parseCrateTable(acceptCreate);
            while (true) {
                if (this.identifierEquals("TABLESPACE")) {
                    this.lexer.nextToken();
                    stmt.setTablespace(this.exprParser.name());
                    continue;
                }
                if (this.identifierEquals("IN_MEMORY_METADATA")) {
                    this.lexer.nextToken();
                    stmt.setInMemoryMetadata(true);
                    continue;
                }
                if (this.identifierEquals("CURSOR_SPECIFIC_SEGMENT")) {
                    this.lexer.nextToken();
                    stmt.setCursorSpecificSegment(true);
                    continue;
                }
                if (this.identifierEquals("NOPARALLEL")) {
                    this.lexer.nextToken();
                    stmt.setParallel(false);
                    continue;
                }
                if (this.identifierEquals("LOGGING")) {
                    this.lexer.nextToken();
                    stmt.setLogging(Boolean.TRUE);
                    continue;
                }
                if (this.identifierEquals("CACHE")) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.TRUE);
                    continue;
                }
                if (this.identifierEquals("NOCACHE")) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.FALSE);
                    continue;
                }
                if (this.identifierEquals("NOCOMPRESS")) {
                    this.lexer.nextToken();
                    stmt.setCompress(Boolean.FALSE);
                    continue;
                }
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    this.accept(Token.COMMIT);
                    stmt.setOnCommit(true);
                    continue;
                }
                if (this.identifierEquals("PRESERVE")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("ROWS");
                    stmt.setPreserveRows(true);
                    continue;
                }
                if (this.identifierEquals("STORAGE")) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    OracleStorageClause storage = new OracleStorageClause();
                    while (true) {
                        if (this.identifierEquals("INITIAL")) {
                            this.lexer.nextToken();
                            storage.setInitial(this.exprParser.expr());
                            continue;
                        }
                        if (this.identifierEquals("FREELISTS")) {
                            this.lexer.nextToken();
                            storage.setFreeLists(this.exprParser.expr());
                            continue;
                        }
                        if (this.identifierEquals("FREELIST")) {
                            this.lexer.nextToken();
                            this.acceptIdentifier("GROUPS");
                            storage.setFreeListGroups(this.exprParser.expr());
                            continue;
                        }
                        if (this.identifierEquals("BUFFER_POOL")) {
                            this.lexer.nextToken();
                            storage.setBufferPool(this.exprParser.expr());
                            continue;
                        }
                        if (!this.identifierEquals("OBJNO")) break;
                        this.lexer.nextToken();
                        storage.setObjno(this.exprParser.expr());
                    }
                    this.accept(Token.RPAREN);
                    stmt.setStorage(storage);
                    continue;
                }
                if (this.identifierEquals("organization")) {
                    this.lexer.nextToken();
                    this.accept(Token.INDEX);
                    stmt.setOrganizationIndex(true);
                    continue;
                }
                if (this.identifierEquals("PCTFREE")) {
                    this.lexer.nextToken();
                    stmt.setPtcfree(this.exprParser.expr());
                    continue;
                }
                if (this.identifierEquals("PCTUSED")) {
                    this.lexer.nextToken();
                    stmt.setPctused(this.exprParser.expr());
                    continue;
                }
                if (this.identifierEquals("INITRANS")) {
                    this.lexer.nextToken();
                    stmt.setInitrans(this.exprParser.expr());
                    continue;
                }
                if (this.identifierEquals("MAXTRANS")) {
                    this.lexer.nextToken();
                    stmt.setMaxtrans(this.exprParser.expr());
                    continue;
                }
                if (!this.identifierEquals("PARTITION")) break block29;
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (!this.identifierEquals("RANGE")) break;
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                OraclePartitionByRangeClause clause = new OraclePartitionByRangeClause();
                while (true) {
                    SQLName column = this.exprParser.name();
                    clause.getColumns().add(column);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                if (this.identifierEquals("INTERVAL")) {
                    this.lexer.nextToken();
                    clause.setInterval(this.exprParser.expr());
                }
                if (this.identifierEquals("STORE")) {
                    this.lexer.nextToken();
                    this.accept(Token.IN);
                    this.accept(Token.LPAREN);
                    while (true) {
                        SQLName tablespace = this.exprParser.name();
                        clause.getStoreIn().add(tablespace);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                this.accept(Token.LPAREN);
                while (true) {
                    this.acceptIdentifier("PARTITION");
                    OracleRangeValuesClause range = new OracleRangeValuesClause();
                    range.setName(this.exprParser.name());
                    this.accept(Token.VALUES);
                    this.acceptIdentifier("LESS");
                    this.acceptIdentifier("THAN");
                    this.accept(Token.LPAREN);
                    while (true) {
                        SQLExpr rangeValue = this.exprParser.expr();
                        range.getValues().add(rangeValue);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    clause.getRanges().add(range);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                stmt.setPartitioning(clause);
            }
            throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            OracleSelect select = new OracleSelectParser(this.exprParser).select();
            stmt.setSelect(select);
        }
        return stmt;
    }
}

