/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class PGLexer
extends Lexer {
    public static final Keywords DEFAULT_PG_KEYWORDS;

    public PGLexer(String input) {
        super(input);
        this.keywods = DEFAULT_PG_KEYWORDS;
    }

    @Override
    protected void scanString() {
        this.np = this.bp;
        boolean hasSpecial = false;
        while (true) {
            if (this.bp >= this.buflen) {
                this.lexError(this.tokenPos, "unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.buf[++this.bp];
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '\u0000': {
                        this.putChar('\u0000');
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        break;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        break;
                    }
                    default: {
                        this.putChar(this.ch);
                    }
                }
                this.scanChar();
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                hasSpecial = true;
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.sbuf[this.sp++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? new String(this.buf, this.np + 1, this.sp) : new String(this.sbuf, 0, this.sp);
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("CASCADE", Token.CASCADE);
        map.put("CONTINUE", Token.CONTINUE);
        map.put("CURRENT", Token.CURRENT);
        map.put("FETCH", Token.FETCH);
        map.put("FIRST", Token.FIRST);
        map.put("IDENTITY", Token.IDENTITY);
        map.put("LIMIT", Token.LIMIT);
        map.put("NEXT", Token.NEXT);
        map.put("NOWAIT", Token.NOWAIT);
        map.put("OF", Token.OF);
        map.put("OFFSET", Token.OFFSET);
        map.put("ONLY", Token.ONLY);
        map.put("OVER", Token.OVER);
        map.put("RECURSIVE", Token.RECURSIVE);
        map.put("RESTART", Token.RESTART);
        map.put("RESTRICT", Token.RESTRICT);
        map.put("RETURNING", Token.RETURNING);
        map.put("ROW", Token.ROW);
        map.put("ROWS", Token.ROWS);
        map.put("SHARE", Token.SHARE);
        map.put("USING", Token.USING);
        map.put("WINDOW", Token.WINDOW);
        map.put("WITH", Token.WITH);
        DEFAULT_PG_KEYWORDS = new Keywords(map);
    }
}

