/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.stat;

import com.alibaba.druid.support.http.stat.WebRequestStat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WebURIStat {
    private final String uri;
    private final AtomicInteger runningCount = new AtomicInteger();
    private final AtomicInteger concurrentMax = new AtomicInteger();
    private final AtomicLong requestCount = new AtomicLong(0L);
    private final AtomicLong requestTimeNano = new AtomicLong();
    private final AtomicLong jdbcFetchRowCount = new AtomicLong();
    private final AtomicLong jdbcFetchRowPeak = new AtomicLong();
    private final AtomicLong jdbcUpdateCount = new AtomicLong();
    private final AtomicLong jdbcUpdatePeak = new AtomicLong();
    private final AtomicLong jdbcExecuteCount = new AtomicLong();
    private final AtomicLong jdbcExecuteErrorCount = new AtomicLong();
    private final AtomicLong jdbcExecutePeak = new AtomicLong();
    private final AtomicLong jdbcExecuteTimeNano = new AtomicLong();
    private final AtomicLong jdbcCommitCount = new AtomicLong();
    private final AtomicLong jdbcRollbackCount = new AtomicLong();
    private final AtomicLong jdbcPoolConnectionOpenCount = new AtomicLong();
    private final AtomicLong jdbcPoolConnectionCloseCount = new AtomicLong();
    private final AtomicLong jdbcResultSetOpenCount = new AtomicLong();
    private final AtomicLong jdbcResultSetCloseCount = new AtomicLong();
    private final AtomicLong errorCount = new AtomicLong();
    private volatile long lastAccessTimeMillis = -1L;
    private static final ThreadLocal<WebURIStat> currentLocal = new ThreadLocal();

    public WebURIStat(String uri) {
        this.uri = uri;
    }

    public static WebURIStat current() {
        return currentLocal.get();
    }

    public String getUri() {
        return this.uri;
    }

    public void beforeInvoke() {
        int max;
        currentLocal.set(this);
        int running = this.runningCount.incrementAndGet();
        while (running > (max = this.concurrentMax.get()) && !this.concurrentMax.compareAndSet(max, running)) {
        }
        this.requestCount.incrementAndGet();
        WebRequestStat requestStat = WebRequestStat.current();
        if (requestStat != null) {
            this.setLastAccessTimeMillis(requestStat.getStartMillis());
        }
    }

    public void afterInvoke(Throwable error, long nanos) {
        WebRequestStat localStat;
        this.runningCount.decrementAndGet();
        this.requestTimeNano.addAndGet(nanos);
        if (error != null) {
            this.errorCount.incrementAndGet();
        }
        if ((localStat = WebRequestStat.current()) != null) {
            long peak;
            long fetchRowCount = localStat.getJdbcFetchRowCount();
            this.addJdbcFetchRowCount(fetchRowCount);
            while (fetchRowCount > (peak = this.jdbcFetchRowPeak.get()) && !this.jdbcFetchRowPeak.compareAndSet(peak, fetchRowCount)) {
            }
            long executeCount = localStat.getJdbcExecuteCount();
            this.addJdbcExecuteCount(executeCount);
            while (executeCount > (peak = this.jdbcExecutePeak.get()) && !this.jdbcExecutePeak.compareAndSet(peak, executeCount)) {
            }
            long updateCount = localStat.getJdbcUpdateCount();
            this.addJdbcUpdateCount(updateCount);
            while (updateCount > (peak = this.jdbcUpdatePeak.get()) && !this.jdbcUpdatePeak.compareAndSet(peak, updateCount)) {
            }
            this.jdbcExecuteErrorCount.addAndGet(localStat.getJdbcExecuteErrorCount());
            this.jdbcExecuteTimeNano.addAndGet(localStat.getJdbcExecuteTimeNano());
            this.addJdbcPoolConnectionOpenCount(localStat.getJdbcPoolConnectionOpenCount());
            this.addJdbcPoolConnectionCloseCount(localStat.getJdbcPoolConnectionCloseCount());
            this.addJdbcResultSetOpenCount(localStat.getJdbcResultSetOpenCount());
            this.addJdbcResultSetCloseCount(localStat.getJdbcResultSetCloseCount());
        }
        currentLocal.set(null);
    }

    public int getRunningCount() {
        return this.runningCount.get();
    }

    public long getConcurrentMax() {
        return this.concurrentMax.get();
    }

    public long getRequestCount() {
        return this.requestCount.get();
    }

    public long getRequestTimeNano() {
        return this.requestTimeNano.get();
    }

    public long getRequestTimeMillis() {
        return this.getRequestTimeNano() / 1000000L;
    }

    public void addJdbcFetchRowCount(long delta) {
        this.jdbcFetchRowCount.addAndGet(delta);
    }

    public long getJdbcFetchRowCount() {
        return this.jdbcFetchRowCount.get();
    }

    public long getJdbcFetchRowPeak() {
        return this.jdbcFetchRowPeak.get();
    }

    public void addJdbcUpdateCount(long updateCount) {
        this.jdbcUpdateCount.addAndGet(updateCount);
    }

    public long getJdbcUpdateCount() {
        return this.jdbcUpdateCount.get();
    }

    public long getJdbcUpdatePeak() {
        return this.jdbcUpdatePeak.get();
    }

    public void incrementJdbcExecuteCount() {
        this.jdbcExecuteCount.incrementAndGet();
    }

    public void addJdbcExecuteCount(long executeCount) {
        this.jdbcExecuteCount.addAndGet(executeCount);
    }

    public long getJdbcExecuteCount() {
        return this.jdbcExecuteCount.get();
    }

    public AtomicLong getJdbcExecuteErrorCount() {
        return this.jdbcExecuteErrorCount;
    }

    public long getJdbcExecutePeak() {
        return this.jdbcExecutePeak.get();
    }

    public long getJdbcExecuteTimeMillis() {
        return this.getJdbcExecuteTimeNano() / 1000000L;
    }

    public long getJdbcExecuteTimeNano() {
        return this.jdbcExecuteTimeNano.get();
    }

    public void incrementJdbcCommitCount() {
        this.jdbcCommitCount.incrementAndGet();
    }

    public long getJdbcCommitCount() {
        return this.jdbcCommitCount.get();
    }

    public void incrementJdbcRollbackCount() {
        this.jdbcRollbackCount.incrementAndGet();
    }

    public long getJdbcRollbackCount() {
        return this.jdbcRollbackCount.get();
    }

    public void setLastAccessTimeMillis(long lastAccessTimeMillis) {
        this.lastAccessTimeMillis = lastAccessTimeMillis;
    }

    public Date getLastAccessTime() {
        if (this.lastAccessTimeMillis < 0L) {
            return null;
        }
        return new Date(this.lastAccessTimeMillis);
    }

    public long getLastAccessTimeMillis() {
        return this.lastAccessTimeMillis;
    }

    public long getErrorCount() {
        return this.errorCount.get();
    }

    public long getJdbcPoolConnectionOpenCount() {
        return this.jdbcPoolConnectionOpenCount.get();
    }

    public void addJdbcPoolConnectionOpenCount(long delta) {
        this.jdbcPoolConnectionOpenCount.addAndGet(delta);
    }

    public void incrementJdbcPoolConnectionOpenCount() {
        this.jdbcPoolConnectionOpenCount.incrementAndGet();
    }

    public long getJdbcPoolConnectionCloseCount() {
        return this.jdbcPoolConnectionCloseCount.get();
    }

    public void addJdbcPoolConnectionCloseCount(long delta) {
        this.jdbcPoolConnectionCloseCount.addAndGet(delta);
    }

    public void incrementJdbcPoolConnectionCloseCount() {
        this.jdbcPoolConnectionCloseCount.incrementAndGet();
    }

    public long getJdbcResultSetOpenCount() {
        return this.jdbcResultSetOpenCount.get();
    }

    public void addJdbcResultSetOpenCount(long delta) {
        this.jdbcResultSetOpenCount.addAndGet(delta);
    }

    public long getJdbcResultSetCloseCount() {
        return this.jdbcResultSetCloseCount.get();
    }

    public void addJdbcResultSetCloseCount(long delta) {
        this.jdbcResultSetCloseCount.addAndGet(delta);
    }

    public Map<String, Object> getStatData() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("URI", this.getUri());
        data.put("RunningCount", this.getRunningCount());
        data.put("ConcurrentMax", this.getConcurrentMax());
        data.put("RequestCount", this.getRequestCount());
        data.put("RequestTimeMillis", this.getRequestTimeMillis());
        data.put("ErrorCount", this.getErrorCount());
        data.put("LastAccessTime", this.getLastAccessTime());
        data.put("JdbcCommitCount", this.getJdbcCommitCount());
        data.put("JdbcRollbackCount", this.getJdbcRollbackCount());
        data.put("JdbcExecuteCount", this.getJdbcExecuteCount());
        data.put("JdbcExecuteErrorCount", this.getJdbcExecuteErrorCount());
        data.put("JdbcExecutePeak", this.getJdbcExecutePeak());
        data.put("JdbcExecuteTimeMillis", this.getJdbcExecuteTimeMillis());
        data.put("JdbcFetchRowCount", this.getJdbcFetchRowCount());
        data.put("JdbcFetchRowPeak", this.getJdbcFetchRowPeak());
        data.put("JdbcUpdateCount", this.getJdbcUpdateCount());
        data.put("JdbcUpdatePeak", this.getJdbcUpdatePeak());
        data.put("JdbcPoolConnectionOpenCount", this.getJdbcPoolConnectionOpenCount());
        data.put("JdbcPoolConnectionCloseCount", this.getJdbcPoolConnectionCloseCount());
        data.put("JdbcResultSetOpenCount", this.getJdbcResultSetOpenCount());
        data.put("JdbcResultSetCloseCount", this.getJdbcResultSetCloseCount());
        return data;
    }
}

