/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.logging;

import com.alibaba.druid.support.logging.Log;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jImpl
implements Log {
    private static final String callerFQCN = Log4jImpl.class.getName();
    private Logger log;
    private int errorCount;
    private int warnCount;
    private int infoCount;

    public Log4jImpl(Class<?> clazz) {
        this.log = Logger.getLogger(clazz);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        ++this.errorCount;
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)s, e);
    }

    @Override
    public void error(String s) {
        ++this.errorCount;
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)s, null);
    }

    @Override
    public void debug(String s) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)s, null);
    }

    @Override
    public void debug(String s, Throwable e) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)s, e);
    }

    @Override
    public void warn(String s) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)s, null);
        ++this.warnCount;
    }

    @Override
    public void warn(String s, Throwable e) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)s, e);
        ++this.warnCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        ++this.infoCount;
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    public String toString() {
        return this.log.toString();
    }
}

