/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class Histogram {
    private final long[] ranges;
    private final AtomicLong[] rangeCounters;

    public Histogram(long ... ranges) {
        this.ranges = ranges;
        this.rangeCounters = new AtomicLong[ranges.length + 1];
        for (int i = 0; i < this.rangeCounters.length; ++i) {
            this.rangeCounters[i] = new AtomicLong();
        }
    }

    public static Histogram makeHistogram(int rangeCount) {
        long[] rangeValues = new long[rangeCount];
        for (int i = 0; i < rangeValues.length; ++i) {
            rangeValues[i] = (long)Math.pow(10.0, i);
        }
        return new Histogram(rangeValues);
    }

    public Histogram(TimeUnit timeUnit, long ... ranges) {
        int i;
        this.ranges = new long[ranges.length];
        for (i = 0; i < ranges.length; ++i) {
            this.ranges[i] = TimeUnit.MILLISECONDS.convert(ranges[i], timeUnit);
        }
        this.rangeCounters = new AtomicLong[ranges.length + 1];
        for (i = 0; i < this.rangeCounters.length; ++i) {
            this.rangeCounters[i] = new AtomicLong();
        }
    }

    public void reset() {
        for (int i = 0; i < this.rangeCounters.length; ++i) {
            this.rangeCounters[i].set(0L);
        }
    }

    public void record(long millis) {
        int index = this.rangeCounters.length - 1;
        for (int i = 0; i < this.ranges.length; ++i) {
            if (millis >= this.ranges[i]) continue;
            index = i;
            break;
        }
        this.rangeCounters[index].incrementAndGet();
    }

    public long get(int index) {
        return this.rangeCounters[index].get();
    }

    public long[] toArray() {
        long[] array = new long[this.rangeCounters.length];
        for (int i = 0; i < this.rangeCounters.length; ++i) {
            array[i] = this.rangeCounters[i].get();
        }
        return array;
    }

    public long[] getRanges() {
        return this.ranges;
    }

    public long getValue(int index) {
        return this.rangeCounters[index].get();
    }

    public long getSum() {
        long sum = 0L;
        for (int i = 0; i < this.rangeCounters.length; ++i) {
            sum += this.rangeCounters[i].get();
        }
        return sum;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.rangeCounters.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.rangeCounters[i].get());
        }
        buf.append(']');
        return buf.toString();
    }
}

