/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall.spi;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerObjectReferenceExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitorAdapter;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import java.util.ArrayList;
import java.util.List;

public class SQLServerWallVisitor
extends SQLServerASTVisitorAdapter
implements WallVisitor,
SQLServerASTVisitor {
    private final WallConfig config;
    private final WallProvider provider;
    private final List<Violation> violations = new ArrayList<Violation>();

    public SQLServerWallVisitor(WallProvider provider) {
        this.config = provider.getConfig();
        this.provider = provider;
    }

    @Override
    public WallProvider getProvider() {
        return this.provider;
    }

    @Override
    public WallConfig getConfig() {
        return this.config;
    }

    @Override
    public List<Violation> getViolations() {
        return this.violations;
    }

    @Override
    public boolean isPermitTable(String name) {
        if (!this.config.isTableCheck()) {
            return false;
        }
        name = WallVisitorUtils.form(name);
        return this.config.getPermitTables().contains(name);
    }

    @Override
    public String toSQL(SQLObject obj) {
        return SQLUtils.toSQLServerString(obj);
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name = x.getName();
        name = WallVisitorUtils.form(name);
        if (this.config.isVariantCheck() && this.config.getPermitVariants().contains(name)) {
            this.getViolations().add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
        return true;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        WallVisitorUtils.checkFunction(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return !(x.getExpr() instanceof SQLName);
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        WallVisitorUtils.checkHaving(this, x.getHaving());
        return true;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        WallVisitorUtils.checkSelelct(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        WallVisitorUtils.checkUnion(this, x);
        return true;
    }

    @Override
    public void preVisit(SQLObject x) {
        if (!(x instanceof SQLStatement)) {
            return;
        }
        if (this.config.isNoneBaseStatementAllow()) {
            return;
        }
        boolean allow = false;
        if (x instanceof SQLInsertStatement) {
            allow = true;
        } else if (x instanceof SQLSelectStatement) {
            allow = true;
        } else if (x instanceof SQLDeleteStatement) {
            allow = true;
        } else if (x instanceof SQLUpdateStatement) {
            allow = true;
        } else if (x instanceof SQLCallStatement) {
            allow = true;
        } else if (x instanceof SQLTruncateStatement) {
            allow = this.config.isTruncateAllow();
        }
        if (!allow) {
            this.violations.add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (!this.config.isSelelctAllow()) {
            this.getViolations().add(new IllegalSQLObjectViolation(this.toSQL(x)));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        if (!this.config.isInsertAllow()) {
            this.getViolations().add(new IllegalSQLObjectViolation(this.toSQL(x)));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        WallVisitorUtils.checkDelete(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        WallVisitorUtils.checkUpdate(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        String varName = x.getName();
        if (varName == null) {
            return false;
        }
        if (this.config.isVariantCheck() && varName.startsWith("@@")) {
            this.violations.add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerObjectReferenceExpr x) {
        if (x.getSchema() != null && this.config.isPermitSchema(x.getSchema())) {
            this.getViolations().add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
        if (x.getDatabase() != null && this.config.isPermitSchema(x.getDatabase())) {
            this.getViolations().add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
        return true;
    }

    @Override
    public boolean visit(SQLServerInsertStatement x) {
        this.visit((SQLInsertStatement)x);
        return false;
    }

    @Override
    public void endVisit(SQLServerInsertStatement x) {
        this.endVisit((SQLInsertStatement)x);
    }
}

