/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallCheckResult;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallContext;
import com.alibaba.druid.wall.WallFilterMBean;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallSQLException;
import com.alibaba.druid.wall.WallSqlStat;
import com.alibaba.druid.wall.spi.DB2WallProvider;
import com.alibaba.druid.wall.spi.MySqlWallProvider;
import com.alibaba.druid.wall.spi.OracleWallProvider;
import com.alibaba.druid.wall.spi.PGWallProvider;
import com.alibaba.druid.wall.spi.SQLServerWallProvider;
import com.alibaba.druid.wall.violation.SyntaxErrorViolation;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class WallFilter
extends FilterAdapter
implements WallFilterMBean {
    private static final Log LOG = LogFactory.getLog(WallFilter.class);
    private boolean inited = false;
    private WallProvider provider;
    private String dbType;
    private WallConfig config;
    private volatile boolean logViolation = false;
    private volatile boolean throwException = true;
    public static final String ATTR_SQL_STAT = "wall.sqlStat";

    public WallFilter() {
        this.configFromProperties(System.getProperties());
    }

    @Override
    public void configFromProperties(Properties properties) {
        Boolean value = Utils.getBoolean(properties, "druid.wall.logViolation");
        if (value != null) {
            this.logViolation = value;
        }
        if ((value = Utils.getBoolean(properties, "druid.wall.throwException")) != null) {
            this.throwException = value;
        }
    }

    @Override
    public synchronized void init(DataSourceProxy dataSource) {
        if (this.dbType == null || this.dbType.trim().length() == 0) {
            this.dbType = dataSource != null && dataSource.getDbType() != null ? dataSource.getDbType() : JdbcUtils.getDbType(dataSource.getRawJdbcUrl(), "");
        }
        if (this.dbType == null) {
            this.dbType = JdbcUtils.getDbType(dataSource.getUrl(), null);
        }
        if ("mysql".equals(this.dbType) || "mariadb".equals(this.dbType) || "h2".equals(this.dbType)) {
            if (this.config == null) {
                this.config = new WallConfig("META-INF/druid/wall/mysql");
            }
            this.provider = new MySqlWallProvider(this.config);
        } else if ("oracle".equals(this.dbType) || "AliOracle".equals(this.dbType)) {
            if (this.config == null) {
                this.config = new WallConfig("META-INF/druid/wall/oracle");
            }
            this.provider = new OracleWallProvider(this.config);
        } else if ("sqlserver".equals(this.dbType) || "jtds".equals(this.dbType)) {
            if (this.config == null) {
                this.config = new WallConfig("META-INF/druid/wall/sqlserver");
            }
            this.provider = new SQLServerWallProvider(this.config);
        } else if ("postgresql".equals(this.dbType)) {
            if (this.config == null) {
                this.config = new WallConfig("META-INF/druid/wall/postgres");
            }
            this.provider = new PGWallProvider(this.config);
        } else if ("db2".equals(this.dbType)) {
            if (this.config == null) {
                this.config = new WallConfig("META-INF/druid/wall/db2");
            }
            this.provider = new DB2WallProvider(this.config);
        } else {
            throw new IllegalStateException("dbType not support : " + this.dbType + ", url " + dataSource.getUrl());
        }
        this.provider.setName(dataSource.getName());
        this.inited = true;
    }

    @Override
    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public boolean isLogViolation() {
        return this.logViolation;
    }

    @Override
    public void setLogViolation(boolean logViolation) {
        this.logViolation = logViolation;
    }

    @Override
    public boolean isThrowException() {
        return this.throwException;
    }

    @Override
    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    @Override
    public void clearProviderCache() {
        if (this.provider != null) {
            this.provider.clearCache();
        }
    }

    @Override
    public Set<String> getProviderWhiteList() {
        if (this.provider == null) {
            return Collections.emptySet();
        }
        return this.provider.getWhiteList();
    }

    public WallProvider getProvider() {
        return this.provider;
    }

    public WallConfig getConfig() {
        return this.config;
    }

    public void setConfig(WallConfig config) {
        this.config = config;
    }

    @Override
    public boolean isInited() {
        return this.inited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statement_addBatch(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            chain.statement_addBatch(statement, sql);
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public void preparedStatement_addBatch(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        chain.preparedStatement_addBatch(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int autoGeneratedKeys) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, autoGeneratedKeys);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int[] columnIndexes) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, columnIndexes);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, String[] columnNames) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, columnNames);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            CallableStatementProxy stmt = chain.connection_prepareCall(connection, sql);
            this.setSqlStatAttribute(stmt);
            CallableStatementProxy callableStatementProxy = stmt;
            return callableStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            CallableStatementProxy stmt = chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
            this.setSqlStatAttribute(stmt);
            CallableStatementProxy callableStatementProxy = stmt;
            return callableStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext.create(dbType);
        try {
            sql = this.check(sql);
            CallableStatementProxy stmt = chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.setSqlStatAttribute(stmt);
            CallableStatementProxy callableStatementProxy = stmt;
            return callableStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        WallContext originalContext = WallContext.current();
        try {
            this.createWallContext(statement);
            sql = this.check(sql);
            boolean firstResult = chain.statement_execute(statement, sql);
            if (!firstResult) {
                int updateCount = statement.getUpdateCount();
                this.statExecuteUpdate(updateCount);
            } else {
                this.setSqlStatAttribute(statement);
            }
            boolean bl = firstResult;
            return bl;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            if (originalContext != null) {
                WallContext.setContext(originalContext);
            }
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            boolean firstResult = chain.statement_execute(statement, sql, autoGeneratedKeys);
            if (!firstResult) {
                int updateCount = statement.getUpdateCount();
                this.statExecuteUpdate(updateCount);
            } else {
                this.setSqlStatAttribute(statement);
            }
            boolean bl = firstResult;
            return bl;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            boolean firstResult = chain.statement_execute(statement, sql, columnIndexes);
            if (!firstResult) {
                int updateCount = statement.getUpdateCount();
                this.statExecuteUpdate(updateCount);
            } else {
                this.setSqlStatAttribute(statement);
            }
            boolean bl = firstResult;
            return bl;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            boolean firstResult = chain.statement_execute(statement, sql, columnNames);
            if (!firstResult) {
                int updateCount = statement.getUpdateCount();
                this.statExecuteUpdate(updateCount);
            } else {
                this.setSqlStatAttribute(statement);
            }
            boolean bl = firstResult;
            return bl;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public int[] statement_executeBatch(FilterChain chain, StatementProxy statement) throws SQLException {
        WallSqlStat sqlStat = (WallSqlStat)statement.getAttribute(ATTR_SQL_STAT);
        try {
            int[] updateCounts = chain.statement_executeBatch(statement);
            int updateCount = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                updateCount += updateCounts[i];
            }
            if (sqlStat != null) {
                this.provider.addUpdateCount(sqlStat, updateCount);
            }
            int[] nArray = updateCounts;
            return nArray;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public ResultSetProxy statement_executeQuery(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            ResultSetProxy resultSetProxy = chain.statement_executeQuery(statement, sql);
            return resultSetProxy;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            int updateCount = chain.statement_executeUpdate(statement, sql);
            this.statExecuteUpdate(updateCount);
            int n = updateCount;
            return n;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            int updateCount = chain.statement_executeUpdate(statement, sql, autoGeneratedKeys);
            this.statExecuteUpdate(updateCount);
            int n = updateCount;
            return n;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            int updateCount = chain.statement_executeUpdate(statement, sql, columnIndexes);
            this.statExecuteUpdate(updateCount);
            int n = updateCount;
            return n;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    public String getDbType(StatementProxy statement) {
        return statement.getConnectionProxy().getDirectDataSource().getDbType();
    }

    private WallContext createWallContext(StatementProxy statement) {
        String dbType = this.getDbType(statement);
        WallContext context = WallContext.create(dbType);
        return context;
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            int updateCount = chain.statement_executeUpdate(statement, sql, columnNames);
            this.statExecuteUpdate(updateCount);
            int n = updateCount;
            return n;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public boolean preparedStatement_execute(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        try {
            boolean firstResult = chain.preparedStatement_execute(statement);
            if (!firstResult) {
                WallSqlStat sqlStat = (WallSqlStat)statement.getAttribute(ATTR_SQL_STAT);
                int updateCount = statement.getUpdateCount();
                if (sqlStat != null) {
                    this.provider.addUpdateCount(sqlStat, updateCount);
                }
            }
            return firstResult;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount(statement);
            throw ex;
        }
    }

    @Override
    public ResultSetProxy preparedStatement_executeQuery(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        try {
            return chain.preparedStatement_executeQuery(statement);
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount(statement);
            throw ex;
        }
    }

    @Override
    public int preparedStatement_executeUpdate(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        try {
            int updateCount = chain.preparedStatement_executeUpdate(statement);
            WallSqlStat sqlStat = (WallSqlStat)statement.getAttribute(ATTR_SQL_STAT);
            if (sqlStat != null) {
                this.provider.addUpdateCount(sqlStat, updateCount);
            }
            return updateCount;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount(statement);
            throw ex;
        }
    }

    public void setSqlStatAttribute(StatementProxy stmt) {
        WallContext context = WallContext.current();
        if (context == null) {
            return;
        }
        WallSqlStat sqlStat = context.getSqlStat();
        if (sqlStat == null) {
            return;
        }
        stmt.putAttribute(ATTR_SQL_STAT, sqlStat);
    }

    public void statExecuteUpdate(int updateCount) {
        WallContext context = WallContext.current();
        if (context == null) {
            return;
        }
        WallSqlStat sqlStat = context.getSqlStat();
        if (sqlStat == null) {
            return;
        }
        if (updateCount > 0 && sqlStat != null) {
            this.provider.addUpdateCount(sqlStat, updateCount);
        }
    }

    public void incrementExecuteErrorCount(PreparedStatementProxy statement) {
        WallSqlStat sqlStat = (WallSqlStat)statement.getAttribute(ATTR_SQL_STAT);
        if (sqlStat != null) {
            sqlStat.incrementAndGetExecuteErrorCount();
        }
    }

    public void incrementExecuteErrorCount() {
        WallContext context = WallContext.current();
        if (context == null) {
            return;
        }
        WallSqlStat sqlStat = context.getSqlStat();
        if (sqlStat == null) {
            return;
        }
        sqlStat.incrementAndGetExecuteErrorCount();
    }

    @Override
    public String check(String sql) throws SQLException {
        WallCheckResult checkResult = this.provider.check(sql);
        List<Violation> violations = checkResult.getViolations();
        if (violations.size() > 0) {
            Violation firstViolation = violations.get(0);
            if (this.isLogViolation()) {
                LOG.error("sql injection violation, " + firstViolation.getMessage() + " : " + sql);
            }
            if (this.throwException) {
                if (violations.get(0) instanceof SyntaxErrorViolation) {
                    SyntaxErrorViolation violation = (SyntaxErrorViolation)violations.get(0);
                    throw new SQLException("sql injection violation, " + firstViolation.getMessage() + " : " + sql, violation.getException());
                }
                throw new SQLException("sql injection violation, " + firstViolation.getMessage() + " : " + sql);
            }
        }
        String resultSql = checkResult.getSql();
        return resultSql;
    }

    @Override
    public boolean isWrapperFor(FilterChain chain, Wrapper wrapper, Class<?> iface) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPivileged()) {
            return chain.isWrapperFor(wrapper, iface);
        }
        if (!this.provider.getConfig().isWrapAllow()) {
            return false;
        }
        return chain.isWrapperFor(wrapper, iface);
    }

    @Override
    public <T> T unwrap(FilterChain chain, Wrapper wrapper, Class<T> iface) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPivileged()) {
            return chain.unwrap(wrapper, iface);
        }
        if (!this.provider.getConfig().isWrapAllow()) {
            return null;
        }
        return chain.unwrap(wrapper, iface);
    }

    @Override
    public DatabaseMetaData connection_getMetaData(FilterChain chain, ConnectionProxy connection) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPivileged()) {
            return chain.connection_getMetaData(connection);
        }
        if (!this.provider.getConfig().isMetadataAllow()) {
            if (this.isLogViolation()) {
                LOG.error("not support method : Connection.getMetdataData");
            }
            if (this.throwException) {
                throw new WallSQLException("not support method : Connection.getMetdataData");
            }
        }
        return chain.connection_getMetaData(connection);
    }

    @Override
    public void resultSet_close(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        chain.resultSet_close(resultSet);
        int fetchRowCount = resultSet.getFetchRowCount();
        WallSqlStat sqlStat = (WallSqlStat)resultSet.getStatementProxy().getAttribute(ATTR_SQL_STAT);
        if (sqlStat == null) {
            return;
        }
        this.provider.addFetchRowCount(sqlStat, fetchRowCount);
    }

    @Override
    public long getViolationCount() {
        return this.provider.getViolationCount();
    }

    @Override
    public void resetViolationCount() {
        this.provider.reset();
    }

    @Override
    public void clearWhiteList() {
        this.provider.clearCache();
    }

    @Override
    public boolean checkValid(String sql) {
        return this.provider.checkValid(sql);
    }
}

