/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.teradata.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLKeep;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataAnalytic;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataAnalyticWindowing;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataIntervalExpr;
import com.alibaba.druid.sql.dialect.teradata.ast.expr.TeradataIntervalUnit;
import com.alibaba.druid.sql.dialect.teradata.parser.TeradataLexer;
import com.alibaba.druid.sql.dialect.teradata.parser.TeradataSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class TeradataExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER"};

    public TeradataExprParser(String sql) {
        this(new TeradataLexer(sql));
        this.lexer.nextToken();
        this.dbType = "teradata";
    }

    public TeradataExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.dbType = "teradata";
    }

    @Override
    public SQLExpr primary() {
        SQLQueryExpr sqlExpr = null;
        Token tok = this.lexer.token();
        switch (tok) {
            case SEL: {
                SQLQueryExpr queryExpr;
                sqlExpr = queryExpr = new SQLQueryExpr(this.createSelectParser().select());
                return this.primaryRest(sqlExpr);
            }
            case CAST: {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLCastExpr cast = new SQLCastExpr();
                cast.setExpr(this.expr());
                this.accept(Token.AS);
                cast.setDataType(this.parseDataType());
                if (this.lexer.token() == Token.FORMAT) {
                    this.lexer.nextToken();
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                return this.primaryRest(cast);
            }
        }
        return super.primary();
    }

    @Override
    public SQLSelectParser createSelectParser() {
        return new TeradataSelectParser(this);
    }

    @Override
    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.lexer.token() == Token.BETWEEN) {
            SQLExpr endExpr;
            this.lexer.nextToken();
            SQLExpr beginExpr = this.bitOr();
            if (this.lexer.token() != Token.AND) {
                this.lexer.nextToken();
                this.accept(Token.AND);
                endExpr = this.bitOr();
                this.lexer.nextToken();
            } else {
                this.accept(Token.AND);
                endExpr = this.bitOr();
            }
            expr = new SQLBetweenExpr(expr, beginExpr, endExpr);
            return expr;
        }
        return super.relationalRest(expr);
    }

    @Override
    protected SQLExpr methodRest(SQLExpr expr, boolean acceptLPAREN) {
        if (acceptLPAREN) {
            this.accept(Token.LPAREN);
        }
        if (expr instanceof SQLIdentifierExpr) {
            String methodName = ((SQLIdentifierExpr)expr).getName();
            SQLMethodInvokeExpr methodExpr = new SQLMethodInvokeExpr(methodName);
            if ("trim".equalsIgnoreCase(methodName)) {
                SQLExpr trim_character;
                if (this.identifierEquals("LEADING") || this.identifierEquals("TRAILING") || this.identifierEquals("BOTH")) {
                    methodExpr.putAttribute("trim_option", this.lexer.stringVal());
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LITERAL_CHARS) {
                        trim_character = this.primary();
                        trim_character.setParent(methodExpr);
                        methodExpr.putAttribute("trim_character", trim_character);
                    }
                } else {
                    trim_character = this.primary();
                    trim_character.setParent(methodExpr);
                    methodExpr.putAttribute("trim_character", trim_character);
                }
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    SQLExpr trim_source = this.expr();
                    methodExpr.addParameter(trim_source);
                }
                this.accept(Token.RPAREN);
                return this.primaryRest(methodExpr);
            }
        } else if (expr instanceof SQLCaseExpr) {
            this.lexer.nextToken();
            this.accept(Token.RPAREN);
            return this.primaryRest(expr);
        }
        return super.methodRest(expr, false);
    }

    @Override
    public SQLExpr multiplicativeRest(SQLExpr expr) {
        if (this.lexer.token() == Token.MOD) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitXor();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Mod, rightExp, this.getDbType());
            expr = this.multiplicativeRest(expr);
            return expr;
        }
        return super.multiplicativeRest(expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SQLAggregateExpr parseAggregateExpr(String methodName) {
        SQLAggregateExpr aggregateExpr;
        methodName = methodName.toUpperCase();
        if (this.lexer.token() == Token.UNIQUE) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.UNIQUE);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.ALL);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DISTINCT) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.DISTINCT);
            this.lexer.nextToken();
        } else {
            aggregateExpr = new SQLAggregateExpr(methodName);
        }
        this.exprList(aggregateExpr.getArguments(), aggregateExpr);
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.KEEP) {
            this.lexer.nextToken();
            SQLKeep keep = new SQLKeep();
            this.accept(Token.LPAREN);
            this.acceptIdentifier("DENSE_RANK");
            if (this.identifierEquals("FIRST")) {
                this.lexer.nextToken();
                keep.setDenseRank(SQLKeep.DenseRank.FIRST);
            } else {
                this.acceptIdentifier("LAST");
                keep.setDenseRank(SQLKeep.DenseRank.LAST);
            }
            SQLOrderBy orderBy = this.parseOrderBy();
            keep.setOrderBy(orderBy);
            aggregateExpr.setKeep(keep);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() != Token.OVER) return aggregateExpr;
        TeradataAnalytic over = new TeradataAnalytic();
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        if (this.identifierEquals("PARTITION")) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprList(over.getPartitionBy(), over);
                this.accept(Token.RPAREN);
            } else {
                this.exprList(over.getPartitionBy(), over);
            }
        }
        over.setOrderBy(this.parseOrderBy());
        if (over.getOrderBy() != null) {
            TeradataAnalyticWindowing windowing = null;
            if (this.lexer.stringVal().equalsIgnoreCase("ROWS")) {
                this.lexer.nextToken();
                windowing = new TeradataAnalyticWindowing();
                windowing.setType(TeradataAnalyticWindowing.Type.ROWS);
            } else if (this.lexer.stringVal().equalsIgnoreCase("RANGE")) {
                this.lexer.nextToken();
                windowing = new TeradataAnalyticWindowing();
                windowing.setType(TeradataAnalyticWindowing.Type.RANGE);
            }
            if (windowing != null) {
                if (this.lexer.stringVal().equalsIgnoreCase("BETWEEN")) {
                    String between = null;
                    String and = null;
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LITERAL_INT) {
                        int val_1 = this.lexer.integerValue().intValue();
                        this.lexer.nextToken();
                        if (this.lexer.stringVal().equalsIgnoreCase("PRECEDING")) {
                            this.lexer.nextToken();
                            between = "BETWEEN " + String.valueOf(val_1) + " PRECEDING";
                        } else {
                            if (!this.lexer.stringVal().equalsIgnoreCase("FOLLOWING")) throw new ParserException("syntax error");
                            this.lexer.nextToken();
                            between = "BETWEEN " + String.valueOf(val_1) + " FOLLOWING";
                        }
                    } else if (this.lexer.stringVal().equalsIgnoreCase("CURRENT")) {
                        this.lexer.nextToken();
                        if (this.lexer.stringVal().equalsIgnoreCase("ROW")) {
                            this.lexer.nextToken();
                            between = "BETWEEN CURRENT ROW";
                        }
                    } else {
                        if (!this.lexer.stringVal().equalsIgnoreCase("UNBOUNDED")) throw new ParserException("syntax error");
                        this.lexer.nextToken();
                        if (this.lexer.stringVal().equalsIgnoreCase("PRECEDING")) {
                            this.lexer.nextToken();
                            between = "BETWEEN UNBOUNDED PRECEDING";
                        }
                    }
                    if (!this.lexer.stringVal().equalsIgnoreCase("AND")) throw new ParserException("syntax error");
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LITERAL_INT) {
                        System.out.println("yes, inside and");
                        int val_2 = this.lexer.integerValue().intValue();
                        this.lexer.nextToken();
                        if (this.lexer.stringVal().equalsIgnoreCase("PRECEDING")) {
                            this.lexer.nextToken();
                            and = " AND " + String.valueOf(val_2) + " PRECEDING";
                            windowing.setExpr(new SQLIdentifierExpr(between + and));
                        } else {
                            if (!this.lexer.stringVal().equalsIgnoreCase("FOLLOWING")) throw new ParserException("syntax error");
                            this.lexer.nextToken();
                            and = " AND " + String.valueOf(val_2) + " FOLLOWING";
                            windowing.setExpr(new SQLIdentifierExpr(between + and));
                        }
                    } else if (this.lexer.stringVal().equalsIgnoreCase("CURRENT")) {
                        this.lexer.nextToken();
                        if (this.lexer.stringVal().equalsIgnoreCase("ROW")) {
                            this.lexer.nextToken();
                            and = " AND CURRENT ROW";
                            windowing.setExpr(new SQLIdentifierExpr(between + and));
                        }
                    } else {
                        if (!this.lexer.stringVal().equalsIgnoreCase("UNBOUNDED")) throw new ParserException("syntax error");
                        this.lexer.nextToken();
                        if (this.lexer.stringVal().equalsIgnoreCase("FOLLOWING")) {
                            this.lexer.nextToken();
                            and = " AND UNBOUNDED FOLLOWING";
                            windowing.setExpr(new SQLIdentifierExpr(between + and));
                        }
                    }
                } else {
                    if (this.lexer.stringVal().equalsIgnoreCase("CURRENT")) {
                        this.lexer.nextToken();
                        if (!this.lexer.stringVal().equalsIgnoreCase("ROW")) throw new ParserException("syntax error");
                        this.lexer.nextToken();
                        windowing.setExpr(new SQLIdentifierExpr("CURRENT ROW"));
                        over.setWindowing(windowing);
                    }
                    if (this.lexer.stringVal().equalsIgnoreCase("UNBOUNDED")) {
                        this.lexer.nextToken();
                        if (!this.lexer.stringVal().equalsIgnoreCase("PRECEDING")) throw new ParserException("syntax error");
                        this.lexer.nextToken();
                        System.out.println("yes, inside!!");
                        windowing.setExpr(new SQLIdentifierExpr("UNBOUNDED PRECEDING"));
                    }
                }
                over.setWindowing(windowing);
            }
        }
        this.accept(Token.RPAREN);
        aggregateExpr.setOver(over);
        return aggregateExpr;
    }

    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            SQLExpr value = this.expr();
            if (this.lexer.token() != Token.IDENTIFIER) {
                throw new ParserException("Syntax error");
            }
            String unit = this.lexer.stringVal();
            this.lexer.nextToken();
            TeradataIntervalExpr intervalExpr = new TeradataIntervalExpr();
            intervalExpr.setValue(value);
            intervalExpr.setUnit(TeradataIntervalUnit.valueOf(unit.toUpperCase()));
            return intervalExpr;
        }
        throw new ParserException("TODO with other interval");
    }
}

