/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.SQLSubPartitionBy;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.SQLSubPartitionByList;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.Token;

public class OracleCreateTableParser
extends SQLCreateTableParser {
    public OracleCreateTableParser(Lexer lexer) {
        super(new OracleExprParser(lexer));
    }

    public OracleCreateTableParser(String sql) {
        super(new OracleExprParser(sql));
    }

    @Override
    protected OracleCreateTableStatement newCreateStatement() {
        return new OracleCreateTableStatement();
    }

    @Override
    public OracleCreateTableStatement parseCrateTable(boolean acceptCreate) {
        OracleCreateTableStatement stmt;
        block24: {
            stmt = (OracleCreateTableStatement)super.parseCrateTable(acceptCreate);
            while (true) {
                OracleStorageClause storage;
                if (this.lexer.token() == Token.TABLESPACE) {
                    this.lexer.nextToken();
                    stmt.setTablespace(this.exprParser.name());
                    continue;
                }
                if (this.identifierEquals("IN_MEMORY_METADATA")) {
                    this.lexer.nextToken();
                    stmt.setInMemoryMetadata(true);
                    continue;
                }
                if (this.identifierEquals("CURSOR_SPECIFIC_SEGMENT")) {
                    this.lexer.nextToken();
                    stmt.setCursorSpecificSegment(true);
                    continue;
                }
                if (this.identifierEquals("NOPARALLEL")) {
                    this.lexer.nextToken();
                    stmt.setParallel(false);
                    continue;
                }
                if (this.lexer.token() == Token.LOGGING) {
                    this.lexer.nextToken();
                    stmt.setLogging(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.CACHE) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.NOCACHE) {
                    this.lexer.nextToken();
                    stmt.setCache(Boolean.FALSE);
                    continue;
                }
                if (this.lexer.token() == Token.NOCOMPRESS) {
                    this.lexer.nextToken();
                    stmt.setCompress(Boolean.FALSE);
                    continue;
                }
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    this.accept(Token.COMMIT);
                    stmt.setOnCommit(true);
                    continue;
                }
                if (this.identifierEquals("PRESERVE")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("ROWS");
                    stmt.setPreserveRows(true);
                    continue;
                }
                if (this.identifierEquals("STORAGE")) {
                    storage = ((OracleExprParser)this.exprParser).parseStorage();
                    stmt.setStorage(storage);
                    continue;
                }
                if (this.identifierEquals("organization")) {
                    this.lexer.nextToken();
                    this.accept(Token.INDEX);
                    stmt.setOrganizationIndex(true);
                    continue;
                }
                if (this.lexer.token() == Token.PCTFREE) {
                    this.lexer.nextToken();
                    stmt.setPtcfree(this.exprParser.expr());
                    continue;
                }
                if (this.identifierEquals("PCTUSED")) {
                    this.lexer.nextToken();
                    stmt.setPctused(this.exprParser.expr());
                    continue;
                }
                if (this.lexer.token() == Token.STORAGE) {
                    storage = ((OracleExprParser)this.exprParser).parseStorage();
                    stmt.setStorage(storage);
                    continue;
                }
                if (this.lexer.token() == Token.LOB) {
                    OracleLobStorageClause lobStorage = ((OracleExprParser)this.exprParser).parseLobStorage();
                    stmt.setLobStorage(lobStorage);
                    continue;
                }
                if (this.lexer.token() == Token.INITRANS) {
                    this.lexer.nextToken();
                    stmt.setInitrans(this.exprParser.expr());
                    continue;
                }
                if (this.lexer.token() == Token.MAXTRANS) {
                    this.lexer.nextToken();
                    stmt.setMaxtrans(this.exprParser.expr());
                    continue;
                }
                if (this.lexer.token() == Token.SEGMENT) {
                    this.lexer.nextToken();
                    this.accept(Token.CREATION);
                    if (this.lexer.token() == Token.IMMEDIATE) {
                        this.lexer.nextToken();
                        stmt.setDeferredSegmentCreation(OracleCreateTableStatement.DeferredSegmentCreation.IMMEDIATE);
                        continue;
                    }
                    this.accept(Token.DEFERRED);
                    stmt.setDeferredSegmentCreation(OracleCreateTableStatement.DeferredSegmentCreation.DEFERRED);
                    continue;
                }
                if (!this.identifierEquals("PARTITION")) break block24;
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.identifierEquals("RANGE")) {
                    SQLPartitionByRange partitionByRange = this.partitionByRange();
                    this.partitionClauseRest(partitionByRange);
                    stmt.setPartitioning(partitionByRange);
                    continue;
                }
                if (this.identifierEquals("HASH")) {
                    SQLPartitionByHash partitionByHash = this.partitionByHash();
                    this.partitionClauseRest(partitionByHash);
                    stmt.setPartitioning(partitionByHash);
                    continue;
                }
                if (!this.identifierEquals("LIST")) break;
                SQLPartitionByList partitionByList = this.partitionByList();
                this.partitionClauseRest(partitionByList);
                stmt.setPartitioning(partitionByList);
            }
            throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            OracleSelect select = new OracleSelectParser(this.exprParser).select();
            stmt.setSelect(select);
        }
        return stmt;
    }

    protected SQLPartitionByList partitionByList() {
        this.acceptIdentifier("LIST");
        SQLPartitionByList partitionByList = new SQLPartitionByList();
        this.accept(Token.LPAREN);
        partitionByList.setExpr(this.exprParser.expr());
        this.accept(Token.RPAREN);
        this.parsePartitionByRest(partitionByList);
        return partitionByList;
    }

    protected SQLPartitionByHash partitionByHash() {
        this.acceptIdentifier("HASH");
        SQLPartitionByHash partitionByHash = new SQLPartitionByHash();
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            partitionByHash.setKey(true);
        }
        this.accept(Token.LPAREN);
        partitionByHash.setExpr(this.exprParser.expr());
        this.accept(Token.RPAREN);
        return partitionByHash;
    }

    protected SQLPartitionByRange partitionByRange() {
        this.acceptIdentifier("RANGE");
        this.accept(Token.LPAREN);
        SQLPartitionByRange clause = new SQLPartitionByRange();
        while (true) {
            SQLName column = this.exprParser.name();
            clause.addColumn(column);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.INTERVAL) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            clause.setInterval(this.exprParser.expr());
            this.accept(Token.RPAREN);
        }
        this.parsePartitionByRest(clause);
        return clause;
    }

    protected void parsePartitionByRest(SQLPartitionBy clause) {
        if (this.lexer.token() == Token.STORE) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            while (true) {
                SQLName tablespace = this.exprParser.name();
                clause.getStoreIn().add(tablespace);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.identifierEquals("SUBPARTITION")) {
            SQLSubPartitionBy subPartitionBy = this.subPartitionBy();
            clause.setSubPartitionBy(subPartitionBy);
        }
        this.accept(Token.LPAREN);
        while (true) {
            SQLPartition partition = this.parsePartition();
            clause.addPartition(partition);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
    }

    protected SQLPartition parsePartition() {
        this.acceptIdentifier("PARTITION");
        SQLPartition partition = new SQLPartition();
        partition.setName(this.exprParser.name());
        SQLPartitionValue values = this.exprParser.parsePartitionValues();
        if (values != null) {
            partition.setValues(values);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                SQLSubPartition subPartition = this.parseSubPartition();
                partition.addSubPartition(subPartition);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        } else if (this.identifierEquals("SUBPARTITIONS")) {
            this.lexer.nextToken();
            SQLExpr subPartitionsCount = this.exprParser.primary();
            partition.setSubPartitionsCount(subPartitionsCount);
        }
        return partition;
    }

    protected SQLSubPartition parseSubPartition() {
        this.acceptIdentifier("SUBPARTITION");
        SQLSubPartition subPartition = new SQLSubPartition();
        SQLName name = this.exprParser.name();
        subPartition.setName(name);
        SQLPartitionValue values = this.exprParser.parsePartitionValues();
        if (values != null) {
            subPartition.setValues(values);
        }
        return subPartition;
    }

    protected void partitionClauseRest(SQLPartitionBy clause) {
        if (this.identifierEquals("PARTITIONS")) {
            this.lexer.nextToken();
            SQLIntegerExpr countExpr = this.exprParser.integerExpr();
            clause.setPartitionsCount(countExpr);
        }
        if (this.lexer.token() == Token.STORE) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            this.accept(Token.LPAREN);
            this.exprParser.names(clause.getStoreIn(), clause);
            this.accept(Token.RPAREN);
        }
    }

    protected SQLSubPartitionBy subPartitionBy() {
        this.lexer.nextToken();
        this.accept(Token.BY);
        if (this.identifierEquals("HASH")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLSubPartitionByHash byHash = new SQLSubPartitionByHash();
            SQLExpr expr = this.exprParser.expr();
            byHash.setExpr(expr);
            this.accept(Token.RPAREN);
            return byHash;
        }
        if (this.identifierEquals("LIST")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLSubPartitionByList byList = new SQLSubPartitionByList();
            SQLName column = this.exprParser.name();
            byList.setColumn(column);
            this.accept(Token.RPAREN);
            if (this.identifierEquals("SUBPARTITION")) {
                this.lexer.nextToken();
                this.acceptIdentifier("TEMPLATE");
                this.accept(Token.LPAREN);
                while (true) {
                    SQLSubPartition subPartition = this.parseSubPartition();
                    subPartition.setParent(byList);
                    byList.getSubPartitionTemplate().add(subPartition);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            return byList;
        }
        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }
}

