/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLArgument;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLKeep;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.SQLSubPartitionByList;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseStatement;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLFlashbackExpr;
import com.alibaba.druid.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAnalyzePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCheckPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCoalescePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableConvertCharSet;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDiscardPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeignKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableImportPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableOptimizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableReOrganizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRebuildPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenamePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRepairPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetComment;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTouch;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTruncatePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewRenameStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLCloseStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLColumnPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLColumnReference;
import com.alibaba.druid.sql.ast.statement.SQLColumnUniqueKey;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeclareStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDescribeStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableSpaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprHint;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLoopStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLNotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLOpenStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLReleaseSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLReturnStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.ast.statement.SQLWhileStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSegmentAttributes;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreatePackageStatement;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitorUtils;
import com.alibaba.druid.sql.visitor.ParameterizedOutputVisitorUtils;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import com.alibaba.druid.sql.visitor.PrintableVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitorUtils;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SQLASTOutputVisitor
extends SQLASTVisitorAdapter
implements ParameterizedVisitor,
PrintableVisitor {
    protected final Appendable appender;
    private String indent = "\t";
    private int indentCount = 0;
    private boolean prettyFormat = true;
    protected boolean ucase = true;
    protected int selectListNumberOfLine = 5;
    protected boolean groupItemSingleLine = false;
    protected List<Object> parameters;
    protected List<Object> inputParameters;
    protected Set<String> tables;
    protected boolean exportTables = false;
    protected String dbType;
    protected Map<String, String> tableMapping;
    protected int replaceCount;
    protected boolean parameterized = false;
    protected boolean parameterizedMergeInList = false;
    protected boolean shardingSupport = false;
    protected transient int lines = 0;
    protected boolean desensitize = false;

    public SQLASTOutputVisitor(Appendable appender) {
        this.appender = appender;
    }

    public SQLASTOutputVisitor(Appendable appender, String dbType) {
        this.appender = appender;
        this.dbType = dbType;
    }

    public SQLASTOutputVisitor(Appendable appender, boolean parameterized) {
        this.appender = appender;
        this.parameterized = parameterized;
    }

    @Override
    public int getReplaceCount() {
        return this.replaceCount;
    }

    @Override
    public void incrementReplaceCunt() {
        ++this.replaceCount;
    }

    public void addTableMapping(String srcTable, String destTable) {
        if (this.tableMapping == null) {
            this.tableMapping = new HashMap<String, String>();
        }
        this.tableMapping.put(srcTable, destTable);
    }

    public void setTableMapping(Map<String, String> tableMapping) {
        this.tableMapping = tableMapping;
    }

    public List<Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        return this.parameters;
    }

    public boolean isDesensitize() {
        return this.desensitize;
    }

    public void setDesensitize(boolean desensitize) {
        this.desensitize = desensitize;
    }

    public Set<String> getTables() {
        return this.tables;
    }

    @Deprecated
    public void setParameters(List<Object> parameters) {
        if (parameters != null && parameters.size() > 0) {
            this.inputParameters = parameters;
        } else {
            this.parameters = parameters;
        }
    }

    public void setInputParameters(List<Object> parameters) {
        this.inputParameters = parameters;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public Appendable getAppender() {
        return this.appender;
    }

    public boolean isPrettyFormat() {
        return this.prettyFormat;
    }

    public void setPrettyFormat(boolean prettyFormat) {
        this.prettyFormat = prettyFormat;
    }

    public void decrementIndent() {
        --this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public boolean isParameterized() {
        return this.parameterized;
    }

    public void setParameterized(boolean parameterized) {
        this.parameterized = parameterized;
    }

    public boolean isParameterizedMergeInList() {
        return this.parameterizedMergeInList;
    }

    public void setParameterizedMergeInList(boolean parameterizedMergeInList) {
        this.parameterizedMergeInList = parameterizedMergeInList;
    }

    public boolean isExportTables() {
        return this.exportTables;
    }

    public void setExportTables(boolean exportTables) {
        this.exportTables = exportTables;
    }

    @Override
    public void print(char value) {
        if (this.appender == null) {
            return;
        }
        try {
            this.appender.append(value);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    public void print(int value) {
        if (this.appender == null) {
            return;
        }
        this.print0(Integer.toString(value));
    }

    public void print(Date date) {
        if (this.appender == null) {
            return;
        }
        SimpleDateFormat dateFormat = date instanceof Timestamp ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : new SimpleDateFormat("yyyy-MM-dd");
        this.print0("'" + dateFormat.format(date) + "'");
    }

    public void print(long value) {
        if (this.appender == null) {
            return;
        }
        this.print0(Long.toString(value));
    }

    @Override
    public void print(String text) {
        if (this.appender == null) {
            return;
        }
        this.print0(text);
    }

    protected void print0(String text) {
        if (this.appender == null) {
            return;
        }
        try {
            this.appender.append(text);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    protected void printAlias(String alias) {
        if (alias != null && alias.length() > 0) {
            this.print(' ');
            this.print0(alias);
        }
    }

    protected void printAndAccept(List<? extends SQLObject> nodes, String seperator) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(seperator);
            }
            nodes.get(i).accept(this);
        }
    }

    protected void printSelectList(List<SQLSelectItem> selectList) {
        this.incrementIndent();
        int i = 0;
        int lineItemCount = 0;
        int size = selectList.size();
        while (i < size) {
            SQLSelectItem selectItem = selectList.get(i);
            SQLExpr selectItemExpr = selectItem.getExpr();
            if (i != 0) {
                SQLSelectItem preSelectItem = selectList.get(i - 1);
                if (preSelectItem.getAfterCommentsDirect() != null) {
                    lineItemCount = 0;
                    this.println();
                } else if (selectItemExpr instanceof SQLMethodInvokeExpr) {
                    SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)selectItemExpr;
                    int paramCount = methodInvokeExpr.getParameters().size();
                    if ((lineItemCount += paramCount) >= this.selectListNumberOfLine) {
                        lineItemCount = paramCount;
                        this.println();
                    }
                } else if (lineItemCount >= this.selectListNumberOfLine || selectItemExpr instanceof SQLQueryExpr || selectItemExpr instanceof SQLCaseExpr) {
                    lineItemCount = 0;
                    this.println();
                }
                this.print0(", ");
            }
            if (selectItem.getClass() == SQLSelectItem.class) {
                this.visit(selectItem);
            } else {
                selectItem.accept(this);
            }
            if (selectItem.hasAfterComment()) {
                this.print(' ');
                this.printlnComment(selectItem.getAfterCommentsDirect());
            }
            ++i;
            ++lineItemCount;
        }
        this.decrementIndent();
    }

    protected void printlnAndAccept(List<? extends SQLObject> nodes, String seperator) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println(seperator);
            }
            nodes.get(i).accept(this);
        }
    }

    public void printIndent() {
        for (int i = 0; i < this.indentCount; ++i) {
            this.print0(this.indent);
        }
    }

    public void println() {
        if (!this.isPrettyFormat()) {
            this.print(' ');
            return;
        }
        this.print0("\n");
        ++this.lines;
        this.printIndent();
    }

    public void println(String text) {
        this.print(text);
        this.println();
    }

    protected void println0(String text) {
        this.print0(text);
        this.println();
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        x.getTestExpr().accept(this);
        if (x.isNot()) {
            this.print0(this.ucase ? " NOT BETWEEN " : " not between ");
        } else {
            this.print0(this.ucase ? " BETWEEN " : " between ");
        }
        x.getBeginExpr().accept(this);
        this.print0(this.ucase ? " AND " : " and ");
        x.getEndExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        boolean relational;
        Object param;
        SQLVariantRefExpr right;
        int index;
        if (this.parameterized) {
            x = ParameterizedOutputVisitorUtils.merge(this, x);
        }
        SQLBinaryOperator operator = x.getOperator();
        if (this.inputParameters != null && this.inputParameters.size() > 0 && operator == SQLBinaryOperator.Equality && x.getRight() instanceof SQLVariantRefExpr && (index = (right = (SQLVariantRefExpr)x.getRight()).getIndex()) >= 0 && index < this.inputParameters.size() && (param = this.inputParameters.get(index)) instanceof Collection) {
            x.getLeft().accept(this);
            this.print0(" IN (");
            right.accept(this);
            this.print(')');
            return false;
        }
        SQLObject parent = x.getParent();
        boolean isRoot = parent instanceof SQLSelectQueryBlock;
        boolean bl = relational = operator == SQLBinaryOperator.BooleanAnd || operator == SQLBinaryOperator.BooleanOr;
        if (isRoot && relational) {
            this.incrementIndent();
        }
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        SQLExpr left = x.getLeft();
        SQLExpr right2 = x.getRight();
        while (left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == operator) {
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            groupList.add(binaryLeft.getRight());
            left = binaryLeft.getLeft();
        }
        groupList.add(left);
        for (int i = groupList.size() - 1; i >= 0; --i) {
            SQLExpr item = (SQLExpr)groupList.get(i);
            if (relational && this.isPrettyFormat() && item.hasBeforeComment()) {
                this.printlnComments(item.getBeforeCommentsDirect());
            }
            if (this.isPrettyFormat() && item.hasBeforeComment()) {
                this.printlnComments(item.getBeforeCommentsDirect());
            }
            this.visitBinaryLeft(item, operator);
            if (this.isPrettyFormat() && item.hasAfterComment()) {
                this.print(' ');
                this.printlnComment(item.getAfterCommentsDirect());
            }
            if (i != groupList.size() - 1 && this.isPrettyFormat() && item.getParent().hasAfterComment()) {
                this.print(' ');
                this.printlnComment(item.getParent().getAfterCommentsDirect());
            }
            boolean printOpSpace = true;
            if (relational) {
                this.println();
            } else {
                if (operator == SQLBinaryOperator.Modulus && "oracle".equals(this.dbType) && left instanceof SQLIdentifierExpr && right2 instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)right2).getName().equalsIgnoreCase("NOTFOUND")) {
                    printOpSpace = false;
                }
                if (printOpSpace) {
                    this.print(' ');
                }
            }
            this.printOperator(operator);
            if (!printOpSpace) continue;
            this.print(' ');
        }
        this.visitorBinaryRight(x);
        if (isRoot && relational) {
            this.decrementIndent();
        }
        return false;
    }

    protected void printOperator(SQLBinaryOperator operator) {
        this.print0(this.ucase ? operator.name : operator.name_lcase);
    }

    private void visitorBinaryRight(SQLBinaryOpExpr x) {
        if (this.isPrettyFormat() && x.getRight().hasBeforeComment()) {
            this.printlnComments(x.getRight().getBeforeCommentsDirect());
        }
        if (x.getRight() instanceof SQLBinaryOpExpr) {
            boolean rightRational;
            SQLBinaryOpExpr right = (SQLBinaryOpExpr)x.getRight();
            boolean bl = rightRational = right.getOperator() == SQLBinaryOperator.BooleanAnd || right.getOperator() == SQLBinaryOperator.BooleanOr;
            if (right.getOperator().priority >= x.getOperator().priority) {
                if (rightRational) {
                    this.incrementIndent();
                }
                this.print('(');
                right.accept(this);
                this.print(')');
                if (rightRational) {
                    this.decrementIndent();
                }
            } else {
                right.accept(this);
            }
        } else {
            x.getRight().accept(this);
        }
        if (x.getRight().hasAfterComment() && this.isPrettyFormat()) {
            this.print(' ');
            this.printlnComment(x.getRight().getAfterCommentsDirect());
        }
    }

    private void visitBinaryLeft(SQLExpr left, SQLBinaryOperator op) {
        if (left instanceof SQLBinaryOpExpr) {
            boolean leftRational;
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            boolean bl = leftRational = binaryLeft.getOperator() == SQLBinaryOperator.BooleanAnd || binaryLeft.getOperator() == SQLBinaryOperator.BooleanOr;
            if (binaryLeft.getOperator().priority > op.priority) {
                if (leftRational) {
                    this.incrementIndent();
                }
                this.print('(');
                left.accept(this);
                this.print(')');
                if (leftRational) {
                    this.decrementIndent();
                }
            } else {
                left.accept(this);
            }
        } else {
            left.accept(this);
        }
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        this.incrementIndent();
        this.print0(this.ucase ? "CASE " : "case ");
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(this);
        }
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            this.println();
            x.getItems().get(i).accept(this);
        }
        SQLExpr elExpr = x.getElseExpr();
        if (elExpr != null) {
            this.println();
            this.print0(this.ucase ? "ELSE " : "else ");
            if (elExpr instanceof SQLCaseExpr) {
                this.incrementIndent();
                this.println();
                elExpr.accept(this);
                this.decrementIndent();
            } else {
                elExpr.accept(this);
            }
        }
        this.decrementIndent();
        this.println();
        this.print0(this.ucase ? "END" : "end");
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr.Item x) {
        this.print0(this.ucase ? "WHEN " : "when ");
        SQLExpr expr = x.getConditionExpr();
        expr.accept(this);
        this.print0(this.ucase ? " THEN " : " then ");
        SQLExpr valueExpr = x.getValueExpr();
        if (valueExpr instanceof SQLCaseExpr) {
            this.incrementIndent();
            this.println();
            valueExpr.accept(this);
            this.decrementIndent();
        } else {
            valueExpr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCaseStatement x) {
        this.print0(this.ucase ? "CASE" : "case");
        if (x.getValueExpr() != null) {
            this.print(' ');
            x.getValueExpr().accept(this);
        }
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getItems(), " ");
        if (x.getElseStatements().size() > 0) {
            this.println();
            this.print0(this.ucase ? "ELSE " : "else ");
            this.printlnAndAccept(x.getElseStatements(), "");
        }
        this.decrementIndent();
        this.println();
        this.print0(this.ucase ? "END CASE" : "end case");
        if ("oracle".equals(this.dbType)) {
            this.print(';');
        }
        return false;
    }

    @Override
    public boolean visit(SQLCaseStatement.Item x) {
        this.print0(this.ucase ? "WHEN " : "when ");
        x.getConditionExpr().accept(this);
        this.print0(this.ucase ? " THEN " : " then ");
        SQLStatement stmt = x.getStatement();
        if (stmt != null) {
            stmt.accept(this);
            this.print(';');
        }
        return false;
    }

    @Override
    public boolean visit(SQLCastExpr x) {
        this.print0(this.ucase ? "CAST(" : "cast(");
        x.getExpr().accept(this);
        this.print0(this.ucase ? " AS " : " as ");
        x.getDataType().accept(this);
        this.print0(")");
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (this.parameterized && ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            this.print('?');
            this.incrementReplaceCunt();
            if (this instanceof ExportParameterVisitor || this.parameters != null) {
                ExportParameterVisitorUtils.exportParameter(this.parameters, x);
            }
            return false;
        }
        if (x.getText() == null) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            this.print('\'');
            this.print0(x.getText().replaceAll("'", "''"));
            this.print('\'');
        }
        return false;
    }

    @Override
    public boolean visit(SQLDataType x) {
        this.printDataType(x);
        return false;
    }

    protected void printDataType(SQLDataType x) {
        this.print0(x.getName());
        if (x.getArguments().size() > 0) {
            this.print('(');
            this.printAndAccept(x.getArguments(), ", ");
            this.print(')');
        }
    }

    @Override
    public boolean visit(SQLCharacterDataType x) {
        this.visit((SQLDataType)x);
        List<SQLCommentHint> hints = x.hints;
        if (hints != null) {
            this.print(' ');
            for (SQLCommentHint hint : hints) {
                hint.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLExistsExpr x) {
        if (x.isNot()) {
            this.print0(this.ucase ? "NOT EXISTS (" : "not exists (");
        } else {
            this.print0(this.ucase ? "EXISTS (" : "exists (");
        }
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name = x.getName();
        if (!this.parameterized) {
            this.print0(x.getName());
            return false;
        }
        return this.printName(x, name);
    }

    private boolean printName(SQLName x, String name) {
        boolean shardingSupport;
        boolean bl = shardingSupport = this.shardingSupport && this.parameterized;
        if (shardingSupport) {
            SQLObject parent = x.getParent();
            boolean bl2 = shardingSupport = parent instanceof SQLExprTableSource || parent instanceof SQLPropertyExpr;
        }
        if (shardingSupport) {
            char ch;
            int pos = name.lastIndexOf(95);
            if (pos != -1 && pos != name.length() - 1) {
                int pos2;
                boolean quote = name.charAt(0) == '`' && name.charAt(name.length() - 1) == '`';
                boolean isNumber = true;
                int end = name.length();
                if (quote) {
                    --end;
                }
                for (int i = pos + 1; i < end; ++i) {
                    char ch2 = name.charAt(i);
                    if (ch2 >= '0' && ch2 <= '9') continue;
                    isNumber = false;
                    break;
                }
                if (isNumber && (pos2 = name.lastIndexOf(95, pos - 1)) != -1) {
                    boolean isNumber2 = true;
                    for (int i = pos2 + 1; i < pos; ++i) {
                        char ch3 = name.charAt(i);
                        if (ch3 >= '0' && ch3 <= '9') continue;
                        isNumber2 = false;
                        break;
                    }
                    if (isNumber2) {
                        pos = pos2;
                    }
                }
                if (isNumber) {
                    boolean isAlias = false;
                    for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof SQLSelectQueryBlock)) continue;
                        SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                        if (quote) {
                            String name2 = name.substring(1, name.length() - 1);
                            if (!this.isTableSourceAlias(from, name, name2)) break;
                            isAlias = true;
                            break;
                        }
                        if (!this.isTableSourceAlias(from, name)) break;
                        isAlias = true;
                        break;
                    }
                    if (!isAlias) {
                        int start = quote ? 1 : 0;
                        String realName = name.substring(start, pos);
                        this.print0(realName);
                        this.incrementReplaceCunt();
                        return false;
                    }
                    this.print0(name);
                    return false;
                }
            }
            int numberCount = 0;
            for (int i = name.length() - 1; i >= 0 && (ch = name.charAt(i)) >= '0' && ch <= '9'; --i) {
                ++numberCount;
            }
            if (numberCount > 1) {
                int numPos = name.length() - numberCount;
                String realName = name.substring(0, numPos);
                this.print0(realName);
                this.incrementReplaceCunt();
                return false;
            }
        }
        this.print0(name);
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        int i;
        int size;
        if (this.parameterized) {
            List<SQLExpr> targetList = x.getTargetList();
            boolean changed = true;
            if (targetList.size() == 1 && targetList.get(0) instanceof SQLVariantRefExpr) {
                changed = false;
            }
            x.getExpr().accept(this);
            if (x.isNot()) {
                this.print(this.isUppCase() ? " NOT IN (?)" : " not in (?)");
            } else {
                this.print(this.isUppCase() ? " IN (?)" : " in (?)");
            }
            if (changed) {
                this.incrementReplaceCunt();
                if (this instanceof ExportParameterVisitor || this.parameters != null) {
                    if (this.parameterizedMergeInList) {
                        ArrayList<Object> subList = new ArrayList<Object>(x.getTargetList().size());
                        for (SQLExpr target : x.getTargetList()) {
                            ExportParameterVisitorUtils.exportParameter(subList, target);
                        }
                        if (subList != null) {
                            this.parameters.add(subList);
                        }
                    } else {
                        for (SQLExpr target : x.getTargetList()) {
                            ExportParameterVisitorUtils.exportParameter(this.parameters, target);
                        }
                    }
                }
            }
            return false;
        }
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print0(this.ucase ? " NOT IN (" : " not in (");
        } else {
            this.print0(this.ucase ? " IN (" : " in (");
        }
        List<SQLExpr> list = x.getTargetList();
        boolean printLn = false;
        if (list.size() > 5) {
            printLn = true;
            size = list.size();
            for (i = 0; i < size; ++i) {
                if (list.get(i) instanceof SQLCharExpr) continue;
                printLn = false;
                break;
            }
        }
        if (printLn) {
            this.incrementIndent();
            this.println();
            size = list.size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                list.get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
        } else {
            this.printAndAccept(x.getTargetList(), ", ");
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        SQLObject parent;
        int val = x.getNumber().intValue();
        if (val == 1 && "oracle".equals(this.dbType) && (parent = x.getParent()) instanceof SQLBinaryOpExpr) {
            String name;
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)parent;
            SQLExpr left = binaryOpExpr.getLeft();
            SQLBinaryOperator op = binaryOpExpr.getOperator();
            if (left instanceof SQLIdentifierExpr && op == SQLBinaryOperator.Equality && "rownum".equals(name = ((SQLIdentifierExpr)left).getName())) {
                this.print(1);
                return false;
            }
        }
        if (this.parameterized && ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
                return SQLASTOutputVisitorUtils.visit((PrintableVisitor)this, x);
            }
            this.print('?');
            this.incrementReplaceCunt();
            if (this instanceof ExportParameterVisitor || this.parameters != null) {
                ExportParameterVisitorUtils.exportParameter(this.parameters, x);
            }
            return false;
        }
        return SQLASTOutputVisitorUtils.visit((PrintableVisitor)this, x);
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        SQLExpr owner = x.getOwner();
        if (owner != null) {
            this.printMethodOwner(owner);
        }
        String function = x.getMethodName();
        this.printFunctionName(function);
        this.print('(');
        List<SQLExpr> parameters = x.getParameters();
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            SQLBinaryOpExpr binaryOpExpr;
            SQLBinaryOperator op;
            if (i != 0) {
                this.print0(", ");
            }
            SQLExpr param = x.getParameters().get(i);
            if (this.parameterized && "oracle".equalsIgnoreCase(this.dbType) && size == 2 && i == 1 && param instanceof SQLCharExpr && ("TO_CHAR".equalsIgnoreCase(function) || "TO_DATE".equalsIgnoreCase(function))) {
                param.putAttribute("druid.parameterized.skip", true);
            }
            if (param instanceof SQLBinaryOpExpr && ((op = (binaryOpExpr = (SQLBinaryOpExpr)param).getOperator()) == SQLBinaryOperator.BooleanAnd || op == SQLBinaryOperator.BooleanOr)) {
                this.incrementIndent();
                param.accept(this);
                this.decrementIndent();
                continue;
            }
            param.accept(this);
        }
        SQLExpr from = x.getFrom();
        if (from != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            from.accept(this);
        }
        this.print(')');
        return false;
    }

    protected void printMethodOwner(SQLExpr owner) {
        owner.accept(this);
        this.print('.');
    }

    protected void printFunctionName(String name) {
        this.print0(name);
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        this.print0(this.ucase ? x.getMethodName() : x.getMethodName().toLowerCase());
        this.print('(');
        if (x.getOption() != null) {
            this.print0(x.getOption().toString());
            this.print(' ');
        }
        this.printAndAccept(x.getArguments(), ", ");
        this.visitAggreateRest(x);
        this.print(')');
        if (x.getWithinGroup() != null) {
            this.print0(this.ucase ? " WITHIN GROUP (" : " within group (");
            x.getWithinGroup().accept(this);
            this.print(')');
        }
        if (x.getKeep() != null) {
            this.print(' ');
            x.getKeep().accept(this);
        }
        if (x.getOver() != null) {
            this.print(' ');
            x.getOver().accept(this);
        }
        return false;
    }

    protected void visitAggreateRest(SQLAggregateExpr aggregateExpr) {
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        this.print('*');
        return true;
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        if (this.parameterized && ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            this.print('?');
            this.incrementReplaceCunt();
            if (this instanceof ExportParameterVisitor || this.parameters != null) {
                ExportParameterVisitorUtils.exportParameter(this.parameters, x);
            }
            return false;
        }
        if (x.getText() == null || x.getText().length() == 0) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            this.print0(this.ucase ? "N'" : "n'");
            this.print0(x.getText().replace("'", "''"));
            this.print('\'');
        }
        return false;
    }

    @Override
    public boolean visit(SQLNotExpr x) {
        this.print0(this.ucase ? "NOT " : "not ");
        SQLExpr expr = x.getExpr();
        boolean needQuote = false;
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)expr;
            needQuote = binaryOpExpr.getOperator().isLogical();
        }
        if (needQuote) {
            this.print('(');
        }
        expr.accept(this);
        if (needQuote) {
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLNullExpr x) {
        SQLObject parent;
        if (this.parameterized && ParameterizedOutputVisitorUtils.checkParameterize(x) && (parent = x.getParent()) instanceof SQLInsertStatement.ValuesClause) {
            this.print('?');
            this.incrementReplaceCunt();
            if (this instanceof ExportParameterVisitor || this.parameters != null) {
                this.getParameters().add(null);
            }
            return false;
        }
        this.print0(this.ucase ? "NULL" : "null");
        return false;
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        if (this.parameterized && ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            this.print('?');
            this.incrementReplaceCunt();
            if (this instanceof ExportParameterVisitor || this.parameters != null) {
                ExportParameterVisitorUtils.exportParameter(this.getParameters(), x);
            }
            return false;
        }
        return SQLASTOutputVisitorUtils.visit((PrintableVisitor)this, x);
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        SQLExpr owner = x.getOwner();
        String mapTableName = null;
        String ownerName = null;
        if (owner instanceof SQLIdentifierExpr) {
            ownerName = ((SQLIdentifierExpr)owner).getName();
            if (this.tableMapping != null && (mapTableName = this.tableMapping.get(ownerName)) == null && ownerName.length() > 2 && ownerName.charAt(0) == '`' && ownerName.charAt(ownerName.length() - 1) == '`') {
                ownerName = ownerName.substring(1, ownerName.length() - 1);
                mapTableName = this.tableMapping.get(ownerName);
            }
        }
        if (mapTableName != null) {
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof SQLSelectQueryBlock)) continue;
                SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                if (!this.isTableSourceAlias(from, mapTableName, ownerName)) break;
                mapTableName = null;
                break;
            }
        }
        if (mapTableName != null) {
            this.print0(mapTableName);
        } else if (owner instanceof SQLIdentifierExpr && x.getParent() instanceof SQLExprTableSource) {
            this.print0(((SQLIdentifierExpr)owner).getName());
        } else {
            owner.accept(this);
        }
        this.print('.');
        String name = x.getName();
        this.printName(x, name);
        return false;
    }

    protected boolean isTableSourceAlias(SQLTableSource from, String ... tableNames) {
        String alias = from.getAlias();
        if (alias != null) {
            for (String tableName : tableNames) {
                if (!alias.equalsIgnoreCase(tableName)) continue;
                return true;
            }
            if (alias.length() > 2 && alias.charAt(0) == '`' && alias.charAt(alias.length() - 1) == '`') {
                alias = alias.substring(1, alias.length() - 1);
                for (String tableName : tableNames) {
                    if (!alias.equalsIgnoreCase(tableName)) continue;
                    return true;
                }
            }
        }
        if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)from;
            return this.isTableSourceAlias(join.getLeft(), tableNames) || this.isTableSourceAlias(join.getRight(), tableNames);
        }
        return false;
    }

    @Override
    public boolean visit(SQLQueryExpr x) {
        SQLObject parent = x.getParent();
        if (parent instanceof SQLSelect) {
            parent = parent.getParent();
        }
        if (parent instanceof SQLStatement) {
            this.incrementIndent();
            this.println();
            x.getSubQuery().accept(this);
            this.decrementIndent();
        } else if (parent instanceof SQLInsertStatement.ValuesClause) {
            this.println();
            this.print('(');
            x.getSubQuery().accept(this);
            this.print(')');
            this.println();
        } else if (parent instanceof SQLOpenStatement) {
            x.getSubQuery().accept(this);
        } else {
            this.print('(');
            this.incrementIndent();
            this.println();
            x.getSubQuery().accept(this);
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        int itemSize = x.getItems().size();
        if (itemSize > 0) {
            this.print0(this.ucase ? "GROUP BY " : "group by ");
            this.incrementIndent();
            for (int i = 0; i < itemSize; ++i) {
                if (i != 0) {
                    if (this.groupItemSingleLine) {
                        this.println(", ");
                    } else {
                        this.print(", ");
                    }
                }
                x.getItems().get(i).accept(this);
            }
            this.decrementIndent();
        }
        if (x.getHaving() != null) {
            this.println();
            this.print0(this.ucase ? "HAVING " : "having ");
            x.getHaving().accept(this);
        }
        if (x.isWithRollUp()) {
            this.print0(this.ucase ? " WITH ROLLUP" : " with rollup");
        }
        if (x.isWithCube()) {
            this.print0(this.ucase ? " WITH CUBE" : " with cube");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        x.getQuery().setParent(x);
        if (x.getWithSubQuery() != null) {
            x.getWithSubQuery().accept(this);
            this.println();
        }
        x.getQuery().accept(this);
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getHintsSize() > 0) {
            this.printAndAccept(x.getHints(), "");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SQLExpr where;
        if (this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        if ("informix".equals(this.dbType)) {
            this.printFetchFirst(x);
        }
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == x.getDistionOption()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept(this);
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            where.setParent(x);
            where.accept(this);
        }
        this.printHierarchical(x);
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (!"informix".equals(this.dbType)) {
            this.printFetchFirst(x);
        }
        return false;
    }

    protected void printFetchFirst(SQLSelectQueryBlock x) {
        SQLLimit limit = x.getLimit();
        if (limit == null) {
            return;
        }
        SQLExpr offset = limit.getOffset();
        SQLExpr first = limit.getRowCount();
        if (limit != null) {
            if ("informix".equals(this.dbType)) {
                if (offset != null) {
                    this.print0(this.ucase ? "SKIP " : "skip ");
                    offset.accept(this);
                }
                this.print0(this.ucase ? " FIRST " : " first ");
                first.accept(this);
                this.print(' ');
            } else if ("db2".equals(this.dbType) || "oracle".equals(this.dbType) || "sqlserver".equals(this.dbType)) {
                SQLOrderBy orderBy;
                SQLObject parent = x.getParent();
                if (parent instanceof SQLSelect && (orderBy = ((SQLSelect)parent).getOrderBy()) != null && orderBy.getItems().size() > 0) {
                    this.println();
                    this.print0(this.ucase ? "ORDER BY " : "order by ");
                    this.printAndAccept(orderBy.getItems(), ", ");
                }
                this.println();
                if (offset != null) {
                    this.print0(this.ucase ? "OFFSET " : "offset ");
                    offset.accept(this);
                    this.print0(this.ucase ? " ROWS " : " rows ");
                }
                this.print0(this.ucase ? "FETCH FIRST " : "fetch first ");
                first.accept(this);
                this.print0(this.ucase ? " ROWS ONLY" : " rows only");
            } else {
                this.println();
                limit.accept(this);
            }
        }
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        if (x.isConnectByRoot()) {
            this.print0(this.ucase ? "CONNECT_BY_ROOT " : "connect_by_root ");
        }
        x.getExpr().accept(this);
        String alias = x.getAlias();
        if (alias != null && alias.length() > 0) {
            this.print0(this.ucase ? " AS " : " as ");
            if (alias.indexOf(32) == -1 || alias.charAt(0) == '\"' || alias.charAt(0) == '\'') {
                this.print0(alias);
            } else {
                this.print('\"');
                this.print0(alias);
                this.print('\"');
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        if (x.getItems().size() > 0) {
            if (x.isSibings()) {
                this.print0(this.ucase ? "ORDER SIBLINGS BY " : "order siblings by ");
            } else {
                this.print0(this.ucase ? "ORDER BY " : "order by ");
            }
            this.printAndAccept(x.getItems(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectOrderByItem x) {
        x.getExpr().accept(this);
        if (x.getType() != null) {
            this.print(' ');
            SQLOrderingSpecification type = x.getType();
            this.print0(this.ucase ? type.name : type.name_lcase);
        }
        if (x.getCollate() != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(x.getCollate());
        }
        if (x.getNullsOrderType() != null) {
            this.print(' ');
            this.print0(x.getNullsOrderType().toFormalString());
        }
        return false;
    }

    protected void addTable(String table) {
        if (this.tables == null) {
            this.tables = new LinkedHashSet<String>();
        }
        this.tables.add(table);
    }

    protected void printTableSourceExpr(SQLExpr expr) {
        SQLPropertyExpr propertyExpr;
        if (this.exportTables) {
            this.addTable(expr.toString());
        }
        if (this.desensitize) {
            Object owner = null;
            String ident = null;
            if (expr instanceof SQLIdentifierExpr) {
                ident = ((SQLIdentifierExpr)expr).getName();
            } else if (expr instanceof SQLPropertyExpr) {
                propertyExpr = (SQLPropertyExpr)expr;
                propertyExpr.getOwner().accept(this);
                this.print('.');
                ident = propertyExpr.getName();
            }
            if (ident != null) {
                String desensitizeTable = SQLUtils.desensitizeTable(ident);
                this.print0(desensitizeTable);
                return;
            }
        }
        if (this.tableMapping != null && expr instanceof SQLName) {
            String tableName = expr.toString();
            String destTableName = this.tableMapping.get(tableName);
            if (destTableName == null) {
                if (expr instanceof SQLPropertyExpr) {
                    propertyExpr = (SQLPropertyExpr)expr;
                    String propName = propertyExpr.getName();
                    destTableName = this.tableMapping.get(propName);
                    if (destTableName == null && propName.length() > 2 && propName.charAt(0) == '`' && propName.charAt(propName.length() - 1) == '`') {
                        destTableName = this.tableMapping.get(propName.substring(1, propName.length() - 1));
                    }
                    if (destTableName != null) {
                        propertyExpr.getOwner().accept(this);
                        this.print('.');
                        this.print(destTableName);
                        return;
                    }
                } else if (expr instanceof SQLIdentifierExpr) {
                    boolean quote;
                    boolean bl = quote = tableName.length() > 2 && tableName.charAt(0) == '`' && tableName.charAt(tableName.length() - 1) == '`';
                    if (quote) {
                        destTableName = this.tableMapping.get(tableName.substring(1, tableName.length() - 1));
                    }
                }
            }
            if (destTableName != null) {
                tableName = destTableName;
                this.print0(tableName);
                return;
            }
        }
        expr.accept(this);
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        this.printTableSourceExpr(x.getExpr());
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        if (this.isPrettyFormat() && x.hasAfterComment()) {
            this.print(' ');
            this.printlnComment(x.getAfterCommentsDirect());
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectStatement stmt) {
        List<SQLCommentHint> headHints = stmt.getHeadHintsDirect();
        if (headHints != null) {
            for (SQLCommentHint hint : headHints) {
                hint.accept(this);
                this.println();
            }
        }
        SQLSelect select = stmt.getSelect();
        select.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        SQLBinaryOpExpr binaryOpExpr;
        int index = x.getIndex();
        if (index < 0 || this.inputParameters == null || index >= this.inputParameters.size()) {
            this.print0(x.getName());
            return false;
        }
        Object param = this.inputParameters.get(index);
        SQLObject parent = x.getParent();
        boolean in = parent instanceof SQLInListExpr ? true : (parent instanceof SQLBinaryOpExpr ? (binaryOpExpr = (SQLBinaryOpExpr)parent).getOperator() == SQLBinaryOperator.Equality : false);
        if (in && param instanceof Collection) {
            boolean first = true;
            for (Object item : (Collection)param) {
                if (!first) {
                    this.print0(", ");
                }
                this.printParameter(item);
                first = false;
            }
        } else {
            this.printParameter(param);
        }
        return false;
    }

    public void printParameter(Object param) {
        if (param == null) {
            this.print0(this.ucase ? "NULL" : "null");
            return;
        }
        if (param instanceof Number || param instanceof Boolean) {
            this.print0(param.toString());
            return;
        }
        if (param instanceof String) {
            SQLCharExpr charExpr = new SQLCharExpr((String)param);
            this.visit(charExpr);
            return;
        }
        if (param instanceof Date) {
            this.print((Date)param);
            return;
        }
        if (param instanceof InputStream) {
            this.print0("'<InputStream>");
            return;
        }
        if (param instanceof Reader) {
            this.print0("'<Reader>");
            return;
        }
        if (param instanceof Blob) {
            this.print0("'<Blob>");
            return;
        }
        if (param instanceof NClob) {
            this.print0("'<NClob>");
            return;
        }
        if (param instanceof Clob) {
            this.print0("'<Clob>");
            return;
        }
        if (param instanceof byte[]) {
            byte[] bytes = (byte[])param;
            int bytesLen = bytes.length;
            char[] chars = new char[bytesLen * 2 + 3];
            chars[0] = 120;
            chars[1] = 39;
            for (int i = 0; i < bytes.length; ++i) {
                int a = bytes[i] & 0xFF;
                int b0 = a >> 4;
                int b1 = a & 0xF;
                chars[i * 2 + 2] = (char)(b0 + (b0 < 10 ? 48 : 55));
                chars[i * 2 + 3] = (char)(b1 + (b1 < 10 ? 48 : 55));
            }
            chars[chars.length - 1] = 39;
            this.print0(new String(chars));
            return;
        }
        this.print0("'" + param.getClass().getName() + "'");
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        if (x.isTemporary()) {
            this.print0(this.ucase ? "DROP TEMPORARY TABLE " : "drop temporary table ");
        } else {
            this.print0(this.ucase ? "DROP TABLE " : "drop table ");
        }
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        if (x.isRestrict()) {
            this.print0(this.ucase ? " RESTRICT" : " restrict");
        }
        if (x.isPurge()) {
            this.print0(this.ucase ? " PURGE" : " purge");
        }
        return false;
    }

    protected void printCascade() {
        this.print0(this.ucase ? " CASCADE" : " cascade");
    }

    @Override
    public boolean visit(SQLDropViewStatement x) {
        this.print0(this.ucase ? "DROP VIEW " : "drop view ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isCascade()) {
            this.printCascade();
        }
        return false;
    }

    public boolean visit(SQLTableElement x) {
        if (x instanceof SQLColumnDefinition) {
            return this.visit((SQLColumnDefinition)x);
        }
        throw new RuntimeException("TODO");
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        x.getName().accept(this);
        if (x.getDataType() != null) {
            this.print(' ');
            x.getDataType().accept(this);
        }
        if (x.getDefaultExpr() != null) {
            this.visitColumnDefault(x);
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            boolean newLine;
            boolean bl = newLine = item instanceof SQLForeignKeyConstraint || item instanceof SQLPrimaryKey || item instanceof SQLColumnCheck || item instanceof SQLColumnCheck || item.getName() != null;
            if (newLine) {
                this.incrementIndent();
                this.println();
            } else {
                this.print(' ');
            }
            item.accept(this);
            if (!newLine) continue;
            this.decrementIndent();
        }
        if (x.getEnable() != null && x.getEnable().booleanValue()) {
            this.print0(this.ucase ? " ENABLE" : " enable");
        }
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition.Identity x) {
        this.print0(this.ucase ? "IDENTITY" : "identity");
        if (x.getSeed() != null) {
            this.print0(" (");
            this.print(x.getSeed());
            this.print0(", ");
            this.print(x.getIncrement());
            this.print(')');
        }
        return false;
    }

    protected void visitColumnDefault(SQLColumnDefinition x) {
        this.print0(this.ucase ? " DEFAULT " : " default ");
        x.getDefaultExpr().accept(this);
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        SQLTableSource from = x.getFrom();
        if (from == null) {
            this.print0(this.ucase ? "DELETE FROM " : "delete from ");
            this.printTableSourceExpr(x.getTableName());
        } else {
            this.print0(this.ucase ? "DELETE " : "delete ");
            this.printTableSourceExpr(x.getTableName());
            this.print0(this.ucase ? " FROM " : " from ");
            from.accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            this.incrementIndent();
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public boolean visit(SQLCurrentOfCursorExpr x) {
        this.print0(this.ucase ? "CURRENT OF " : "current of ");
        x.getCursorName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        if (x.isUpsert()) {
            this.print0(this.ucase ? "UPSERT INTO " : "upsert into ");
        } else {
            this.print0(this.ucase ? "INSERT INTO " : "insert into ");
        }
        x.getTableSource().accept(this);
        this.printInsertColumns(x.getColumns());
        if (!x.getValuesList().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printAndAccept(x.getValuesList(), ", ");
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().setParent(x);
            x.getQuery().accept(this);
        }
        return false;
    }

    protected void printInsertColumns(List<SQLExpr> columns) {
        int size = columns.size();
        if (size > 0) {
            if (size > 5) {
                this.incrementIndent();
                this.println();
            } else {
                this.print(' ');
            }
            this.print('(');
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print0(", ");
                }
                SQLExpr column = columns.get(i);
                column.accept(this);
                String dataType = (String)column.getAttribute("dataType");
                if (dataType == null) continue;
                this.print(' ');
                this.print(dataType);
            }
            this.print(')');
            if (size > 5) {
                this.decrementIndent();
            }
        }
    }

    @Override
    public boolean visit(SQLUpdateSetItem x) {
        x.getColumn().accept(this);
        this.print0(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        this.print0(this.ucase ? "UPDATE " : "update ");
        x.getTableSource().accept(this);
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.incrementIndent();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    protected void printTableElements(List<SQLTableElement> tableElementList) {
        int size = tableElementList.size();
        if (size > 0) {
            this.print0(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(",");
                    this.println();
                }
                tableElementList.get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        this.printCreateTable(x);
        return false;
    }

    protected void printCreateTable(SQLCreateTableStatement x) {
        this.print0(this.ucase ? "CREATE TABLE " : "create table ");
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
            this.print0(this.ucase ? "GLOBAL TEMPORARY " : "global temporary ");
        } else if (SQLCreateTableStatement.Type.LOCAL_TEMPORARY.equals((Object)x.getType())) {
            this.print0(this.ucase ? "LOCAL TEMPORARY " : "local temporary ");
        }
        this.printTableSourceExpr(x.getName());
        this.printTableElements(x.getTableElementList());
        if (x.getInherits() != null) {
            this.print0(this.ucase ? " INHERITS (" : " inherits (");
            x.getInherits().accept(this);
            this.print(')');
        }
    }

    public boolean visit(SQLUniqueConstraint x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "UNIQUE (" : "unique (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLNotNullConstraint x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "NOT NULL" : "not null");
        List hints = x.hints;
        if (hints != null) {
            this.print(' ');
            for (SQLCommentHint hint : hints) {
                hint.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLNullConstraint x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "NULL" : "null");
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        boolean needParen;
        SQLUnionOperator operator = x.getOperator();
        boolean bracket = x.isBracket();
        if (bracket) {
            this.print('(');
        }
        x.getLeft().accept(this);
        this.println();
        this.print0(this.ucase ? operator.name : operator.name_lcase);
        this.println();
        SQLSelectQuery right = x.getRight();
        boolean bl = needParen = x.getOrderBy() != null && !right.isBracket();
        if (needParen) {
            this.print('(');
            right.accept(this);
            this.print(')');
        } else {
            right.accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (bracket) {
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLUnaryExpr x) {
        this.print0(x.getOperator().name);
        SQLExpr expr = x.getExpr();
        switch (x.getOperator()) {
            case BINARY: 
            case Prior: 
            case ConnectByRoot: {
                this.print(' ');
                expr.accept(this);
                return false;
            }
        }
        if (expr instanceof SQLBinaryOpExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else if (expr instanceof SQLUnaryExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else {
            expr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLHexExpr x) {
        if (this.parameterized && ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            this.print('?');
            this.incrementReplaceCunt();
            if (this instanceof ExportParameterVisitor || this.parameters != null) {
                ExportParameterVisitorUtils.exportParameter(this.parameters, x);
            }
            return false;
        }
        this.print0("0x");
        this.print0(x.getHex());
        String charset = (String)x.getAttribute("USING");
        if (charset != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(charset);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        if (!"oracle".equals(this.dbType)) {
            this.print0(this.ucase ? "SET " : "set ");
        }
        this.printAndAccept(x.getItems(), ", ");
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAssignItem x) {
        x.getTarget().accept(this);
        this.print0(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCallStatement x) {
        if (x.isBrace()) {
            this.print('{');
        }
        if (x.getOutParameter() != null) {
            x.getOutParameter().accept(this);
            this.print0(" = ");
        }
        this.print0(this.ucase ? "CALL " : "call ");
        x.getProcedureName().accept(this);
        this.print('(');
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        if (x.isBrace()) {
            this.print('}');
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        x.getLeft().accept(this);
        this.incrementIndent();
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(',');
        } else {
            this.println();
            if (x.isNatural()) {
                this.print0(this.ucase ? "NATURAL " : "natural ");
            }
            this.printJoinType(x.getJoinType());
        }
        this.print(' ');
        SQLTableSource right = x.getRight();
        right.accept(this);
        SQLExpr condition = x.getCondition();
        if (condition != null) {
            SQLBinaryOperator op;
            boolean newLine = false;
            if (right instanceof SQLSubqueryTableSource) {
                newLine = true;
            } else if (condition instanceof SQLBinaryOpExpr && ((op = ((SQLBinaryOpExpr)condition).getOperator()) == SQLBinaryOperator.BooleanAnd || op == SQLBinaryOperator.BooleanOr)) {
                newLine = true;
            }
            if (newLine) {
                this.println();
            } else {
                this.print(' ');
            }
            this.incrementIndent();
            this.print0(this.ucase ? "ON " : "on ");
            condition.accept(this);
            this.decrementIndent();
        }
        if (x.getUsing().size() > 0) {
            this.print0(this.ucase ? " USING (" : " using (");
            this.printAndAccept(x.getUsing(), ", ");
            this.print(')');
        }
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        this.decrementIndent();
        return false;
    }

    protected void printJoinType(SQLJoinTableSource.JoinType joinType) {
        this.print0(this.ucase ? joinType.name : joinType.name_lcase);
    }

    @Override
    public boolean visit(SQLInsertStatement.ValuesClause x) {
        this.print('(');
        this.incrementIndent();
        int size = x.getValues().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                if (i % 5 == 0) {
                    this.println();
                }
                this.print0(", ");
            }
            SQLExpr expr = x.getValues().get(i);
            expr.setParent(x);
            expr.accept(this);
        }
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLSomeExpr x) {
        this.print0(this.ucase ? "SOME (" : "some (");
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAnyExpr x) {
        this.print0(this.ucase ? "ANY (" : "any (");
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAllExpr x) {
        this.print0(this.ucase ? "ALL (" : "all (");
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        x.getExpr().accept(this);
        if (x.isNot()) {
            this.print0(this.ucase ? " NOT IN (" : " not in (");
        } else {
            this.print0(this.ucase ? " IN (" : " in (");
        }
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLListExpr x) {
        this.print('(');
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.print('(');
        this.incrementIndent();
        this.println();
        this.visit(x.getSelect());
        this.decrementIndent();
        this.println();
        this.print(')');
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLTruncateStatement x) {
        this.print0(this.ucase ? "TRUNCATE TABLE " : "truncate table ");
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isDropStorage()) {
            this.print0(this.ucase ? " DROP STORAGE" : " drop storage");
        }
        if (x.isReuseStorage()) {
            this.print0(this.ucase ? " REUSE STORAGE" : " reuse storage");
        }
        if (x.isIgnoreDeleteTriggers()) {
            this.print0(this.ucase ? " IGNORE DELETE TRIGGERS" : " ignore delete triggers");
        }
        if (x.isRestrictWhenDeleteTriggers()) {
            this.print0(this.ucase ? " RESTRICT WHEN DELETE TRIGGERS" : " restrict when delete triggers");
        }
        if (x.isContinueIdentity()) {
            this.print0(this.ucase ? " CONTINUE IDENTITY" : " continue identity");
        }
        if (x.isImmediate()) {
            this.print0(this.ucase ? " IMMEDIATE" : " immediate");
        }
        return false;
    }

    @Override
    public boolean visit(SQLDefaultExpr x) {
        this.print0(this.ucase ? "DEFAULT" : "default");
        return false;
    }

    @Override
    public void endVisit(SQLCommentStatement x) {
    }

    @Override
    public boolean visit(SQLCommentStatement x) {
        this.print0(this.ucase ? "COMMENT ON " : "comment on ");
        if (x.getType() != null) {
            this.print0(x.getType().name());
            this.print(' ');
        }
        x.getOn().accept(this);
        this.print0(this.ucase ? " IS " : " is ");
        x.getComment().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLUseStatement x) {
        this.print0(this.ucase ? "USE " : "use ");
        x.getDatabase().accept(this);
        return false;
    }

    protected boolean isOdps() {
        return "odps".equals(this.dbType);
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        boolean odps = this.isOdps();
        if (odps) {
            this.print0(this.ucase ? "ADD COLUMNS (" : "add columns (");
        } else {
            this.print0(this.ucase ? "ADD (" : "add (");
        }
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropColumnItem x) {
        this.print0(this.ucase ? "DROP COLUMN " : "drop column ");
        this.printAndAccept(x.getColumns(), ", ");
        if (x.isCascade()) {
            this.print0(this.ucase ? " CASCADE" : " cascade");
        }
        return false;
    }

    @Override
    public void endVisit(SQLAlterTableAddColumn x) {
    }

    @Override
    public boolean visit(SQLDropIndexStatement x) {
        this.print0(this.ucase ? "DROP INDEX " : "drop index ");
        x.getIndexName().accept(this);
        SQLExprTableSource table = x.getTableName();
        if (table != null) {
            this.print0(this.ucase ? " ON " : " on ");
            table.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSavePointStatement x) {
        this.print0(this.ucase ? "SAVEPOINT" : "savepoint");
        if (x.getName() != null) {
            this.print(' ');
            x.getName().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLReleaseSavePointStatement x) {
        this.print0(this.ucase ? "RELEASE SAVEPOINT " : "release savepoint ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLRollbackStatement x) {
        this.print0(this.ucase ? "ROLLBACK" : "rollback");
        if (x.getTo() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCommentHint x) {
        this.print0("/*");
        this.print0(x.getText());
        this.print0("*/");
        return false;
    }

    @Override
    public boolean visit(SQLCreateDatabaseStatement x) {
        this.print0(this.ucase ? "CREATE DATABASE " : "create database ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getName().accept(this);
        if (x.getCharacterSet() != null) {
            this.print0(this.ucase ? " CHARACTER SET " : " character set ");
            this.print0(x.getCharacterSet());
        }
        if (x.getCollate() != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(x.getCollate());
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateViewStatement x) {
        String sqlSecurity;
        SQLName definer;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLACE " : "or replace ");
        }
        this.incrementIndent();
        String algorithm = x.getAlgorithm();
        if (algorithm != null && algorithm.length() > 0) {
            this.print0(this.ucase ? "ALGORITHM = " : "algorithm = ");
            this.print0(algorithm);
            this.println();
        }
        if ((definer = x.getDefiner()) != null) {
            this.print0(this.ucase ? "DEFINER = " : "definer = ");
            definer.accept(this);
            this.println();
        }
        if ((sqlSecurity = x.getSqlSecurity()) != null && sqlSecurity.length() > 0) {
            this.print0(this.ucase ? "SQL SECURITY = " : "sql security = ");
            this.print0(sqlSecurity);
            this.println();
        }
        this.decrementIndent();
        this.print0(this.ucase ? "VIEW " : "view ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        x.getTableSource().accept(this);
        if (x.getColumns().size() > 0) {
            this.print0(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < x.getColumns().size(); ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                x.getColumns().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        if (x.getComment() != null) {
            this.println();
            this.print0(this.ucase ? "COMMENT " : "comment ");
            x.getComment().accept(this);
        }
        this.println();
        this.print0(this.ucase ? "AS" : "as");
        this.println();
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateViewStatement.Column x) {
        x.getExpr().accept(this);
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropIndex x) {
        this.print0(this.ucase ? "DROP INDEX " : "drop index ");
        x.getIndexName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLOver x) {
        this.print0(this.ucase ? "OVER (" : "over (");
        if (x.getPartitionBy().size() > 0) {
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            this.printAndAccept(x.getPartitionBy(), ", ");
            this.print(' ');
        }
        if (x.getOrderBy() != null) {
            x.getOrderBy().accept(this);
        }
        if (x.getOf() != null) {
            this.print0(this.ucase ? " OF " : " of ");
            x.getOf().accept(this);
        }
        if (x.getWindowing() != null) {
            if (SQLOver.WindowingType.ROWS.equals((Object)x.getWindowingType())) {
                this.print0(this.ucase ? " ROWS " : " rows ");
            } else if (SQLOver.WindowingType.RANGE.equals((Object)x.getWindowingType())) {
                this.print0(this.ucase ? " RANGE " : " range ");
            }
            this.printWindowingExpr(x.getWindowing());
            if (x.isWindowingPreceding()) {
                this.print0(this.ucase ? " PRECEDING" : " preceding");
            } else if (x.isWindowingFollowing()) {
                this.print0(this.ucase ? " FOLLOWING" : " following");
            }
        }
        if (x.getWindowingBetweenBegin() != null) {
            if (SQLOver.WindowingType.ROWS.equals((Object)x.getWindowingType())) {
                this.print0(this.ucase ? " ROWS BETWEEN " : " rows between ");
            } else if (SQLOver.WindowingType.RANGE.equals((Object)x.getWindowingType())) {
                this.print0(this.ucase ? " RANGE BETWEEN " : " range between ");
            }
            this.printWindowingExpr(x.getWindowingBetweenBegin());
            if (x.isWindowingBetweenBeginPreceding()) {
                this.print0(this.ucase ? " PRECEDING" : " preceding");
            } else if (x.isWindowingBetweenBeginFollowing()) {
                this.print0(this.ucase ? " FOLLOWING" : " following");
            }
            this.print0(this.ucase ? " AND " : " and ");
            this.printWindowingExpr(x.getWindowingBetweenEnd());
            if (x.isWindowingBetweenEndPreceding()) {
                this.print0(this.ucase ? " PRECEDING" : " preceding");
            } else if (x.isWindowingBetweenEndFollowing()) {
                this.print0(this.ucase ? " FOLLOWING" : " following");
            }
        }
        this.print(')');
        return false;
    }

    void printWindowingExpr(SQLExpr expr) {
        if (expr instanceof SQLIdentifierExpr) {
            String ident = ((SQLIdentifierExpr)expr).getName();
            this.print0(this.ucase ? ident : ident.toLowerCase());
        } else {
            expr.accept(this);
        }
    }

    @Override
    public boolean visit(SQLKeep x) {
        if (x.getDenseRank() == SQLKeep.DenseRank.FIRST) {
            this.print0(this.ucase ? "KEEP (DENSE_RANK FIRST " : "keep (dense_rank first ");
        } else {
            this.print0(this.ucase ? "KEEP (DENSE_RANK LAST " : "keep (dense_rank last ");
        }
        x.getOrderBy().accept(this);
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLColumnPrimaryKey x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "PRIMARY KEY" : "primary key");
        return false;
    }

    @Override
    public boolean visit(SQLColumnUniqueKey x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "UNIQUE" : "unique");
        return false;
    }

    @Override
    public boolean visit(SQLColumnCheck x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "CHECK (" : "check (");
        x.getExpr().accept(this);
        this.print(')');
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print0(this.ucase ? " ENABLE" : " enable");
            } else {
                this.print0(this.ucase ? " DISABLE" : " disable");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        this.print0(this.ucase ? "WITH " : "with ");
        if (x.getRecursive() == Boolean.TRUE) {
            this.print0(this.ucase ? "RECURSIVE " : "recursive ");
        }
        this.incrementIndent();
        this.printlnAndAccept(x.getEntries(), ", ");
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print0(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        this.print(' ');
        this.print0(this.ucase ? "AS " : "as ");
        this.print('(');
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAlterColumn x) {
        boolean odps = this.isOdps();
        if (odps) {
            this.print0(this.ucase ? "CHANGE COLUMN " : "change column ");
        } else {
            this.print0(this.ucase ? "ALTER COLUMN " : "alter column ");
        }
        x.getColumn().accept(this);
        if (x.isSetNotNull()) {
            this.print0(this.ucase ? " SET NOT NULL" : " set not null");
        }
        if (x.isDropNotNull()) {
            this.print0(this.ucase ? " DROP NOT NULL" : " drop not null");
        }
        if (x.getSetDefault() != null) {
            this.print0(this.ucase ? " SET DEFAULT " : " set default ");
            x.getSetDefault().accept(this);
        }
        if (x.isDropDefault()) {
            this.print0(this.ucase ? " DROP DEFAULT" : " drop default");
        }
        return false;
    }

    @Override
    public boolean visit(SQLCheck x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "CHECK (" : "check (");
        this.incrementIndent();
        x.getExpr().accept(this);
        this.decrementIndent();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropForeignKey x) {
        this.print0(this.ucase ? "DROP FOREIGN KEY " : "drop foreign key ");
        x.getIndexName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPrimaryKey x) {
        this.print0(this.ucase ? "DROP PRIMARY KEY" : "drop primary key");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropKey x) {
        this.print0(this.ucase ? "DROP KEY " : "drop key ");
        x.getKeyName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableKeys x) {
        this.print0(this.ucase ? "ENABLE KEYS" : "enable keys");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableKeys x) {
        this.print0(this.ucase ? "DISABLE KEYS" : "disable keys");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableConstraint x) {
        this.print0(this.ucase ? "DISABLE CONSTRAINT " : "disable constraint ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableConstraint x) {
        this.print0(this.ucase ? "ENABLE CONSTRAINT " : "enable constraint ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropConstraint x) {
        this.print0(this.ucase ? "DROP CONSTRAINT " : "drop constraint ");
        x.getConstraintName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
        this.printTableSourceExpr(x.getName());
        this.incrementIndent();
        for (int i = 0; i < x.getItems().size(); ++i) {
            SQLAlterTableItem item = x.getItems().get(i);
            if (i != 0) {
                this.print(',');
            }
            this.println();
            item.accept(this);
        }
        this.decrementIndent();
        if (x.isMergeSmallFiles()) {
            this.print0(this.ucase ? " MERGE SMALLFILES" : " merge smallfiles");
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprHint x) {
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.getType() != null) {
            this.print0(x.getType());
            this.print(' ');
        }
        this.print0(this.ucase ? "INDEX " : "index ");
        x.getName().accept(this);
        this.print0(this.ucase ? " ON " : " on ");
        x.getTable().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        if (x.getUsing() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getUsing());
        }
        return false;
    }

    @Override
    public boolean visit(SQLUnique x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "UNIQUE (" : "unique (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLPrimaryKeyImpl x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "PRIMARY KEY (" : "primary key (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRenameColumn x) {
        this.print0(this.ucase ? "RENAME COLUMN " : "rename column ");
        x.getColumn().accept(this);
        this.print0(this.ucase ? " TO " : " to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLColumnReference x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "REFERENCES " : "references ");
        x.getTable().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLForeignKeyImpl x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "FOREIGN KEY (" : "foreign key (");
        this.printAndAccept(x.getReferencingColumns(), ", ");
        this.print(')');
        this.incrementIndent();
        this.println();
        this.print0(this.ucase ? "REFERENCES " : "references ");
        x.getReferencedTableName().accept(this);
        if (x.getReferencedColumns().size() > 0) {
            this.print0(" (");
            this.printAndAccept(x.getReferencedColumns(), ", ");
            this.print(')');
        }
        if (x.isOnDeleteCascade()) {
            this.println();
            this.print0(this.ucase ? "ON DELETE CASCADE" : "on delete cascade");
        } else if (x.isOnDeleteSetNull()) {
            this.print0(this.ucase ? "ON DELETE SET NULL" : "on delete set null");
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLDropSequenceStatement x) {
        this.print0(this.ucase ? "DROP SEQUENCE " : "drop sequence ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(SQLDropSequenceStatement x) {
    }

    @Override
    public boolean visit(SQLDropTriggerStatement x) {
        this.print0(this.ucase ? "DROP TRIGGER " : "drop trigger ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(SQLDropUserStatement x) {
    }

    @Override
    public boolean visit(SQLDropUserStatement x) {
        this.print0(this.ucase ? "DROP USER " : "drop user ");
        this.printAndAccept(x.getUsers(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLExplainStatement x) {
        this.print0(this.ucase ? "EXPLAIN" : "explain");
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        if (x.getType() != null) {
            this.print(' ');
            this.print0(x.getType());
        }
        this.println();
        x.getStatement().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLGrantStatement x) {
        this.print0(this.ucase ? "GRANT " : "grant ");
        this.printAndAccept(x.getPrivileges(), ", ");
        this.printGrantOn(x);
        if (x.getTo() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            x.getTo().accept(this);
        }
        boolean with = false;
        if (x.getMaxQueriesPerHour() != null) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " MAX_QUERIES_PER_HOUR " : " max_queries_per_hour ");
            x.getMaxQueriesPerHour().accept(this);
        }
        if (x.getMaxUpdatesPerHour() != null) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " MAX_UPDATES_PER_HOUR " : " max_updates_per_hour ");
            x.getMaxUpdatesPerHour().accept(this);
        }
        if (x.getMaxConnectionsPerHour() != null) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " MAX_CONNECTIONS_PER_HOUR " : " max_connections_per_hour ");
            x.getMaxConnectionsPerHour().accept(this);
        }
        if (x.getMaxUserConnections() != null) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " MAX_USER_CONNECTIONS " : " max_user_connections ");
            x.getMaxUserConnections().accept(this);
        }
        if (x.isAdminOption()) {
            if (!with) {
                this.print0(this.ucase ? " WITH" : " with");
                with = true;
            }
            this.print0(this.ucase ? " ADMIN OPTION" : " admin option");
        }
        if (x.getIdentifiedBy() != null) {
            this.print0(this.ucase ? " IDENTIFIED BY " : " identified by ");
            x.getIdentifiedBy().accept(this);
        }
        return false;
    }

    protected void printGrantOn(SQLGrantStatement x) {
        if (x.getOn() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            SQLObjectType objectType = x.getObjectType();
            if (objectType != null) {
                this.print0(this.ucase ? objectType.name : objectType.name_lcase);
                this.print(' ');
            }
            x.getOn().accept(this);
        }
    }

    @Override
    public boolean visit(SQLRevokeStatement x) {
        this.print0(this.ucase ? "ROVOKE " : "rovoke ");
        this.printAndAccept(x.getPrivileges(), ", ");
        if (x.getOn() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            if (x.getObjectType() != null) {
                this.print0(x.getObjectType().name());
                this.print(' ');
            }
            x.getOn().accept(this);
        }
        if (x.getFrom() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getFrom().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropDatabaseStatement x) {
        this.print0(this.ucase ? "DROP DATABASE " : "drop databasE ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropFunctionStatement x) {
        this.print0(this.ucase ? "DROP FUNCTION " : "drop function ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropTableSpaceStatement x) {
        this.print0(this.ucase ? "DROP TABLESPACE " : "drop tablespace ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropProcedureStatement x) {
        this.print0(this.ucase ? "DROP PROCEDURE " : "drop procedure ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddIndex x) {
        this.print0(this.ucase ? "ADD " : "add ");
        String type = x.getType();
        boolean mysql = "mysql".equals(this.dbType);
        if (type != null && !mysql) {
            this.print0(type);
            this.print(' ');
        }
        if (x.isUnique()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        if (x.isKey()) {
            this.print0(this.ucase ? "KEY " : "key ");
        } else {
            this.print0(this.ucase ? "INDEX " : "index ");
        }
        if (x.getName() != null) {
            x.getName().accept(this);
            this.print(' ');
        }
        if (type != null && mysql) {
            this.print0(this.ucase ? "USING " : "using ");
            this.print0(type);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        if (x.getUsing() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getUsing());
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddConstraint x) {
        if (x.isWithNoCheck()) {
            this.print0(this.ucase ? "WITH NOCHECK " : "with nocheck ");
        }
        this.print0(this.ucase ? "ADD " : "add ");
        x.getConstraint().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateTriggerStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLEACE " : "or repleace ");
        }
        this.print0(this.ucase ? "TRIGGER " : "trigger ");
        x.getName().accept(this);
        this.incrementIndent();
        this.println();
        if (SQLCreateTriggerStatement.TriggerType.INSTEAD_OF.equals((Object)x.getTriggerType())) {
            this.print0(this.ucase ? "INSTEAD OF" : "instead of");
        } else {
            String triggerTypeName = x.getTriggerType().name();
            this.print0(this.ucase ? triggerTypeName : triggerTypeName.toLowerCase());
        }
        for (SQLCreateTriggerStatement.TriggerEvent event : x.getTriggerEvents()) {
            this.print(' ');
            this.print0(event.name());
        }
        this.println();
        this.print0(this.ucase ? "ON " : "on ");
        x.getOn().accept(this);
        if (x.isForEachRow()) {
            this.println();
            this.print0(this.ucase ? "FOR EACH ROW" : "for each row");
        }
        this.decrementIndent();
        this.println();
        x.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLBooleanExpr x) {
        this.print0(x.getValue() ? "true" : "false");
        return false;
    }

    @Override
    public void endVisit(SQLBooleanExpr x) {
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        this.print('(');
        this.incrementIndent();
        this.println();
        x.getUnion().accept(this);
        this.decrementIndent();
        this.println();
        this.print(')');
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLTimestampExpr x) {
        this.print0(this.ucase ? "TIMESTAMP " : "timestamp ");
        if (x.isWithTimeZone()) {
            this.print0(this.ucase ? " WITH TIME ZONE " : " with time zone ");
        }
        this.print('\'');
        this.print0(x.getLiteral());
        this.print('\'');
        if (x.getTimeZone() != null) {
            this.print0(this.ucase ? " AT TIME ZONE '" : " at time zone '");
            this.print0(x.getTimeZone());
            this.print('\'');
        }
        return false;
    }

    @Override
    public boolean visit(SQLBinaryExpr x) {
        this.print0("b'");
        this.print0(x.getValue());
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRename x) {
        this.print0(this.ucase ? "RENAME TO " : "rename to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLShowTablesStatement x) {
        this.print0(this.ucase ? "SHOW TABLES" : "show tables");
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        return false;
    }

    protected void printlnComment(List<String> comments) {
        if (comments != null) {
            for (int i = 0; i < comments.size(); ++i) {
                String comment = comments.get(i);
                if (i != 0 && comment.startsWith("--")) {
                    this.println();
                }
                this.print0(comment);
            }
        }
    }

    protected void printlnComments(List<String> comments) {
        if (comments != null) {
            for (int i = 0; i < comments.size(); ++i) {
                String comment = comments.get(i);
                this.print0(comment);
                this.println();
            }
        }
    }

    @Override
    public boolean visit(SQLAlterViewRenameStatement x) {
        this.print0(this.ucase ? "ALTER VIEW " : "alter view ");
        x.getName().accept(this);
        this.print0(this.ucase ? " RENAME TO " : " rename to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddPartition x) {
        this.print0(this.ucase ? "ADD " : "add ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        if (x.getPartitionCount() != null) {
            this.print0(this.ucase ? "PARTITION PARTITIONS " : "partition partitions ");
            x.getPartitionCount().accept(this);
        }
        if (x.getPartitions().size() > 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartitions(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableReOrganizePartition x) {
        this.print0(this.ucase ? "REORGANIZE " : "reorganize ");
        this.printAndAccept(x.getNames(), ", ");
        this.print0(this.ucase ? " INTO (" : " into (");
        this.printAndAccept(x.getPartitions(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPartition x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        if (x.isIfExists()) {
            this.print0(this.ucase ? "IF EXISTS " : "if exists ");
        }
        this.print0(this.ucase ? "PARTITION " : "partition ");
        if (x.getPartitions().size() == 1 && x.getPartitions().get(0) instanceof SQLName) {
            x.getPartitions().get(0).accept(this);
        } else {
            this.print('(');
            this.printAndAccept(x.getPartitions(), ", ");
            this.print(')');
        }
        if (x.isPurge()) {
            this.print0(this.ucase ? " PURGE" : " purge");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRenamePartition x) {
        this.print0(this.ucase ? "PARTITION (" : "partition (");
        this.printAndAccept(x.getPartition(), ", ");
        this.print0(this.ucase ? ") RENAME TO PARTITION(" : ") rename to partition(");
        this.printAndAccept(x.getTo(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableSetComment x) {
        this.print0(this.ucase ? "SET COMMENT " : "set comment ");
        x.getComment().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableSetLifecycle x) {
        this.print0(this.ucase ? "SET LIFECYCLE " : "set lifecycle ");
        x.getLifecycle().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableLifecycle x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "ENABLE LIFECYCLE" : "enable lifecycle");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableLifecycle x) {
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? "PARTITION (" : "partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print0(") ");
        }
        this.print0(this.ucase ? "DISABLE LIFECYCLE" : "disable lifecycle");
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableTouch x) {
        this.print0(this.ucase ? "TOUCH" : "touch");
        if (x.getPartition().size() != 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLArrayExpr x) {
        x.getExpr().accept(this);
        this.print('[');
        this.printAndAccept(x.getValues(), ", ");
        this.print(']');
        return false;
    }

    @Override
    public boolean visit(SQLOpenStatement x) {
        this.print0(this.ucase ? "OPEN " : "open ");
        this.print0(x.getCursorName());
        SQLExpr forExpr = x.getFor();
        if (forExpr != null) {
            this.print0(this.ucase ? " FOR " : "for ");
            forExpr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLFetchStatement x) {
        this.print0(this.ucase ? "FETCH " : "fetch ");
        x.getCursorName().accept(this);
        if (x.isBulkCollect()) {
            this.print0(this.ucase ? " BULK COLLECT INTO " : " bulk collect into ");
        } else {
            this.print0(this.ucase ? " INTO " : " into ");
        }
        this.printAndAccept(x.getInto(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLCloseStatement x) {
        this.print0(this.ucase ? "CLOSE " : "close ");
        this.print0(x.getCursorName());
        return false;
    }

    @Override
    public boolean visit(SQLGroupingSetExpr x) {
        this.print0(this.ucase ? "GROUPING SETS" : "grouping sets");
        this.print0(" (");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement x) {
        this.print0(this.ucase ? "IF " : "if ");
        x.getCondition().accept(this);
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.decrementIndent();
        for (SQLIfStatement.ElseIf elseIf : x.getElseIfList()) {
            this.println();
            elseIf.accept(this);
        }
        if (x.getElseItem() != null) {
            this.println();
            x.getElseItem().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement.Else x) {
        this.print0(this.ucase ? "ELSE" : "else");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement.ElseIf x) {
        this.print0(this.ucase ? "ELSE IF" : "else if");
        x.getCondition().accept(this);
        this.print0(this.ucase ? " THEN" : " then");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLLoopStatement x) {
        this.print0(this.ucase ? "LOOP" : "loop");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.decrementIndent();
        this.println();
        this.print0(this.ucase ? "END LOOP" : "end loop");
        if (x.getLabelName() != null) {
            this.print(' ');
            this.print0(x.getLabelName());
        }
        return false;
    }

    @Override
    public boolean visit(SQLParameter x) {
        if (x.getDataType().getName().equalsIgnoreCase("CURSOR")) {
            this.print0(this.ucase ? "CURSOR " : "cursor ");
            x.getName().accept(this);
            this.print0(this.ucase ? " IS" : " is");
            this.incrementIndent();
            this.println();
            SQLSelect select = ((SQLQueryExpr)x.getDefaultValue()).getSubQuery();
            select.accept(this);
            this.decrementIndent();
        } else {
            SQLDataType dataType = x.getDataType();
            if ("oracle".equals(this.dbType)) {
                boolean printType;
                String dataTypeName = dataType.getName();
                boolean bl = printType = dataTypeName.startsWith("TABLE OF") && x.getDefaultValue() == null || dataTypeName.equalsIgnoreCase("REF CURSOR") || dataTypeName.startsWith("VARRAY(");
                if (printType) {
                    this.print0(this.ucase ? "TYPE " : "type ");
                }
                x.getName().accept(this);
                if (x.getParamType() == SQLParameter.ParameterType.IN) {
                    this.print0(this.ucase ? " IN " : " in ");
                } else if (x.getParamType() == SQLParameter.ParameterType.OUT) {
                    this.print0(this.ucase ? " OUT " : " out ");
                } else if (x.getParamType() == SQLParameter.ParameterType.INOUT) {
                    this.print0(this.ucase ? " IN OUT " : " in out ");
                } else {
                    this.print(' ');
                }
                if (x.isNoCopy()) {
                    this.print0(this.ucase ? "NOCOPY " : "nocopy ");
                }
                if (x.isConstant()) {
                    this.print0(this.ucase ? "CONSTANT " : "constant ");
                }
                if (printType) {
                    this.print0(this.ucase ? "IS " : "is ");
                }
            } else {
                if (x.getParamType() == SQLParameter.ParameterType.IN) {
                    boolean skip;
                    boolean bl = skip = "mysql".equals(this.dbType) && x.getParent() instanceof SQLCreateFunctionStatement;
                    if (!skip) {
                        this.print0(this.ucase ? "IN " : "in ");
                    }
                } else if (x.getParamType() == SQLParameter.ParameterType.OUT) {
                    this.print0(this.ucase ? "OUT " : "out ");
                } else if (x.getParamType() == SQLParameter.ParameterType.INOUT) {
                    this.print0(this.ucase ? "INOUT " : "inout ");
                }
                x.getName().accept(this);
                this.print(' ');
            }
            dataType.accept(this);
            this.printParamDefaultValue(x);
        }
        return false;
    }

    protected void printParamDefaultValue(SQLParameter x) {
        if (x.getDefaultValue() != null) {
            this.print0(" := ");
            x.getDefaultValue().accept(this);
        }
    }

    @Override
    public boolean visit(SQLDeclareItem x) {
        x.getName().accept(this);
        if (x.getType() == SQLDeclareItem.Type.TABLE) {
            this.print0(this.ucase ? " TABLE" : " table");
            int size = x.getTableElementList().size();
            if (size > 0) {
                this.print0(" (");
                this.incrementIndent();
                this.println();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print(',');
                        this.println();
                    }
                    x.getTableElementList().get(i).accept(this);
                }
                this.decrementIndent();
                this.println();
                this.print(')');
            }
        } else if (x.getType() == SQLDeclareItem.Type.CURSOR) {
            this.print0(this.ucase ? " CURSOR" : " cursor");
        } else {
            if (x.getDataType() != null) {
                this.print(' ');
                x.getDataType().accept(this);
            }
            if (x.getValue() != null) {
                if ("mysql".equals(this.getDbType())) {
                    this.print0(this.ucase ? " DEFAULT " : " default ");
                } else {
                    this.print0(" = ");
                }
                x.getValue().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionValue x) {
        SQLIdentifierExpr ident;
        if (x.getOperator() == SQLPartitionValue.Operator.LessThan && !"oracle".equals(this.getDbType()) && x.getItems().size() == 1 && x.getItems().get(0) instanceof SQLIdentifierExpr && "MAXVALUE".equalsIgnoreCase((ident = (SQLIdentifierExpr)x.getItems().get(0)).getName())) {
            this.print0(this.ucase ? "VALUES LESS THAN MAXVALUE" : "values less than maxvalue");
            return false;
        }
        if (x.getOperator() == SQLPartitionValue.Operator.LessThan) {
            this.print0(this.ucase ? "VALUES LESS THAN (" : "values less than (");
        } else if (x.getOperator() == SQLPartitionValue.Operator.In) {
            this.print0(this.ucase ? "VALUES IN (" : "values in (");
        } else {
            this.print(this.ucase ? "VALUES (" : "values (");
        }
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public String getDbType() {
        return this.dbType;
    }

    @Override
    public boolean isUppCase() {
        return this.ucase;
    }

    public void setUppCase(boolean val) {
        this.ucase = val;
    }

    @Override
    public boolean visit(SQLPartition x) {
        this.print0(this.ucase ? "PARTITION " : "partition ");
        x.getName().accept(this);
        if (x.getValues() != null) {
            this.print(' ');
            x.getValues().accept(this);
        }
        if (x.getDataDirectory() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "DATA DIRECTORY " : "data directory ");
            x.getDataDirectory().accept(this);
            this.decrementIndent();
        }
        if (x.getIndexDirectory() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "INDEX DIRECTORY " : "index directory ");
            x.getIndexDirectory().accept(this);
            this.decrementIndent();
        }
        this.incrementIndent();
        this.printOracleSegmentAttributes(x);
        if (x.getEngine() != null) {
            this.println();
            this.print0(this.ucase ? "STORAGE ENGINE " : "storage engine ");
            x.getEngine().accept(this);
        }
        this.decrementIndent();
        if (x.getMaxRows() != null) {
            this.print0(this.ucase ? " MAX_ROWS " : " max_rows ");
            x.getMaxRows().accept(this);
        }
        if (x.getMinRows() != null) {
            this.print0(this.ucase ? " MIN_ROWS " : " min_rows ");
            x.getMinRows().accept(this);
        }
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        if (x.getSubPartitionsCount() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "SUBPARTITIONS " : "subpartitions ");
            x.getSubPartitionsCount().accept(this);
            this.decrementIndent();
        }
        if (x.getSubPartitions().size() > 0) {
            this.println();
            this.print('(');
            this.incrementIndent();
            for (int i = 0; i < x.getSubPartitions().size(); ++i) {
                if (i != 0) {
                    this.print(',');
                }
                this.println();
                x.getSubPartitions().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByRange x) {
        this.print0(this.ucase ? "PARTITION BY RANGE" : "partition by range");
        if (x.getExpr() != null) {
            this.print0(" (");
            x.getExpr().accept(this);
            this.print(')');
        } else {
            if ("mysql".equals(this.getDbType())) {
                this.print0(this.ucase ? " COLUMNS (" : " columns (");
            } else {
                this.print0(" (");
            }
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        if (x.getInterval() != null) {
            this.print0(this.ucase ? " INTERVAL " : " interval ");
            x.getInterval().accept(this);
        }
        this.printPartitionsCountAndSubPartitions(x);
        this.println();
        this.print('(');
        this.incrementIndent();
        int size = x.getPartitions().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(',');
            }
            this.println();
            x.getPartitions().get(i).accept(this);
        }
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByList x) {
        this.print0(this.ucase ? "PARTITION BY LIST " : "partition by list ");
        if (x.getExpr() != null) {
            this.print('(');
            x.getExpr().accept(this);
            this.print0(")");
        } else {
            this.print0(this.ucase ? "COLUMNS (" : "columns (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print0(")");
        }
        this.printPartitionsCountAndSubPartitions(x);
        this.printSQLPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByHash x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "PARTITION BY LINEAR HASH " : "partition by linear hash ");
        } else {
            this.print0(this.ucase ? "PARTITION BY HASH " : "partition by hash ");
        }
        if (x.isKey()) {
            this.print0(this.ucase ? "KEY" : "key");
        }
        this.print('(');
        x.getExpr().accept(this);
        this.print(')');
        this.printPartitionsCountAndSubPartitions(x);
        this.printSQLPartitions(x.getPartitions());
        return false;
    }

    private void printSQLPartitions(List<SQLPartition> partitions) {
        int partitionsSize = partitions.size();
        if (partitionsSize > 0) {
            this.print0(" (");
            this.incrementIndent();
            for (int i = 0; i < partitionsSize; ++i) {
                this.println();
                partitions.get(i).accept(this);
                if (i == partitionsSize - 1) continue;
                this.print0(", ");
            }
            this.decrementIndent();
            this.println();
            this.print(')');
        }
    }

    protected void printPartitionsCountAndSubPartitions(SQLPartitionBy x) {
        if (x.getPartitionsCount() != null) {
            if (Boolean.TRUE.equals(x.getAttribute("ads.partition"))) {
                this.print0(this.ucase ? " PARTITION NUM " : " partition num ");
            } else {
                this.print0(this.ucase ? " PARTITIONS " : " partitions ");
            }
            x.getPartitionsCount().accept(this);
        }
        if (x.getSubPartitionBy() != null) {
            this.println();
            x.getSubPartitionBy().accept(this);
        }
        if (x.getStoreIn().size() > 0) {
            this.println();
            this.print0(this.ucase ? "STORE IN (" : "store in (");
            this.printAndAccept(x.getStoreIn(), ", ");
            this.print(')');
        }
    }

    @Override
    public boolean visit(SQLSubPartitionByHash x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "SUBPARTITION BY LINEAR HASH " : "subpartition by linear hash ");
        } else {
            this.print0(this.ucase ? "SUBPARTITION BY HASH " : "subpartition by hash ");
        }
        if (x.isKey()) {
            this.print0(this.ucase ? "KEY" : "key");
        }
        this.print('(');
        x.getExpr().accept(this);
        this.print(')');
        if (x.getSubPartitionsCount() != null) {
            this.print0(this.ucase ? " SUBPARTITIONS " : " subpartitions ");
            x.getSubPartitionsCount().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubPartitionByList x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "SUBPARTITION BY LINEAR HASH " : "subpartition by linear hash ");
        } else {
            this.print0(this.ucase ? "SUBPARTITION BY HASH " : "subpartition by hash ");
        }
        this.print('(');
        x.getColumn().accept(this);
        this.print(')');
        if (x.getSubPartitionsCount() != null) {
            this.print0(this.ucase ? " SUBPARTITIONS " : " subpartitions ");
            x.getSubPartitionsCount().accept(this);
        }
        if (x.getSubPartitionTemplate().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "SUBPARTITION TEMPLATE (" : "subpartition template (");
            this.incrementIndent();
            this.println();
            this.printlnAndAccept(x.getSubPartitionTemplate(), ",");
            this.decrementIndent();
            this.println();
            this.print(')');
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubPartition x) {
        this.print0(this.ucase ? "SUBPARTITION " : "subpartition ");
        x.getName().accept(this);
        if (x.getValues() != null) {
            this.print(' ');
            x.getValues().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterDatabaseStatement x) {
        this.print0(this.ucase ? "ALTER DATABASE " : "alter database ");
        x.getName().accept(this);
        if (x.isUpgradeDataDirectoryName()) {
            this.print0(this.ucase ? " UPGRADE DATA DIRECTORY NAME" : " upgrade data directory name");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableConvertCharSet x) {
        this.print0(this.ucase ? "CONVERT TO CHARACTER SET " : "convert to character set ");
        x.getCharset().accept(this);
        if (x.getCollate() != null) {
            this.print0(this.ucase ? "COLLATE " : "collate ");
            x.getCollate().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableCoalescePartition x) {
        this.print0(this.ucase ? "COALESCE PARTITION " : "coalesce partition ");
        x.getCount().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableTruncatePartition x) {
        this.print0(this.ucase ? "TRUNCATE PARTITION " : "truncate partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDiscardPartition x) {
        this.print0(this.ucase ? "DISCARD PARTITION " : "discard partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableImportPartition x) {
        this.print0(this.ucase ? "IMPORT PARTITION " : "import partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAnalyzePartition x) {
        this.print0(this.ucase ? "ANALYZE PARTITION " : "analyze partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    protected void printPartitions(List<SQLName> partitions) {
        if (partitions.size() == 1 && "ALL".equalsIgnoreCase(partitions.get(0).getSimpleName())) {
            this.print0(this.ucase ? "ALL" : "all");
        } else {
            this.printAndAccept(partitions, ", ");
        }
    }

    @Override
    public boolean visit(SQLAlterTableCheckPartition x) {
        this.print0(this.ucase ? "CHECK PARTITION " : "check partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableOptimizePartition x) {
        this.print0(this.ucase ? "OPTIMIZE PARTITION " : "optimize partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRebuildPartition x) {
        this.print0(this.ucase ? "REBUILD PARTITION " : "rebuild partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRepairPartition x) {
        this.print0(this.ucase ? "REPAIR PARTITION " : "repair partition ");
        this.printPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(SQLSequenceExpr x) {
        x.getSequence().accept(this);
        this.print('.');
        this.print0(this.ucase ? x.getFunction().name : x.getFunction().name_lcase);
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement x) {
        this.print0(this.ucase ? "MERGE " : "merge ");
        if (x.getHints().size() > 0) {
            this.printAndAccept(x.getHints(), ", ");
            this.print(' ');
        }
        this.print0(this.ucase ? "INTO " : "into ");
        x.getInto().accept(this);
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        this.println();
        this.print0(this.ucase ? "USING " : "using ");
        x.getUsing().accept(this);
        this.print0(this.ucase ? " ON (" : " on (");
        x.getOn().accept(this);
        this.print0(") ");
        if (x.getUpdateClause() != null) {
            this.println();
            x.getUpdateClause().accept(this);
        }
        if (x.getInsertClause() != null) {
            this.println();
            x.getInsertClause().accept(this);
        }
        if (x.getErrorLoggingClause() != null) {
            this.println();
            x.getErrorLoggingClause().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement.MergeUpdateClause x) {
        this.print0(this.ucase ? "WHEN MATCHED THEN UPDATE SET " : "when matched then update set ");
        this.printAndAccept(x.getItems(), ", ");
        if (x.getWhere() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        if (x.getDeleteWhere() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "DELETE WHERE " : "delete where ");
            x.getDeleteWhere().setParent(x);
            x.getDeleteWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement.MergeInsertClause x) {
        this.print0(this.ucase ? "WHEN NOT MATCHED THEN INSERT" : "when not matched then insert");
        if (x.getColumns().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getColumns(), ", ");
        }
        this.print0(this.ucase ? " VALUES (" : " values (");
        this.printAndAccept(x.getValues(), ", ");
        this.print(')');
        if (x.getWhere() != null) {
            this.incrementIndent();
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public boolean visit(SQLErrorLoggingClause x) {
        this.print0(this.ucase ? "LOG ERRORS " : "log errors ");
        if (x.getInto() != null) {
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept(this);
            this.print(' ');
        }
        if (x.getSimpleExpression() != null) {
            this.print('(');
            x.getSimpleExpression().accept(this);
            this.print(')');
        }
        if (x.getLimit() != null) {
            this.print0(this.ucase ? " REJECT LIMIT " : " reject limit ");
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateSequenceStatement x) {
        this.print0(this.ucase ? "CREATE SEQUENCE " : "create sequence ");
        x.getName().accept(this);
        if (x.getStartWith() != null) {
            this.print0(this.ucase ? " START WITH " : " start with ");
            x.getStartWith().accept(this);
        }
        if (x.getIncrementBy() != null) {
            this.print0(this.ucase ? " INCREMENT BY " : " increment by ");
            x.getIncrementBy().accept(this);
        }
        if (x.getMaxValue() != null) {
            this.print0(this.ucase ? " MAXVALUE " : " maxvalue ");
            x.getMaxValue().accept(this);
        }
        if (x.isNoMaxValue()) {
            this.print0(this.ucase ? " NOMAXVALUE" : " nomaxvalue");
        }
        if (x.getMinValue() != null) {
            this.print0(this.ucase ? " MINVALUE " : " minvalue ");
            x.getMinValue().accept(this);
        }
        if (x.isNoMinValue()) {
            this.print0(this.ucase ? " NOMINVALUE" : " nominvalue");
        }
        if (x.getCycle() != null) {
            if (x.getCycle().booleanValue()) {
                this.print0(this.ucase ? " CYCLE" : " cycle");
            } else {
                this.print0(this.ucase ? " NOCYCLE" : " nocycle");
            }
        }
        if (x.getCache() != null) {
            if (x.getCache().booleanValue()) {
                this.print0(this.ucase ? " CACHE" : " cache");
            } else {
                this.print0(this.ucase ? " NOCACHE" : " nocache");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLDateExpr x) {
        this.print0(this.ucase ? "DATE '" : "date '");
        this.print0(x.getLiteral());
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(SQLLimit x) {
        this.print0(this.ucase ? "LIMIT " : "limit ");
        if (x.getOffset() != null) {
            x.getOffset().accept(this);
            this.print0(", ");
        }
        x.getRowCount().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDescribeStatement x) {
        this.print0(this.ucase ? "DESC " : "desc ");
        if (x.getObjectType() != null) {
            this.print0(x.getObjectType().name());
            this.print(' ');
        }
        if (x.getObject() != null) {
            x.getObject().accept(this);
        }
        if (x.getPartition().size() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(')');
        }
        return false;
    }

    protected void printHierarchical(SQLSelectQueryBlock x) {
        SQLExpr startWith = x.getStartWith();
        SQLExpr connectBy = x.getConnectBy();
        if (startWith != null || connectBy != null) {
            this.println();
            if (x.getStartWith() != null) {
                this.print0(this.ucase ? "START WITH " : "start with ");
                x.getStartWith().accept(this);
                this.println();
            }
            this.print0(this.ucase ? "CONNECT BY " : "connect by ");
            if (x.isNoCycle()) {
                this.print0(this.ucase ? "NOCYCLE " : "nocycle ");
            }
            if (x.isPrior()) {
                this.print0(this.ucase ? "PRIOR " : "prior ");
            }
            x.getConnectBy().accept(this);
        }
    }

    public void printOracleSegmentAttributes(OracleSegmentAttributes x) {
        if (x.getPctfree() != null) {
            this.println();
            this.print0(this.ucase ? "PCTFREE " : "pctfree ");
            this.print(x.getPctfree());
        }
        if (x.getPctused() != null) {
            this.println();
            this.print0(this.ucase ? "PCTUSED " : "pctused ");
            this.print(x.getPctused());
        }
        if (x.getInitrans() != null) {
            this.println();
            this.print0(this.ucase ? "INITRANS " : "initrans ");
            this.print(x.getInitrans());
        }
        if (x.getMaxtrans() != null) {
            this.println();
            this.print0(this.ucase ? "MAXTRANS " : "maxtrans ");
            this.print(x.getMaxtrans());
        }
        if (x.getCompress() == Boolean.FALSE) {
            this.println();
            this.print0(this.ucase ? "NOCOMPRESS" : "nocompress");
        } else if (x.getCompress() == Boolean.TRUE) {
            this.println();
            this.print0(this.ucase ? "COMPRESS" : "compress");
        }
        if (x.getLogging() == Boolean.TRUE) {
            this.println();
            this.print0(this.ucase ? "LOGGING" : "logging");
        } else if (x.getLogging() == Boolean.FALSE) {
            this.println();
            this.print0(this.ucase ? "NOLOGGING" : "nologging");
        }
        if (x.getTablespace() != null) {
            this.println();
            this.print0(this.ucase ? "TABLESPACE " : "tablespace ");
            x.getTablespace().accept(this);
        }
        if (x.getStorage() != null) {
            this.println();
            x.getStorage().accept(this);
        }
    }

    @Override
    public boolean visit(SQLWhileStatement x) {
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(x.getLabelName());
            this.print0(": ");
        }
        this.print0(this.ucase ? "WHILE " : "while ");
        x.getCondition().accept(this);
        this.print0(this.ucase ? " DO" : " do");
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.println();
        this.print0(this.ucase ? "END WHILE" : "end while");
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print(' ');
        }
        this.print0(x.getLabelName());
        return false;
    }

    @Override
    public boolean visit(SQLDeclareStatement x) {
        boolean printDeclare;
        boolean bl = printDeclare = !(x.getParent() instanceof OracleCreatePackageStatement);
        if (printDeclare) {
            this.print0(this.ucase ? "DECLARE " : "declare ");
        }
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLReturnStatement x) {
        this.print0(this.ucase ? "RETURN" : "return");
        if (x.getExpr() != null) {
            this.print(' ');
            x.getExpr().accept(this);
        }
        return false;
    }

    @Override
    public void postVisit(SQLObject x) {
        SQLStatement stmt;
        if (x instanceof SQLStatement && (stmt = (SQLStatement)x).isAfterSemi()) {
            this.print(';');
        }
    }

    @Override
    public boolean visit(SQLArgument x) {
        SQLParameter.ParameterType type = x.getType();
        if (type != null) {
            this.print0(type.name());
            this.print(' ');
        }
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCommitStatement x) {
        this.print0(this.ucase ? "COMMIT" : "commit");
        if (x.isWrite()) {
            this.print0(this.ucase ? " WRITE" : " write");
            if (x.getWait() != null) {
                if (x.getWait().booleanValue()) {
                    this.print0(this.ucase ? " WAIT" : " wait");
                } else {
                    this.print0(this.ucase ? " NOWAIT" : " nowait");
                }
            }
            if (x.getImmediate() != null) {
                if (x.getImmediate().booleanValue()) {
                    this.print0(this.ucase ? " IMMEDIATE" : " immediate");
                } else {
                    this.print0(this.ucase ? " BATCH" : " batch");
                }
            }
        }
        if (x.isWork()) {
            this.print0(this.ucase ? " WORK" : " work");
        }
        if (x.getChain() != null) {
            if (x.getChain().booleanValue()) {
                this.print0(this.ucase ? " AND CHAIN" : " and chain");
            } else {
                this.print0(this.ucase ? " AND NO CHAIN" : " and no chain");
            }
        }
        if (x.getRelease() != null) {
            if (x.getRelease().booleanValue()) {
                this.print0(this.ucase ? " AND RELEASE" : " and release");
            } else {
                this.print0(this.ucase ? " AND NO RELEASE" : " and no release");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLFlashbackExpr x) {
        this.print0(x.getType().name());
        this.print(' ');
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLBinaryOpExpr) {
            this.print('(');
            expr.accept(this);
            this.print(')');
        } else {
            expr.accept(this);
        }
        return false;
    }
}

