/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import java.util.List;

public class SQLTransformUtils {
    public static SQLExpr transformDecode(SQLMethodInvokeExpr x) {
        if (x == null) {
            return null;
        }
        if (!"decode".equalsIgnoreCase(x.getMethodName())) {
            throw new IllegalArgumentException(x.getMethodName());
        }
        List<SQLExpr> parameters = x.getParameters();
        SQLCaseExpr caseExpr = new SQLCaseExpr();
        caseExpr.setParent(x.getParent());
        caseExpr.setValueExpr(parameters.get(0));
        if (parameters.size() == 4) {
            SQLExpr param1 = parameters.get(1);
            x.setMethodName("if");
            SQLBinaryOpExpr condition = param1 instanceof SQLNullExpr ? new SQLBinaryOpExpr(parameters.get(0), SQLBinaryOperator.Is, param1) : new SQLBinaryOpExpr(parameters.get(0), SQLBinaryOperator.Equality, param1);
            condition.setParent(x);
            parameters.set(0, condition);
            parameters.set(1, parameters.get(2));
            parameters.set(2, parameters.get(3));
            parameters.remove(3);
            return x;
        }
        int i = 1;
        while (i + 1 < parameters.size()) {
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLCaseExpr.Item item = new SQLCaseExpr.Item();
            SQLExpr conditionExpr = parameters.get(i);
            item.setConditionExpr(conditionExpr);
            SQLExpr valueExpr = parameters.get(i + 1);
            if (valueExpr instanceof SQLMethodInvokeExpr && "decode".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)valueExpr).getMethodName())) {
                valueExpr = SQLTransformUtils.transformDecode(methodInvokeExpr);
            }
            item.setValueExpr(valueExpr);
            caseExpr.addItem(item);
            i += 2;
        }
        if (parameters.size() % 2 == 0) {
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLExpr defaultExpr = parameters.get(parameters.size() - 1);
            if (defaultExpr instanceof SQLMethodInvokeExpr && "decode".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)defaultExpr).getMethodName())) {
                defaultExpr = SQLTransformUtils.transformDecode(methodInvokeExpr);
            }
            caseExpr.setElseExpr(defaultExpr);
        }
        caseExpr.setParent(x.getParent());
        return caseExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLDataType transformOracleToMySql(SQLDataType x) {
        SQLDataType dataType;
        String name = x.getName();
        if (name == null) {
            return x;
        }
        List<SQLExpr> argumentns = x.getArguments();
        String name_lower = name.toLowerCase();
        if ("urowid".equalsIgnoreCase(name_lower)) {
            SQLExpr arg0;
            int len = 4000;
            if (argumentns.size() == 1 && (arg0 = argumentns.get(0)) instanceof SQLIntegerExpr) {
                len = ((SQLIntegerExpr)arg0).getNumber().intValue();
            }
            dataType = new SQLDataTypeImpl("varchar", len);
        } else if ("rowid".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("char", 10);
        } else if ("boolean".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("tinyint");
        } else if ("integer".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("int");
        } else if ("float".equals(name_lower) || "binary_float".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("float");
        } else if ("real".equals(name_lower) || "double precision".equals(name_lower) || "binary_double".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("double");
        } else if ("number".equals(name_lower)) {
            if (argumentns.size() == 0) {
                dataType = new SQLDataTypeImpl("decimal", 38);
            } else {
                int precision;
                SQLExpr arg0 = argumentns.get(0);
                int scale = 0;
                if (arg0 instanceof SQLAllColumnExpr) {
                    precision = 9;
                    scale = 1;
                } else {
                    precision = ((SQLIntegerExpr)arg0).getNumber().intValue();
                }
                if (argumentns.size() > 1) {
                    scale = ((SQLIntegerExpr)argumentns.get(1)).getNumber().intValue();
                }
                if (scale > precision) {
                    if (arg0 instanceof SQLAllColumnExpr) {
                        precision = 19;
                        if (scale > precision) {
                            precision = scale;
                        }
                    } else {
                        precision = scale;
                    }
                }
                dataType = scale == 0 ? (precision < 3 ? new SQLDataTypeImpl("tinyint") : (precision < 5 ? new SQLDataTypeImpl("smallint") : (precision < 9 ? new SQLDataTypeImpl("int") : (precision < 19 ? new SQLDataTypeImpl("bigint") : new SQLDataTypeImpl("decimal", precision))))) : new SQLDataTypeImpl("decimal", precision, scale);
            }
        } else if ("dec".equals(name_lower) || "decimal".equals(name_lower)) {
            dataType = x.clone();
            dataType.setName("decimal");
            int precision = 0;
            if (argumentns.size() > 0) {
                precision = ((SQLIntegerExpr)argumentns.get(0)).getNumber().intValue();
            }
            int scale = 0;
            if (argumentns.size() > 1 && precision < (scale = ((SQLIntegerExpr)argumentns.get(1)).getNumber().intValue())) {
                ((SQLIntegerExpr)dataType.getArguments().get(1)).setNumber(precision);
            }
        } else if ("raw".equals(name_lower)) {
            int len;
            if (argumentns.size() == 0) {
                len = -1;
            } else {
                if (argumentns.size() != 1) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
            }
            dataType = len == -1 ? new SQLDataTypeImpl("binary") : (len <= 255 ? new SQLDataTypeImpl("binary", len) : new SQLDataTypeImpl("varbinary", len));
        } else if ("char".equals(name_lower) || "character".equals(name_lower)) {
            if (argumentns.size() == 1) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = len <= 255 ? new SQLCharacterDataType("char", len) : new SQLCharacterDataType("varchar", len);
            } else {
                if (argumentns.size() != 0) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                dataType = new SQLCharacterDataType("char");
            }
        } else if ("nchar".equals(name_lower)) {
            if (argumentns.size() == 1) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = len <= 255 ? new SQLCharacterDataType("nchar", len) : new SQLCharacterDataType("nvarchar", len);
            } else {
                if (argumentns.size() != 0) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                dataType = new SQLCharacterDataType("nchar");
            }
        } else if ("varchar2".equals(name_lower)) {
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = new SQLCharacterDataType("varchar", len);
            } else {
                dataType = new SQLCharacterDataType("varchar");
            }
        } else if ("nvarchar2".equals(name_lower)) {
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = new SQLCharacterDataType("nvarchar", len);
            } else {
                dataType = new SQLCharacterDataType("nvarchar");
            }
        } else if ("bfile".equals(name_lower)) {
            dataType = new SQLCharacterDataType("varchar", 255);
        } else if ("date".equals(name_lower) || "timestamp".equals(name_lower)) {
            int len = -1;
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
            }
            if (len >= 0) {
                if (len > 6) {
                    len = 6;
                }
                dataType = new SQLDataTypeImpl("datetime", len);
            } else {
                dataType = new SQLDataTypeImpl("datetime");
            }
        } else if ("blob".equals(name_lower) || "long raw".equals(name_lower)) {
            argumentns.clear();
            dataType = new SQLDataTypeImpl("LONGBLOB");
        } else if ("clob".equals(name_lower) || "nclob".equals(name_lower) || "long".equals(name_lower) || "xmltype".equals(name_lower)) {
            argumentns.clear();
            dataType = new SQLCharacterDataType("LONGTEXT");
        } else {
            dataType = x;
        }
        if (dataType == x) return dataType;
        dataType.setParent(x.getParent());
        return dataType;
    }

    public static SQLDataType transformOracleToAliyunAds(SQLDataType x) {
        SQLDataType dataType;
        String dataTypeName = x.getName().toLowerCase();
        if (dataTypeName.equals("varchar2") || dataTypeName.equals("varchar") || dataTypeName.equals("char") || dataTypeName.equals("nchar") || dataTypeName.equals("nvarchar") || dataTypeName.equals("nvarchar2") || dataTypeName.equals("clob") || dataTypeName.equals("nclob") || dataTypeName.equals("blob") || dataTypeName.equals("long") || dataTypeName.equals("long raw") || dataTypeName.equals("raw")) {
            dataType = new SQLCharacterDataType("varchar");
        } else if (dataTypeName.equals("number") || dataTypeName.equals("decimal") || dataTypeName.equals("dec") || dataTypeName.equals("numeric")) {
            int scale = 0;
            if (x.getArguments().size() > 1) {
                scale = ((SQLIntegerExpr)x.getArguments().get(1)).getNumber().intValue();
            }
            dataType = scale == 0 ? new SQLDataTypeImpl("bigint") : new SQLDataTypeImpl("double");
        } else {
            dataType = dataTypeName.equals("date") || dataTypeName.equals("datetime") || dataTypeName.equals("timestamp") ? new SQLDataTypeImpl("timestamp") : (dataTypeName.equals("float") || dataTypeName.equals("binary_float") ? new SQLDataTypeImpl("float") : (dataTypeName.equals("double") || dataTypeName.equals("binary_double") ? new SQLDataTypeImpl("double") : x));
        }
        if (dataType != x) {
            dataType.setParent(x.getParent());
        }
        return dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLDataType transformOracleToPostgresql(SQLDataType x) {
        SQLDataType dataType;
        String name = x.getName();
        if (name == null) {
            return x;
        }
        List<SQLExpr> argumentns = x.getArguments();
        String name_lower = name.toLowerCase();
        if ("urowid".equalsIgnoreCase(name_lower)) {
            SQLExpr arg0;
            int len = 4000;
            if (argumentns.size() == 1 && (arg0 = argumentns.get(0)) instanceof SQLIntegerExpr) {
                len = ((SQLIntegerExpr)arg0).getNumber().intValue();
            }
            dataType = new SQLDataTypeImpl("varchar", len);
        } else if ("rowid".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("char", 10);
        } else if ("boolean".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("tinyint");
        } else if ("integer".equals(name_lower) || "int".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("decimal", 38);
        } else if ("binary_float".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("real");
        } else if ("binary_double".equals(name_lower) || "float".equals(name_lower) || "real".equals(name_lower)) {
            dataType = new SQLDataTypeImpl("double precision");
        } else if ("number".equals(name_lower)) {
            if (argumentns.size() == 0) {
                dataType = new SQLDataTypeImpl("decimal", 38);
            } else {
                int precision;
                SQLExpr arg0 = argumentns.get(0);
                int scale = 0;
                if (arg0 instanceof SQLAllColumnExpr) {
                    precision = 9;
                    scale = 1;
                } else {
                    precision = ((SQLIntegerExpr)arg0).getNumber().intValue();
                }
                if (argumentns.size() > 1) {
                    scale = ((SQLIntegerExpr)argumentns.get(1)).getNumber().intValue();
                }
                if (scale > precision) {
                    if (arg0 instanceof SQLAllColumnExpr) {
                        precision = 19;
                        if (scale > precision) {
                            precision = scale;
                        }
                    } else {
                        precision = scale;
                    }
                }
                dataType = scale == 0 ? (precision < 3 ? new SQLDataTypeImpl("tinyint") : (precision < 5 ? new SQLDataTypeImpl("smallint") : (precision < 9 ? new SQLDataTypeImpl("int") : (precision < 19 ? new SQLDataTypeImpl("bigint") : new SQLDataTypeImpl("decimal", precision))))) : new SQLDataTypeImpl("decimal", precision, scale);
            }
        } else if ("dec".equals(name_lower) || "decimal".equals(name_lower)) {
            dataType = x.clone();
            dataType.setName("decimal");
            int precision = 0;
            if (argumentns.size() > 0) {
                precision = ((SQLIntegerExpr)argumentns.get(0)).getNumber().intValue();
            }
            int scale = 0;
            if (argumentns.size() > 1 && precision < (scale = ((SQLIntegerExpr)argumentns.get(1)).getNumber().intValue())) {
                ((SQLIntegerExpr)dataType.getArguments().get(1)).setNumber(precision);
            }
        } else if ("char".equals(name_lower) || "character".equals(name_lower)) {
            if (argumentns.size() == 1) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = len <= 255 ? new SQLCharacterDataType("char", len) : new SQLCharacterDataType("varchar", len);
            } else {
                if (argumentns.size() != 0) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                dataType = new SQLCharacterDataType("char");
            }
        } else if ("nchar".equals(name_lower)) {
            if (argumentns.size() == 1) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = len <= 255 ? new SQLCharacterDataType("char", len) : new SQLCharacterDataType("varchar", len);
            } else {
                if (argumentns.size() != 0) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                dataType = new SQLCharacterDataType("char");
            }
        } else if ("varchar2".equals(name_lower)) {
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = new SQLCharacterDataType("varchar", len);
            } else {
                dataType = new SQLCharacterDataType("varchar");
            }
        } else if ("nvarchar2".equals(name_lower) || "nchar varying".equals(name_lower)) {
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) {
                    throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                }
                int len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
                dataType = new SQLCharacterDataType("varchar", len);
            } else {
                dataType = new SQLCharacterDataType("varchar");
            }
        } else if ("bfile".equals(name_lower)) {
            dataType = new SQLCharacterDataType("varchar", 255);
        } else if ("date".equals(name_lower) || "timestamp".equals(name_lower)) {
            int len = -1;
            if (argumentns.size() > 0) {
                SQLExpr arg0 = argumentns.get(0);
                if (!(arg0 instanceof SQLNumericLiteralExpr)) throw new UnsupportedOperationException(SQLUtils.toOracleString(x));
                len = ((SQLNumericLiteralExpr)arg0).getNumber().intValue();
            }
            dataType = new SQLDataTypeImpl("timestamp", len);
        } else if ("blob".equals(name_lower) || "long raw".equals(name_lower) || "raw".equals(name_lower)) {
            argumentns.clear();
            dataType = new SQLDataTypeImpl("bytea");
        } else if ("clob".equals(name_lower) || "nclob".equals(name_lower) || "long".equals(name_lower)) {
            argumentns.clear();
            dataType = new SQLCharacterDataType("TEXT");
        } else {
            dataType = "xmltype".equals(name_lower) ? new SQLDataTypeImpl("xml") : x;
        }
        if (dataType == x) return dataType;
        dataType.setParent(x.getParent());
        return dataType;
    }
}

