/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLCaseExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Item> items = new ArrayList<Item>();
    private SQLExpr valueExpr;
    private SQLExpr elseExpr;

    public SQLExpr getValueExpr() {
        return this.valueExpr;
    }

    public void setValueExpr(SQLExpr valueExpr) {
        if (valueExpr != null) {
            valueExpr.setParent(this);
        }
        this.valueExpr = valueExpr;
    }

    public SQLExpr getElseExpr() {
        return this.elseExpr;
    }

    public void setElseExpr(SQLExpr elseExpr) {
        if (elseExpr != null) {
            elseExpr.setParent(this);
        }
        this.elseExpr = elseExpr;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void addItem(Item item) {
        if (item != null) {
            item.setParent(this);
            this.items.add(item);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.valueExpr);
            this.acceptChild(visitor, this.items);
            this.acceptChild(visitor, this.elseExpr);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.valueExpr == expr) {
            this.setValueExpr(target);
            return true;
        }
        if (this.elseExpr == expr) {
            this.setElseExpr(target);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elseExpr == null ? 0 : this.elseExpr.hashCode());
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.valueExpr == null ? 0 : this.valueExpr.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLCaseExpr other = (SQLCaseExpr)obj;
        if (this.elseExpr == null ? other.elseExpr != null : !this.elseExpr.equals(other.elseExpr)) {
            return false;
        }
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        return !(this.valueExpr == null ? other.valueExpr != null : !this.valueExpr.equals(other.valueExpr));
    }

    @Override
    public SQLCaseExpr clone() {
        SQLCaseExpr x = new SQLCaseExpr();
        for (Item item : this.items) {
            x.addItem(item.clone());
        }
        if (this.valueExpr != null) {
            x.setValueExpr(this.valueExpr.clone());
        }
        if (this.elseExpr != null) {
            x.setElseExpr(this.elseExpr.clone());
        }
        return x;
    }

    @Override
    public SQLDataType computeDataType() {
        for (Item item : this.items) {
            SQLDataType dataType;
            SQLExpr expr = item.getValueExpr();
            if (expr == null || (dataType = expr.computeDataType()) == null) continue;
            return dataType;
        }
        if (this.elseExpr != null) {
            return this.elseExpr.computeDataType();
        }
        return null;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, null);
    }

    public static class Item
    extends SQLObjectImpl
    implements SQLReplaceable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private SQLExpr conditionExpr;
        private SQLExpr valueExpr;

        public Item() {
        }

        public Item(SQLExpr conditionExpr, SQLExpr valueExpr) {
            this.setConditionExpr(conditionExpr);
            this.setValueExpr(valueExpr);
        }

        public SQLExpr getConditionExpr() {
            return this.conditionExpr;
        }

        public void setConditionExpr(SQLExpr conditionExpr) {
            if (conditionExpr != null) {
                conditionExpr.setParent(this);
            }
            this.conditionExpr = conditionExpr;
        }

        public SQLExpr getValueExpr() {
            return this.valueExpr;
        }

        public void setValueExpr(SQLExpr valueExpr) {
            if (valueExpr != null) {
                valueExpr.setParent(this);
            }
            this.valueExpr = valueExpr;
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.conditionExpr);
                this.acceptChild(visitor, this.valueExpr);
            }
            visitor.endVisit(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conditionExpr == null ? 0 : this.conditionExpr.hashCode());
            result = 31 * result + (this.valueExpr == null ? 0 : this.valueExpr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.conditionExpr == null ? other.conditionExpr != null : !this.conditionExpr.equals(other.conditionExpr)) {
                return false;
            }
            return !(this.valueExpr == null ? other.valueExpr != null : !this.valueExpr.equals(other.valueExpr));
        }

        @Override
        public Item clone() {
            Item x = new Item();
            if (this.conditionExpr != null) {
                x.setConditionExpr(this.conditionExpr.clone());
            }
            if (this.valueExpr != null) {
                x.setValueExpr(this.valueExpr.clone());
            }
            return x;
        }

        @Override
        public boolean replace(SQLExpr expr, SQLExpr target) {
            if (this.valueExpr == expr) {
                this.setValueExpr(target);
                return true;
            }
            if (this.conditionExpr == expr) {
                this.setConditionExpr(target);
                return true;
            }
            return false;
        }
    }
}

