/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.db2.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.dialect.db2.parser.DB2Lexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class DB2ExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public DB2ExprParser(String sql) {
        this(new DB2Lexer(sql));
        this.lexer.nextToken();
    }

    public DB2ExprParser(String sql, SQLParserFeature ... features) {
        this(new DB2Lexer(sql, features));
        this.lexer.nextToken();
    }

    public DB2ExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        SQLIdentifierExpr identExpr;
        if (this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr2 = (SQLIdentifierExpr)expr;
                if (identExpr2.hashCode64() == FnvHash.Constants.NEXT) {
                    this.lexer.nextToken();
                    this.accept(Token.FOR);
                    SQLName seqName = this.name();
                    SQLSequenceExpr seqExpr = new SQLSequenceExpr(seqName, SQLSequenceExpr.Function.NextVal);
                    return seqExpr;
                }
                if (identExpr2.hashCode64() == FnvHash.Constants.PREVIOUS) {
                    this.lexer.nextToken();
                    this.accept(Token.FOR);
                    SQLName seqName = this.name();
                    SQLSequenceExpr seqExpr = new SQLSequenceExpr(seqName, SQLSequenceExpr.Function.PrevVal);
                    return seqExpr;
                }
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.DATE)) {
            SQLIdentifierExpr identExpr3;
            if (expr instanceof SQLIdentifierExpr && (identExpr3 = (SQLIdentifierExpr)expr).hashCode64() == FnvHash.Constants.CURRENT) {
                this.lexer.nextToken();
                expr = new SQLIdentifierExpr("CURRENT DATE");
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.TIMESTAMP) && expr instanceof SQLIdentifierExpr && (identExpr = (SQLIdentifierExpr)expr).hashCode64() == FnvHash.Constants.CURRENT) {
            this.lexer.nextToken();
            expr = new SQLIdentifierExpr("CURRENT DATE");
        }
        return super.primaryRest(expr);
    }

    @Override
    protected SQLExpr dotRest(SQLExpr expr) {
        if (this.lexer.identifierEquals("NEXTVAL")) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(identExpr, SQLSequenceExpr.Function.NextVal);
                this.lexer.nextToken();
                return seqExpr;
            }
        } else if (this.lexer.identifierEquals("PREVVAL")) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(identExpr, SQLSequenceExpr.Function.PrevVal);
                this.lexer.nextToken();
                return seqExpr;
            }
        } else if (this.lexer.identifierEquals("CURRVAL") && expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
            SQLSequenceExpr seqExpr = new SQLSequenceExpr(identExpr, SQLSequenceExpr.Function.CurrVal);
            this.lexer.nextToken();
            return seqExpr;
        }
        return super.dotRest(expr);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "ROWNUMBER"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            DB2ExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

