/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SymbolTable;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class MySqlLexer
extends Lexer {
    public static SymbolTable quoteTable = new SymbolTable(8192);
    public static final Keywords DEFAULT_MYSQL_KEYWORDS;
    private static final boolean[] identifierFlags;

    public MySqlLexer(char[] input, int inputLength, boolean skipComment) {
        super(input, inputLength, skipComment);
        this.keywods = DEFAULT_MYSQL_KEYWORDS;
    }

    public MySqlLexer(String input) {
        this(input, true, true);
    }

    public MySqlLexer(String input, SQLParserFeature ... features) {
        this(input, true, true);
        for (SQLParserFeature feature : features) {
            this.config(feature, true);
        }
    }

    public MySqlLexer(String input, boolean skipComment, boolean keepComments) {
        super(input, skipComment);
        this.skipComment = skipComment;
        this.keepComments = keepComments;
        this.keywods = DEFAULT_MYSQL_KEYWORDS;
    }

    @Override
    public void scanSharp() {
        if (this.ch != '#') {
            throw new ParserException("illegal stat. " + this.info());
        }
        if (this.charAt(this.pos + 1) == '{') {
            this.scanVariable();
            return;
        }
        Token lastToken = this.token;
        this.scanChar();
        this.mark = this.pos;
        this.bufPos = 0;
        while (true) {
            if (this.ch == '\r') {
                if (this.charAt(this.pos + 1) == '\n') {
                    this.bufPos += 2;
                    this.scanChar();
                    break;
                }
                ++this.bufPos;
                break;
            }
            if (this.ch == '\u001a') break;
            if (this.ch == '\n') {
                this.scanChar();
                ++this.bufPos;
                break;
            }
            this.scanChar();
            ++this.bufPos;
        }
        this.stringVal = this.subString(this.mark - 1, this.bufPos + 1);
        this.token = Token.LINE_COMMENT;
        ++this.commentCount;
        if (this.keepComments) {
            this.addComment(this.stringVal);
        }
        if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
            return;
        }
        this.endOfComment = this.isEOF();
        if (!(this.isAllowComment() || !this.isEOF() && this.isSafeComment(this.stringVal))) {
            throw new NotAllowCommentException();
        }
    }

    @Override
    public void scanVariable() {
        if (this.ch != '@' && this.ch != ':' && this.ch != '#' && this.ch != '$') {
            throw new ParserException("illegal variable. " + this.info());
        }
        this.mark = this.pos;
        this.bufPos = 1;
        if (this.charAt(this.pos + 1) == '@') {
            this.ch = this.charAt(++this.pos);
            ++this.bufPos;
        }
        if (this.charAt(this.pos + 1) == '`') {
            char ch;
            ++this.pos;
            ++this.bufPos;
            while (true) {
                if ((ch = this.charAt(++this.pos)) == '`') {
                    ++this.bufPos;
                    break;
                }
                if (ch == '\u001a') {
                    throw new ParserException("illegal identifier. " + this.info());
                }
                ++this.bufPos;
            }
            ch = this.charAt(++this.pos);
            this.ch = this.charAt(this.pos);
            this.stringVal = this.subString(this.mark, this.bufPos);
            this.token = Token.VARIANT;
        } else if (this.charAt(this.pos + 1) == '{') {
            char ch;
            ++this.pos;
            ++this.bufPos;
            while (true) {
                if ((ch = this.charAt(++this.pos)) == '}') {
                    ++this.bufPos;
                    break;
                }
                if (ch == '\u001a') {
                    throw new ParserException("illegal identifier. " + this.info());
                }
                ++this.bufPos;
            }
            ch = this.charAt(++this.pos);
            this.ch = this.charAt(this.pos);
            this.stringVal = this.subString(this.mark, this.bufPos);
            this.token = Token.VARIANT;
        } else {
            while (true) {
                this.ch = this.charAt(++this.pos);
                if (!MySqlLexer.isIdentifierChar(this.ch)) break;
                ++this.bufPos;
            }
        }
        this.ch = this.charAt(this.pos);
        this.stringVal = this.subString(this.mark, this.bufPos);
        this.token = Token.VARIANT;
    }

    @Override
    public void scanIdentifier() {
        this.hash_lower = 0L;
        this.hash = 0L;
        char first = this.ch;
        if (this.ch == 'b' && this.charAt(this.pos + 1) == '\'') {
            int i = 2;
            int mark = this.pos + 2;
            while (true) {
                char ch;
                if ((ch = this.charAt(this.pos + i)) != '0' && ch != '1') {
                    if (ch == '\'') {
                        this.bufPos += i;
                        this.pos += i + 1;
                        this.stringVal = this.subString(mark, i - 2);
                        this.ch = this.charAt(this.pos);
                        this.token = Token.BITS;
                        return;
                    }
                    if (ch != '\u001a') break;
                    throw new ParserException("illegal identifier. " + this.info());
                }
                ++i;
            }
        }
        if (this.ch == '`') {
            this.mark = this.pos;
            this.bufPos = 1;
            int startPos = this.pos + 1;
            int quoteIndex = this.text.indexOf(96, startPos);
            if (quoteIndex == -1) {
                throw new ParserException("illegal identifier. " + this.info());
            }
            this.hash_lower = -3750763034362895579L;
            this.hash = -3750763034362895579L;
            for (int i = startPos; i < quoteIndex; ++i) {
                int ch = this.text.charAt(i);
                this.hash_lower ^= (long)(ch >= 65 && ch <= 90 ? ch + 32 : ch);
                this.hash_lower *= 1099511628211L;
                this.hash ^= (long)ch;
                this.hash *= 1099511628211L;
            }
            this.stringVal = quoteTable.addSymbol(this.text, this.pos, quoteIndex + 1 - this.pos, this.hash);
            this.pos = quoteIndex + 1;
            this.ch = this.charAt(this.pos);
            this.token = Token.IDENTIFIER;
        } else {
            boolean firstFlag = CharTypes.isFirstIdentifierChar(first);
            if (!firstFlag) {
                throw new ParserException("illegal identifier. " + this.info());
            }
            this.hash_lower = -3750763034362895579L;
            this.hash = -3750763034362895579L;
            this.hash_lower ^= (long)(this.ch >= 'A' && this.ch <= 'Z' ? this.ch + 32 : this.ch);
            this.hash_lower *= 1099511628211L;
            this.hash ^= (long)this.ch;
            this.hash *= 1099511628211L;
            this.mark = this.pos;
            this.bufPos = 1;
            int ch = 0;
            while (MySqlLexer.isIdentifierChar((char)(ch = this.charAt(++this.pos)))) {
                ++this.bufPos;
                this.hash_lower ^= (long)(ch >= 65 && ch <= 90 ? ch + 32 : ch);
                this.hash_lower *= 1099511628211L;
                this.hash ^= (long)ch;
                this.hash *= 1099511628211L;
            }
            this.ch = this.charAt(this.pos);
            if (this.bufPos == 1) {
                this.token = Token.IDENTIFIER;
                this.stringVal = CharTypes.valueOf(first);
                if (this.stringVal == null) {
                    this.stringVal = Character.toString(first);
                }
                return;
            }
            Token tok = this.keywods.getKeyword(this.hash_lower);
            if (tok != null) {
                this.token = tok;
                this.stringVal = this.token == Token.IDENTIFIER ? SymbolTable.global.addSymbol(this.text, this.mark, this.bufPos, this.hash) : null;
            } else {
                this.token = Token.IDENTIFIER;
                this.stringVal = SymbolTable.global.addSymbol(this.text, this.mark, this.bufPos, this.hash);
            }
        }
    }

    @Override
    protected final void scanString() {
        this.scanString2();
    }

    @Override
    public void scanComment() {
        Token lastToken = this.token;
        if (this.ch == '-') {
            char next_2 = this.charAt(this.pos + 2);
            if (this.isDigit(next_2)) {
                this.scanChar();
                this.token = Token.SUB;
                return;
            }
        } else if (this.ch != '/') {
            throw new IllegalStateException();
        }
        this.mark = this.pos;
        this.bufPos = 0;
        this.scanChar();
        if (this.ch == '*') {
            this.scanChar();
            ++this.bufPos;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.bufPos;
            }
            boolean isHint = false;
            int startHintSp = this.bufPos + 1;
            if (this.ch == '!' || this.ch == '+') {
                isHint = true;
                this.scanChar();
                ++this.bufPos;
            }
            int starIndex = this.pos;
            while (true) {
                if ((starIndex = this.text.indexOf(42, starIndex)) == -1 || starIndex == this.text.length() - 1) {
                    this.token = Token.ERROR;
                    return;
                }
                if (this.charAt(starIndex + 1) == '/') {
                    if (isHint) {
                        this.stringVal = this.subString(this.mark + startHintSp, starIndex - startHintSp - this.mark);
                        this.token = Token.HINT;
                    } else {
                        this.stringVal = this.subString(this.mark, starIndex + 2 - this.mark);
                        this.token = Token.MULTI_LINE_COMMENT;
                        ++this.commentCount;
                        if (this.keepComments) {
                            this.addComment(this.stringVal);
                        }
                    }
                    break;
                }
                ++starIndex;
            }
            this.pos = starIndex + 2;
            this.ch = this.charAt(this.pos);
            this.endOfComment = this.isEOF();
            if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
                return;
            }
            if (!(isHint || this.isAllowComment() || this.isSafeComment(this.stringVal))) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (this.ch == '/' || this.ch == '-') {
            this.scanChar();
            ++this.bufPos;
            while (true) {
                if (this.ch == '\r') {
                    if (this.charAt(this.pos + 1) == '\n') {
                        this.bufPos += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.bufPos;
                    break;
                }
                if (this.ch == '\u001a') break;
                if (this.ch == '\n') {
                    this.scanChar();
                    ++this.bufPos;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.stringVal = this.subString(this.mark, this.bufPos);
            this.token = Token.LINE_COMMENT;
            ++this.commentCount;
            if (this.keepComments) {
                this.addComment(this.stringVal);
            }
            if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
                return;
            }
            this.endOfComment = this.isEOF();
            if (!(this.isAllowComment() || !this.isEOF() && this.isSafeComment(this.stringVal))) {
                throw new NotAllowCommentException();
            }
            return;
        }
    }

    public static boolean isIdentifierChar(char c) {
        if (c <= identifierFlags.length) {
            return identifierFlags[c];
        }
        return c != '\u3000' && c != '\uff0c';
    }

    @Override
    public void scanNumber() {
        this.mark = this.pos;
        if (this.ch == '0' && this.charAt(this.pos + 1) == 'b') {
            int i = 2;
            int mark = this.pos + 2;
            while (true) {
                char ch;
                if ((ch = this.charAt(this.pos + i)) != '0' && ch != '1') {
                    if (ch >= '2' && ch <= '9') break;
                    this.bufPos += i;
                    this.pos += i;
                    this.stringVal = this.subString(mark, i - 2);
                    this.ch = this.charAt(this.pos);
                    this.token = Token.BITS;
                    return;
                }
                ++i;
            }
        }
        if (this.ch == '-') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            if (this.charAt(this.pos + 1) == '.') {
                this.token = Token.LITERAL_INT;
                return;
            }
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.bufPos;
            this.ch = this.charAt(++this.pos);
            if (this.ch == '+' || this.ch == '-') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.bufPos;
                this.ch = this.charAt(++this.pos);
            }
            isDouble = true;
        }
        if (isDouble) {
            this.token = Token.LITERAL_FLOAT;
        } else if (CharTypes.isFirstIdentifierChar(this.ch) && (this.ch != 'b' || this.bufPos != 1 || this.charAt(this.pos - 1) != '0')) {
            ++this.bufPos;
            while (true) {
                this.ch = this.charAt(++this.pos);
                if (!MySqlLexer.isIdentifierChar(this.ch)) break;
                ++this.bufPos;
            }
            this.stringVal = this.addSymbol();
            this.token = Token.IDENTIFIER;
        } else {
            this.token = Token.LITERAL_INT;
        }
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("DUAL", Token.DUAL);
        map.put("FALSE", Token.FALSE);
        map.put("IDENTIFIED", Token.IDENTIFIED);
        map.put("IF", Token.IF);
        map.put("KILL", Token.KILL);
        map.put("LIMIT", Token.LIMIT);
        map.put("TRUE", Token.TRUE);
        map.put("BINARY", Token.BINARY);
        map.put("SHOW", Token.SHOW);
        map.put("CACHE", Token.CACHE);
        map.put("ANALYZE", Token.ANALYZE);
        map.put("OPTIMIZE", Token.OPTIMIZE);
        map.put("ROW", Token.ROW);
        map.put("BEGIN", Token.BEGIN);
        map.put("END", Token.END);
        map.put("DIV", Token.DIV);
        map.put("MERGE", Token.MERGE);
        map.put("PARTITION", Token.PARTITION);
        map.put("CONTINUE", Token.CONTINUE);
        map.put("UNDO", Token.UNDO);
        map.put("SQLSTATE", Token.SQLSTATE);
        map.put("CONDITION", Token.CONDITION);
        DEFAULT_MYSQL_KEYWORDS = new Keywords(map);
        identifierFlags = new boolean[256];
        for (int c = 0; c < identifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                MySqlLexer.identifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                MySqlLexer.identifierFlags[c] = true;
                continue;
            }
            if (c < 48 || c > 57) continue;
            MySqlLexer.identifierFlags[c] = true;
        }
        MySqlLexer.identifierFlags[95] = true;
    }
}

