/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.ModelClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class OracleSelectQueryBlock
extends SQLSelectQueryBlock
implements OracleSQLObject {
    private ModelClause modelClause;
    private boolean skipLocked = false;

    @Override
    public OracleSelectQueryBlock clone() {
        OracleSelectQueryBlock x = new OracleSelectQueryBlock();
        super.cloneTo(x);
        if (this.modelClause != null) {
            x.setModelClause(this.modelClause.clone());
        }
        if (this.forUpdateOf != null) {
            for (SQLExpr item : this.forUpdateOf) {
                SQLExpr item1 = item.clone();
                item1.setParent(x);
                x.getForUpdateOf().add(item1);
            }
        }
        x.skipLocked = this.skipLocked;
        return x;
    }

    public OracleSelectQueryBlock() {
        this.dbType = DbType.oracle;
    }

    public ModelClause getModelClause() {
        return this.modelClause;
    }

    public void setModelClause(ModelClause modelClause) {
        this.modelClause = modelClause;
    }

    public boolean isSkipLocked() {
        return this.skipLocked;
    }

    public void setSkipLocked(boolean skipLocked) {
        this.skipLocked = skipLocked;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof OracleASTVisitor) {
            this.accept0((OracleASTVisitor)visitor);
            return;
        }
        super.accept0(visitor);
    }

    @Override
    public void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.hints);
            this.acceptChild((SQLASTVisitor)visitor, this.selectList);
            this.acceptChild((SQLASTVisitor)visitor, this.into);
            this.acceptChild((SQLASTVisitor)visitor, this.from);
            this.acceptChild((SQLASTVisitor)visitor, this.where);
            this.acceptChild((SQLASTVisitor)visitor, this.startWith);
            this.acceptChild((SQLASTVisitor)visitor, this.connectBy);
            this.acceptChild((SQLASTVisitor)visitor, this.groupBy);
            this.acceptChild((SQLASTVisitor)visitor, this.orderBy);
            this.acceptChild((SQLASTVisitor)visitor, this.waitTime);
            this.acceptChild((SQLASTVisitor)visitor, this.limit);
            this.acceptChild((SQLASTVisitor)visitor, this.modelClause);
            this.acceptChild((SQLASTVisitor)visitor, this.forUpdateOf);
        }
        visitor.endVisit(this);
    }

    @Override
    public String toString() {
        return SQLUtils.toOracleString(this);
    }

    @Override
    public void limit(int rowCount, int offset) {
        if (offset > 0) {
            throw new UnsupportedOperationException("not support offset");
        }
        SQLIntegerExpr rowCountExpr = new SQLIntegerExpr(rowCount);
        SQLExpr newCondition = SQLUtils.buildCondition(SQLBinaryOperator.BooleanAnd, rowCountExpr, false, this.where);
        this.setWhere(newCondition);
    }

    public void setFrom(String tableName) {
        OracleSelectTableReference from = tableName == null || tableName.length() == 0 ? null : new OracleSelectTableReference(new SQLIdentifierExpr(tableName));
        this.setFrom(from);
    }
}

