/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.athena.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.athena.ast.stmt.AthenaCreateTableStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInputOutputFormat;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoCreateTableParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class AthenaCreateTableParser
extends PrestoCreateTableParser {
    public AthenaCreateTableParser(String sql) {
        super(sql);
        this.dbType = DbType.athena;
    }

    public AthenaCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.athena;
    }

    @Override
    protected void createTableBefore(SQLCreateTableStatement stmt) {
        this.acceptIdentifier(FnvHash.Constants.EXTERNAL);
        stmt.setExternal(true);
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLExpr comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        if (this.lexer.nextIf(Token.PARTITIONED)) {
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("expect identifier. " + this.lexer.info());
                }
                SQLColumnDefinition column = this.exprParser.parseColumn();
                stmt.addPartitionColumn(column);
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                column.addAfterComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.CLUSTERED)) {
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                stmt.addClusteredByItem(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            this.parseRowFormat(stmt);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            if (this.lexer.identifierEquals(FnvHash.Constants.INPUTFORMAT)) {
                HiveInputOutputFormat format = new HiveInputOutputFormat();
                this.lexer.nextToken();
                format.setInput(this.exprParser.primary());
                if (this.lexer.identifierEquals(FnvHash.Constants.OUTPUTFORMAT)) {
                    this.lexer.nextToken();
                    format.setOutput(this.exprParser.primary());
                }
                stmt.setStoredAs(format);
            } else {
                SQLName name = this.exprParser.name();
                stmt.setStoredAs(name);
            }
        }
        this.parseCreateTableWithSerderPropertie(stmt);
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.primary();
            stmt.setLocation(location);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(stmt.getTableOptions(), stmt, false);
            this.accept(Token.RPAREN);
        }
    }

    protected void parseRowFormat(SQLCreateTableStatement stmt) {
        SQLExternalRecordFormat format = this.getExprParser().parseRowFormat();
        stmt.setRowFormat(format);
    }

    protected void parseCreateTableWithSerderPropertie(SQLCreateTableStatement stmt) {
        if (stmt instanceof AthenaCreateTableStatement) {
            AthenaCreateTableStatement athenaStmt = (AthenaCreateTableStatement)stmt;
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("SERDEPROPERTIES");
                this.accept(Token.LPAREN);
                while (true) {
                    String key = this.lexer.stringVal();
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    SQLExpr value = this.exprParser.primary();
                    athenaStmt.getSerdeProperties().put(key, value);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
        }
    }

    @Override
    protected AthenaCreateTableStatement newCreateStatement() {
        return new AthenaCreateTableStatement();
    }
}

