/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateTimeExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsNewExpr;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsTransformExpr;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.druid.sql.parser.EOFParserException;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;
import java.util.List;

public class OdpsExprParser
extends HiveExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;
    static final long GSONBUILDER;

    @Override
    protected SQLExpr primaryAs(SQLExpr sqlExpr) {
        Lexer.SavePoint mark = this.lexer.mark();
        String str = this.lexer.stringVal();
        this.lexer.nextToken();
        switch (this.lexer.token()) {
            case COMMA: 
            case RPAREN: 
            case AS: 
            case EQ: 
            case EQEQ: 
            case LT: 
            case LTEQ: 
            case GT: 
            case GTEQ: 
            case LTGT: 
            case SEMI: {
                sqlExpr = new SQLIdentifierExpr(str);
                break;
            }
            case DOT: {
                sqlExpr = this.primaryRest(new SQLIdentifierExpr(str));
                break;
            }
            default: {
                this.lexer.reset(mark);
            }
        }
        return sqlExpr;
    }

    @Override
    protected SQLExpr primaryIn(SQLExpr sqlExpr) {
        String str = this.lexer.stringVal();
        this.lexer.nextToken();
        switch (this.lexer.token()) {
            case COMMA: 
            case RPAREN: 
            case AS: 
            case EQ: 
            case LT: 
            case GT: 
            case DOT: 
            case IS: {
                sqlExpr = new SQLIdentifierExpr(str);
                break;
            }
        }
        if (sqlExpr != null) {
            return sqlExpr;
        }
        this.accept(Token.LPAREN);
        SQLInListExpr in = new SQLInListExpr();
        in.setExpr(this.expr());
        if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            this.exprList(in.getTargetList(), in);
        }
        this.accept(Token.RPAREN);
        sqlExpr = in;
        return sqlExpr;
    }

    @Override
    protected SQLExpr primaryColonColon(SQLExpr sqlExpr) {
        this.lexer.nextToken();
        SQLExpr temp = this.primary();
        if (temp instanceof SQLArrayExpr) {
            sqlExpr = temp;
        } else {
            SQLMethodInvokeExpr method = (SQLMethodInvokeExpr)temp;
            method.setOwner(new SQLIdentifierExpr(""));
            sqlExpr = method;
        }
        return sqlExpr;
    }

    @Override
    protected void methodRestUsing(SQLMethodInvokeExpr methodInvokeExpr) {
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            SQLExpr using = this.primary();
            methodInvokeExpr.setUsing(using);
        }
    }

    @Override
    protected String doRestSpecific(SQLExpr expr) {
        String name = null;
        if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT) {
            name = this.lexer.numberString();
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DOT && expr.toString().equals("odps.sql.mapper")) {
            this.lexer.nextToken();
            name = this.lexer.stringVal();
            this.lexer.nextToken();
        }
        return name;
    }

    @Override
    protected String nameCommon() {
        String identName = this.lexer.stringVal();
        this.lexer.nextToken();
        return identName;
    }

    @Override
    protected SQLExpr relationalRestBang(SQLExpr expr) {
        this.lexer.nextToken();
        return this.notRationalRest(expr, false);
    }

    @Override
    protected void parseDataTypeComplex(StringBuilder typeName) {
        if (this.lexer.token() == Token.LT && this.dbType == DbType.odps) {
            this.lexer.nextToken();
            typeName.append('<');
            while (true) {
                SQLDataType itemType = this.parseDataType();
                typeName.append(itemType.toString());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                typeName.append(", ");
            }
            this.accept(Token.GT);
            typeName.append('>');
        }
    }

    @Override
    protected void parseColumnCommentLiteralCharsRest(StringBuilder stringVal) {
        while (true) {
            if (this.lexer.token() == Token.LITERAL_ALIAS) {
                String tmp = this.lexer.stringVal();
                if (tmp.length() > 2 && tmp.charAt(0) == '\"' && tmp.charAt(tmp.length() - 1) == '\"') {
                    tmp = tmp.substring(1, tmp.length() - 1);
                }
                stringVal.append(tmp);
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() != Token.LITERAL_CHARS) break;
            stringVal.append(this.lexer.stringVal());
            this.lexer.nextToken();
        }
    }

    @Override
    protected void parseAssignItemDot() {
        if (this.lexer.token() == Token.DOT) {
            this.lexer.nextToken();
        }
    }

    @Override
    protected void parseAssignItemNcToBeExecuted() {
        if (this.lexer.identifierEquals("NC_TO_BE_EXECUTED")) {
            this.lexer.nextToken();
        }
    }

    @Override
    protected boolean parseAssignItemTblProperties(SQLAssignItem item) {
        if (this.lexer.token() == Token.LPAREN) {
            SQLListExpr list = new SQLListExpr();
            this.exprList(list.getItems(), list);
            item.setTarget(new SQLIdentifierExpr("tblproperties"));
            item.setValue(list);
            return true;
        }
        return false;
    }

    @Override
    protected SQLExpr parseAssignItemSQLPropertyExprAndSub(SQLExpr sqlExpr) {
        if (sqlExpr instanceof SQLPropertyExpr && this.lexer.token() == Token.SUB) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)sqlExpr;
            String name = propertyExpr.getName() + '-';
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IDENTIFIER) {
                name = name + this.lexer.stringVal();
                this.lexer.nextToken();
            }
            propertyExpr.setName(name);
            return this.primaryRest(propertyExpr);
        }
        return sqlExpr;
    }

    @Override
    protected SQLExpr parseAssignItemSQLPropertyExpr(SQLExpr sqlExpr) {
        if (sqlExpr instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)sqlExpr;
            if (this.identifierEquals("DATEADD")) {
                String func = this.lexer.stringVal();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.accept(Token.RPAREN);
                    func = func + "()";
                }
                String name = propertyExpr.getName() + func;
                propertyExpr.setName(name);
            } else if (propertyExpr.getName().equalsIgnoreCase("enab") && this.identifierEquals("le")) {
                String name = propertyExpr.getName() + this.lexer.stringVal();
                this.lexer.nextToken();
                propertyExpr.setName(name);
            } else if (propertyExpr.getName().equalsIgnoreCase("sq") && this.identifierEquals("l")) {
                String name = propertyExpr.getName() + this.lexer.stringVal();
                this.lexer.nextToken();
                propertyExpr.setName(name);
            } else if (propertyExpr.getName().equalsIgnoreCase("s") && this.identifierEquals("ql")) {
                String name = propertyExpr.getName() + this.lexer.stringVal();
                this.lexer.nextToken();
                propertyExpr.setName(name);
                sqlExpr = this.primaryRest(propertyExpr);
            } else if (this.lexer.token() == Token.BY) {
                String name = propertyExpr.getName() + ' ' + this.lexer.stringVal();
                this.lexer.nextToken();
                propertyExpr.setName(name);
                sqlExpr = this.primaryRest(propertyExpr);
            }
        }
        return sqlExpr;
    }

    @Override
    protected boolean parseAssignItemSQLMethodInvokeExpr(SQLExpr sqlExpr, SQLAssignItem item) {
        if (sqlExpr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)sqlExpr;
            SQLExpr owner = func.getOwner();
            if (owner != null) {
                item.setTarget(new SQLPropertyExpr(owner, func.getMethodName()));
            } else {
                item.setTarget(new SQLIdentifierExpr(func.getMethodName()));
            }
            SQLListExpr properties = new SQLListExpr();
            for (SQLExpr argument : func.getArguments()) {
                properties.addItem(argument);
            }
            item.setValue(properties);
            return true;
        }
        return false;
    }

    @Override
    protected void parseAssignItemEq(SQLObject parent) {
        if (parent instanceof SQLSetStatement || parent == null) {
            this.lexer.nextTokenForSet();
        } else {
            this.lexer.nextToken();
        }
    }

    @Override
    protected void parseAssignItemSQLIdentifierExprAndVariant(SQLIdentifierExpr ident) {
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTER) && ident.nameHashCode64() == FnvHash.Constants.RUNNING) {
            String str = ident.getName() + " " + this.lexer.stringVal();
            this.lexer.nextToken();
            ident.setName(str);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            ident.setName(ident.getName() + ' ' + this.lexer.stringVal());
            this.lexer.nextToken();
            while (this.lexer.token() == Token.IDENTIFIER) {
                ident.setName(ident.getName() + ' ' + this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
    }

    @Override
    protected void parseAssignItemSQLIdentifierExpr(SQLExpr sqlExpr) {
        SQLIdentifierExpr identExpr;
        if (sqlExpr instanceof SQLIdentifierExpr && ((identExpr = (SQLIdentifierExpr)sqlExpr).getName().equalsIgnoreCase("et") || identExpr.getName().equalsIgnoreCase("odps")) && this.lexer.token() == Token.IDENTIFIER) {
            SQLExpr expr = this.primary();
            identExpr.setName(identExpr.getName() + ' ' + expr.toString());
        }
    }

    @Override
    protected SQLExpr parseAssignItemOnLiteralFloat(SQLExpr sqlExpr) {
        while (this.lexer.token() == Token.LITERAL_FLOAT && this.lexer.numberString().startsWith(".")) {
            if (sqlExpr instanceof SQLNumberExpr) {
                String numStr = ((SQLNumberExpr)sqlExpr).getLiteral();
                numStr = numStr + this.lexer.numberString();
                sqlExpr = new SQLIdentifierExpr(numStr);
                this.lexer.nextToken();
                continue;
            }
            if (!(sqlExpr instanceof SQLIdentifierExpr)) break;
            String ident = ((SQLIdentifierExpr)sqlExpr).getName();
            ident = ident + this.lexer.numberString();
            sqlExpr = new SQLIdentifierExpr(ident);
            this.lexer.nextToken();
        }
        return sqlExpr;
    }

    @Override
    protected void parseAssignItemOnComma(SQLExpr sqlExpr, SQLAssignItem item, SQLObject parent) {
        if (this.lexer.token() == Token.COMMA && parent instanceof SQLSetStatement) {
            SQLListExpr listExpr = new SQLListExpr();
            listExpr.addItem(sqlExpr);
            sqlExpr.setParent(listExpr);
            do {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.SET && this.dbType == DbType.odps) break;
                SQLExpr listItem = this.expr();
                listItem.setParent(listExpr);
                listExpr.addItem(listItem);
            } while (this.lexer.token() == Token.COMMA);
            item.setValue(listExpr);
        } else {
            item.setValue(sqlExpr);
        }
    }

    public OdpsExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = DbType.odps;
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public OdpsExprParser(String sql, SQLParserFeature ... features) {
        this(new OdpsLexer(sql, features));
        this.lexer.nextToken();
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        String chars = alias.substring(1, alias.length() - 1);
        return new SQLCharExpr(chars);
    }

    @Override
    public SQLSelectItem parseSelectItem() {
        SQLExpr expr;
        if (this.lexer.token() == Token.IDENTIFIER) {
            SQLExprImpl ts;
            String literal;
            String stringVal = this.lexer.stringVal();
            long hash_lower = this.lexer.hashLCase();
            int sourceLine = -1;
            int sourceColumn = -1;
            if (this.lexer.isKeepSourceLocation()) {
                this.lexer.computeRowAndColumn();
                sourceLine = this.lexer.getPosLine();
                sourceColumn = this.lexer.getPosColumn();
            }
            this.lexer.nextTokenComma();
            if (FnvHash.Constants.DATETIME == hash_lower && this.lexer.stringVal().charAt(0) != '`' && (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS)) {
                literal = this.lexer.stringVal();
                this.lexer.nextToken();
                ts = new SQLDateTimeExpr(literal);
                expr = ts;
            } else if (FnvHash.Constants.DATE == hash_lower && this.lexer.stringVal().charAt(0) != '`' && (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS)) {
                literal = this.lexer.stringVal();
                this.lexer.nextToken();
                SQLDateExpr d = new SQLDateExpr(literal);
                expr = d;
            } else if (FnvHash.Constants.TIMESTAMP == hash_lower && this.lexer.stringVal().charAt(0) != '`' && (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS)) {
                literal = this.lexer.stringVal();
                this.lexer.nextToken();
                ts = new SQLTimestampExpr(literal);
                expr = ts;
            } else {
                expr = new SQLIdentifierExpr(stringVal);
                if (this.lexer.token() != Token.COMMA) {
                    expr = this.primaryRest(expr);
                    expr = this.exprRest(expr);
                }
            }
            if (sourceLine != -1) {
                expr.setSource(sourceLine, sourceColumn);
            }
        } else {
            expr = this.expr();
        }
        String alias = null;
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                OdpsUDTFSQLSelectItem selectItem = new OdpsUDTFSQLSelectItem();
                selectItem.setExpr(expr);
                while (true) {
                    alias = this.lexer.stringVal();
                    this.lexer.nextToken();
                    selectItem.getAliasList().add(alias);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                return selectItem;
            }
            alias = this.alias();
        } else {
            alias = this.as();
        }
        SQLSelectItem item = new SQLSelectItem(expr, alias);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            item.addAfterComment(this.lexer.readAndResetComments());
        }
        return item;
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.COLON) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LITERAL_INT && expr instanceof SQLPropertyExpr) {
                SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
                Number integerValue = this.lexer.integerValue();
                this.lexer.nextToken();
                propertyExpr.setName(propertyExpr.getName() + ':' + integerValue.intValue());
                return propertyExpr;
            }
            if ((expr = this.dotRest(expr)) instanceof SQLPropertyExpr) {
                SQLPropertyExpr spe = (SQLPropertyExpr)expr;
                spe.setSplitString(":");
            }
            return expr;
        }
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if ((this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) && expr instanceof SQLCharExpr) {
            SQLCharExpr charExpr = new SQLCharExpr(this.lexer.stringVal());
            this.lexer.nextTokenValue();
            SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("concat", null, expr, charExpr);
            while (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) {
                charExpr = new SQLCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                concat.addArgument(charExpr);
            }
            expr = concat;
        }
        if (this.lexer.token() == Token.LPAREN && expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.TRANSFORM) {
            SQLExternalRecordFormat recordFormat;
            String name = this.lexer.stringVal();
            OdpsTransformExpr transformExpr = new OdpsTransformExpr();
            this.lexer.nextToken();
            List<SQLExpr> inputColumns = transformExpr.getInputColumns();
            this.exprList(inputColumns, transformExpr);
            this.accept(Token.RPAREN);
            if (inputColumns.size() == 2 && inputColumns.get(1) instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)inputColumns.get(1)).getOperator() == SQLBinaryOperator.SubGt) {
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(name);
                for (SQLExpr item : inputColumns) {
                    methodInvokeExpr.addArgument(item);
                }
                return this.primaryRest(methodInvokeExpr);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                recordFormat = this.parseRowFormat();
                transformExpr.setInputRowFormat(recordFormat);
            }
            if (this.lexer.token() == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
                this.lexer.nextToken();
                transformExpr.setUsing(this.expr());
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCES)) {
                this.lexer.nextToken();
                this.exprList(transformExpr.getResources(), transformExpr);
            }
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                List<SQLColumnDefinition> outputColumns = transformExpr.getOutputColumns();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    while (true) {
                        SQLColumnDefinition column = this.parseColumn();
                        outputColumns.add(column);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                } else {
                    SQLColumnDefinition column = new SQLColumnDefinition();
                    column.setName(this.name());
                    outputColumns.add(column);
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                recordFormat = this.parseRowFormat();
                transformExpr.setOutputRowFormat(recordFormat);
            }
            return transformExpr;
        }
        if (expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.NEW) {
            SQLIdentifierExpr ident = (SQLIdentifierExpr)expr;
            OdpsNewExpr newExpr = new OdpsNewExpr();
            if (this.lexer.token() == Token.IDENTIFIER) {
                Lexer.SavePoint mark = this.lexer.mark();
                StringBuilder methodName = new StringBuilder(this.lexer.stringVal());
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case COMMA: 
                    case RPAREN: 
                    case ON: 
                    case WHERE: 
                    case GROUP: 
                    case ORDER: 
                    case INNER: 
                    case JOIN: 
                    case FULL: 
                    case OUTER: 
                    case LEFT: 
                    case RIGHT: 
                    case LATERAL: 
                    case FROM: {
                        return ident;
                    }
                }
                while (this.lexer.token() == Token.DOT) {
                    this.lexer.nextToken();
                    methodName.append('.').append(this.lexer.stringVal());
                    this.lexer.nextToken();
                }
                newExpr.setMethodName(methodName.toString());
                if (this.lexer.token() == Token.LT) {
                    this.lexer.nextToken();
                    while (this.lexer.token() != Token.GT) {
                        SQLDataType paramType = this.parseDataType(false);
                        paramType.setParent(newExpr);
                        newExpr.getTypeParameters().add(paramType);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.GT);
                }
                if (this.lexer.token() == Token.LBRACKET) {
                    this.lexer.nextToken();
                    this.exprList(newExpr.getArguments(), newExpr);
                    this.accept(Token.RBRACKET);
                    if (this.lexer.token() == Token.LBRACKET) {
                        this.lexer.nextToken();
                        this.accept(Token.RBRACKET);
                    }
                    newExpr.setArray(true);
                    if (this.lexer.token() == Token.LBRACE) {
                        this.lexer.nextToken();
                        while (this.lexer.token() != Token.RPAREN) {
                            SQLExpr item = this.expr();
                            newExpr.getInitValues().add(item);
                            item.setParent(newExpr);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RBRACE);
                    }
                    expr = this.lexer.token() == Token.LBRACKET ? this.primaryRest(newExpr) : newExpr;
                } else {
                    this.accept(Token.LPAREN);
                    this.exprList(newExpr.getArguments(), newExpr);
                    this.accept(Token.RPAREN);
                    expr = newExpr;
                }
            } else if (this.lexer.identifierEquals("java") || this.lexer.identifierEquals("com")) {
                SQLName name = this.name();
                StringBuilder strName = new StringBuilder();
                strName.append(ident.getName()).append(' ').append(name.toString());
                if (this.lexer.token() == Token.LT) {
                    this.lexer.nextToken();
                    int i = 0;
                    while (this.lexer.token() != Token.GT) {
                        if (i != 0) {
                            strName.append(", ");
                        }
                        SQLName arg = this.name();
                        strName.append(arg.toString());
                        ++i;
                    }
                    this.lexer.nextToken();
                }
                ident.setName(strName.toString());
            }
        }
        if (expr == null) {
            return null;
        }
        return super.primaryRest(expr);
    }

    @Override
    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.lexer.identifierEquals("REGEXP")) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.RegExp, rightExp, this.dbType);
        }
        return super.relationalRest(expr);
    }

    @Override
    public OdpsSelectParser createSelectParser() {
        return new OdpsSelectParser(this);
    }

    @Override
    protected SQLExpr relationalRestEqeq(SQLExpr expr) {
        SQLExpr rightExp;
        Lexer.SavePoint mark = this.lexer.mark();
        this.lexer.nextToken();
        try {
            if (this.lexer.token() == Token.SEMI) {
                this.lexer.reset(mark);
                return expr;
            }
            rightExp = this.bitOr();
        }
        catch (EOFParserException e) {
            throw new ParserException("EOF, " + expr + "=", e);
        }
        if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
            SQLExpr colonExpr = this.expr();
            rightExp = new SQLBinaryOpExpr(rightExp, SQLBinaryOperator.Assignment, colonExpr, this.dbType);
        }
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Equality, rightExp, this.dbType);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "LAG", "LEAD", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "WM_CONCAT", "STRAGG", "COLLECT_LIST", "COLLECT_SET"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            OdpsExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
        GSONBUILDER = FnvHash.fnv1a_64_lower("GSONBUILDER");
    }
}

