/*
 * Copyright 1999-2012 Alibaba Group.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *      http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.dubbo.governance.web.common.pulltool;

public class RootContextPath {
	
	private String contextPath;
	
	public RootContextPath(String contextPath) {
		this.contextPath = contextPath;
	}

	public String getURI(String uri) {
		String prefix;
		if (contextPath != null && contextPath.length() > 0 && ! "/".equals(contextPath)) {
			prefix = contextPath;
		} else {
			prefix = "";
		}
		if (uri.startsWith("/")) {
			return prefix + uri;
		} else {
			return prefix + "/" + uri;
		}
	}

}
