/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.LoadBalance;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Provider;
import com.alibaba.dubbo.registry.common.util.OverrideUtils;
import com.alibaba.dubbo.registry.common.util.Tool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class Loadbalances
extends Restful {
    @Autowired
    private OverrideService overrideService;
    @Autowired
    private ProviderService providerService;

    public void index(Map<String, Object> context) {
        List loadbalances;
        String service = StringUtils.trimToNull((String)((String)context.get("service")));
        if (service != null && service.length() > 0) {
            loadbalances = OverrideUtils.overridesToLoadBalances((List)this.overrideService.findByService(service));
            loadbalances = OverrideUtils.overridesToLoadBalances((List)this.overrideService.findByService(service));
        } else {
            loadbalances = OverrideUtils.overridesToLoadBalances((List)this.overrideService.findAll());
        }
        context.put("loadbalances", loadbalances);
    }

    public void show(Long id, Map<String, Object> context) {
        LoadBalance loadbalance = OverrideUtils.overrideToLoadBalance((Override)this.overrideService.findById(id));
        context.put("loadbalance", loadbalance);
    }

    public void add(Map<String, Object> context) {
        String service = (String)context.get("service");
        if (service != null && service.length() > 0 && !service.contains("*")) {
            List providerList = this.providerService.findByService(service);
            ArrayList<String> addressList = new ArrayList<String>();
            for (Provider provider : providerList) {
                addressList.add(provider.getUrl().split("://")[1].split("/")[0]);
            }
            context.put("addressList", addressList);
            context.put("service", service);
            context.put("methods", CollectionUtils.sort((List)this.providerService.findMethodsByService(service)));
        } else {
            List serviceList = Tool.sortSimpleName((List)this.providerService.findServices());
            context.put("serviceList", serviceList);
        }
        if (context.get("input") != null) {
            context.put("input", context.get("input"));
        }
    }

    public void edit(Long id, Map<String, Object> context) {
        this.add(context);
        this.show(id, context);
    }

    public boolean create(LoadBalance loadBalance, Map<String, Object> context) {
        if (!this.currentUser.hasServicePrivilege(loadBalance.getService())) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{loadBalance.getService()}));
            return false;
        }
        loadBalance.setUsername((String)context.get("operator"));
        this.overrideService.saveOverride(OverrideUtils.loadBalanceToOverride((LoadBalance)loadBalance));
        return true;
    }

    public boolean update(LoadBalance loadBalance, Map<String, Object> context) {
        if (!this.currentUser.hasServicePrivilege(loadBalance.getService())) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{loadBalance.getService()}));
            return false;
        }
        this.overrideService.updateOverride(OverrideUtils.loadBalanceToOverride((LoadBalance)loadBalance));
        return true;
    }

    public boolean delete(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            LoadBalance lb = OverrideUtils.overrideToLoadBalance((Override)this.overrideService.findById(id));
            if (this.currentUser.hasServicePrivilege(lb.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{lb.getService()}));
            return false;
        }
        for (Long id : ids) {
            this.overrideService.deleteOverride(id);
        }
        return true;
    }
}

