/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.ConsumerService;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.route.OverrideUtils;
import com.alibaba.dubbo.registry.common.util.Tool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;

public class Services
extends Restful {
    @Autowired
    private ProviderService providerService;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private OverrideService overrideService;

    public void index(Map<String, Object> context) {
        String application = (String)context.get("application");
        String address = (String)context.get("address");
        if (context.get("service") == null && context.get("application") == null && context.get("address") == null) {
            context.put("service", "*");
        }
        List providerServices = null;
        List consumerServices = null;
        List overrides = null;
        if (application != null && application.length() > 0) {
            providerServices = this.providerService.findServicesByApplication(application);
            consumerServices = this.consumerService.findServicesByApplication(application);
            overrides = this.overrideService.findByApplication(application);
        } else if (address != null && address.length() > 0) {
            providerServices = this.providerService.findServicesByAddress(address);
            consumerServices = this.consumerService.findServicesByAddress(address);
            overrides = this.overrideService.findByAddress(Tool.getIP((String)address));
        } else {
            providerServices = this.providerService.findServices();
            consumerServices = this.consumerService.findServices();
            overrides = this.overrideService.findAll();
        }
        TreeSet services = new TreeSet();
        if (providerServices != null) {
            services.addAll(providerServices);
        }
        if (consumerServices != null) {
            services.addAll(consumerServices);
        }
        HashMap service2Overrides = new HashMap();
        if (overrides != null && overrides.size() > 0 && services != null && services.size() > 0) {
            for (String s : services) {
                if (overrides == null || overrides.size() <= 0) continue;
                for (Override override : overrides) {
                    ArrayList<Override> serOverrides = new ArrayList<Override>();
                    if (override.isMatch(s, address, application)) {
                        serOverrides.add(override);
                    }
                    Collections.sort(serOverrides, OverrideUtils.OVERRIDE_COMPARATOR);
                    service2Overrides.put(s, serOverrides);
                }
            }
        }
        context.put("providerServices", providerServices);
        context.put("consumerServices", consumerServices);
        context.put("services", services);
        context.put("overrides", service2Overrides);
        String keyword = (String)context.get("keyword");
        if (StringUtils.isNotEmpty((String)keyword) && !"*".equals(keyword)) {
            keyword = keyword.toLowerCase();
            HashSet<String> newList = new HashSet<String>();
            HashSet<String> newProviders = new HashSet<String>();
            HashSet<String> newConsumers = new HashSet<String>();
            for (String o : services) {
                if (o.toLowerCase().toLowerCase().indexOf(keyword) == -1) continue;
                newList.add(o);
            }
            for (String o : providerServices) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newProviders.add(o);
            }
            for (String o : consumerServices) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newConsumers.add(o);
            }
            context.put("services", newList);
            context.put("providerServices", newProviders);
            context.put("consumerServices", newConsumers);
        }
    }

    public boolean shield(Map<String, Object> context) throws Exception {
        return this.mock(context, "force:return null");
    }

    public boolean tolerant(Map<String, Object> context) throws Exception {
        return this.mock(context, "fail:return null");
    }

    public boolean recover(Map<String, Object> context) throws Exception {
        return this.mock(context, "");
    }

    private boolean mock(Map<String, Object> context, String mock) throws Exception {
        String services = (String)context.get("service");
        String application = (String)context.get("application");
        if (services == null || services.length() == 0 || application == null || application.length() == 0) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[0]));
            return false;
        }
        for (String service : SPACE_SPLIT_PATTERN.split(services)) {
            if (this.currentUser.hasServicePrivilege(service)) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        for (String service : SPACE_SPLIT_PATTERN.split(services)) {
            List overrides = this.overrideService.findByServiceAndApplication(service, application);
            if (overrides != null && overrides.size() > 0) {
                for (Override override : overrides) {
                    Map map = StringUtils.parseQueryString((String)override.getParams());
                    if (mock == null || mock.length() == 0) {
                        map.remove("mock");
                    } else {
                        map.put("mock", URL.encode((String)mock));
                    }
                    if (map.size() > 0) {
                        override.setParams(StringUtils.toQueryString((Map)map));
                        override.setEnabled(true);
                        override.setOperator(this.operator);
                        override.setOperatorAddress(this.operatorAddress);
                        this.overrideService.updateOverride(override);
                        continue;
                    }
                    this.overrideService.deleteOverride(override.getId());
                }
                continue;
            }
            if (mock == null || mock.length() <= 0) continue;
            Override override = new Override();
            override.setService(service);
            override.setApplication(application);
            override.setParams("mock=" + URL.encode((String)mock));
            override.setEnabled(true);
            override.setOperator(this.operator);
            override.setOperatorAddress(this.operatorAddress);
            this.overrideService.saveOverride(override);
        }
        return true;
    }
}

