/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.sync.util;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.sync.util.Pair;
import com.alibaba.dubbo.registry.common.domain.Consumer;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Provider;
import com.alibaba.dubbo.registry.common.domain.Route;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class SyncUtils {
    public static final String SERVICE_FILTER_KEY = ".service";
    public static final String ADDRESS_FILTER_KEY = ".address";
    public static final String ID_FILTER_KEY = ".id";

    public static Provider url2Provider(Pair<Long, URL> pair) {
        if (pair == null) {
            return null;
        }
        Long id = (Long)pair.getKey();
        URL url = (URL)pair.getValue();
        if (url == null) {
            return null;
        }
        Provider p = new Provider();
        p.setId(id);
        p.setService(url.getServiceKey());
        p.setAddress(url.getAddress());
        p.setApplication(url.getParameter("application"));
        p.setUrl(url.toIdentityString());
        p.setParameters(url.toParameterString());
        p.setDynamic(url.getParameter("dynamic", true));
        p.setEnabled(url.getParameter("enabled", true));
        p.setWeight(url.getParameter("weight", 100));
        p.setUsername(url.getParameter("owner"));
        return p;
    }

    public static List<Provider> url2ProviderList(Map<Long, URL> ps) {
        ArrayList<Provider> ret = new ArrayList<Provider>();
        for (Map.Entry<Long, URL> entry : ps.entrySet()) {
            ret.add(SyncUtils.url2Provider((Pair)new Pair((Object)entry.getKey(), (Object)entry.getValue())));
        }
        return ret;
    }

    public static Consumer url2Consumer(Pair<Long, URL> pair) {
        if (pair == null) {
            return null;
        }
        Long id = (Long)pair.getKey();
        URL url = (URL)pair.getValue();
        if (null == url) {
            return null;
        }
        Consumer c = new Consumer();
        c.setId(id);
        c.setService(url.getServiceKey());
        c.setAddress(url.getHost());
        c.setApplication(url.getParameter("application"));
        c.setParameters(url.toParameterString());
        return c;
    }

    public static List<Consumer> url2ConsumerList(Map<Long, URL> cs) {
        ArrayList<Consumer> list = new ArrayList<Consumer>();
        if (cs == null) {
            return list;
        }
        for (Map.Entry<Long, URL> entry : cs.entrySet()) {
            list.add(SyncUtils.url2Consumer((Pair)new Pair((Object)entry.getKey(), (Object)entry.getValue())));
        }
        return list;
    }

    public static Route url2Route(Pair<Long, URL> pair) {
        if (pair == null) {
            return null;
        }
        Long id = (Long)pair.getKey();
        URL url = (URL)pair.getValue();
        if (null == url) {
            return null;
        }
        Route r = new Route();
        r.setId(id);
        r.setName(url.getParameter("name"));
        r.setService(url.getServiceKey());
        r.setPriority(url.getParameter("priority", 0));
        r.setEnabled(url.getParameter("enabled", true));
        r.setForce(url.getParameter("force", false));
        r.setRule(url.getParameterAndDecoded("rule"));
        return r;
    }

    public static List<Route> url2RouteList(Map<Long, URL> cs) {
        ArrayList<Route> list = new ArrayList<Route>();
        if (cs == null) {
            return list;
        }
        for (Map.Entry<Long, URL> entry : cs.entrySet()) {
            list.add(SyncUtils.url2Route((Pair)new Pair((Object)entry.getKey(), (Object)entry.getValue())));
        }
        return list;
    }

    public static Override url2Override(Pair<Long, URL> pair) {
        if (pair == null) {
            return null;
        }
        Long id = (Long)pair.getKey();
        URL url = (URL)pair.getValue();
        if (null == url) {
            return null;
        }
        Override o = new Override();
        o.setId(id);
        HashMap parameters = new HashMap(url.getParameters());
        o.setService(url.getServiceKey());
        parameters.remove("interface");
        parameters.remove("group");
        parameters.remove("version");
        parameters.remove("application");
        parameters.remove("category");
        parameters.remove("dynamic");
        parameters.remove("enabled");
        o.setEnabled(url.getParameter("enabled", true));
        String host = url.getHost();
        boolean anyhost = url.getParameter("0.0.0.0", false);
        if (!anyhost || !"0.0.0.0".equals(host)) {
            o.setAddress(url.getAddress());
        }
        o.setApplication(url.getParameter("application", url.getUsername()));
        parameters.remove("version");
        o.setParams(StringUtils.toQueryString(parameters));
        return o;
    }

    public static <SM extends Map<String, Map<Long, URL>>> Map<Long, URL> filterFromCategory(Map<String, SM> urls, Map<String, String> filter) {
        String c = filter.get("category");
        if (c == null) {
            throw new IllegalArgumentException("no category");
        }
        filter.remove("category");
        return SyncUtils.filterFromService((Map)((Map)urls.get(c)), filter);
    }

    public static List<Override> url2OverrideList(Map<Long, URL> cs) {
        ArrayList<Override> list = new ArrayList<Override>();
        if (cs == null) {
            return list;
        }
        for (Map.Entry<Long, URL> entry : cs.entrySet()) {
            list.add(SyncUtils.url2Override((Pair)new Pair((Object)entry.getKey(), (Object)entry.getValue())));
        }
        return list;
    }

    public static Map<Long, URL> filterFromService(Map<String, Map<Long, URL>> urls, Map<String, String> filter) {
        HashMap<Long, URL> ret = new HashMap<Long, URL>();
        if (urls == null) {
            return ret;
        }
        String s = filter.remove(".service");
        if (s == null) {
            for (Map.Entry<String, Map<Long, URL>> entry : urls.entrySet()) {
                SyncUtils.filterFromUrls(entry.getValue(), ret, filter);
            }
        } else {
            Map<Long, URL> map = urls.get(s);
            SyncUtils.filterFromUrls(map, ret, filter);
        }
        return ret;
    }

    static void filterFromUrls(Map<Long, URL> from, Map<Long, URL> to, Map<String, String> filter) {
        if (from == null || from.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, URL> entry : from.entrySet()) {
            URL url = entry.getValue();
            boolean match = true;
            for (Map.Entry<String, String> e : filter.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                if (".address".equals(key)) {
                    if (value.equals(url.getAddress())) continue;
                    match = false;
                    break;
                }
                if (value.equals(url.getParameter(key))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            to.put(entry.getKey(), url);
        }
    }

    public static <SM extends Map<String, Map<Long, URL>>> Pair<Long, URL> filterFromCategory(Map<String, SM> urls, String category, Long id) {
        Map services = (Map)urls.get(category);
        if (services == null) {
            return null;
        }
        for (Map.Entry e1 : services.entrySet()) {
            Map u = (Map)e1.getValue();
            if (!u.containsKey(id)) continue;
            return new Pair((Object)id, u.get(id));
        }
        return null;
    }
}

