/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.route;

import com.alibaba.dubbo.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParseUtils {
    public static String METHOD_SPLIT = ",";
    private static Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\s*\\{?\\s*([\\._0-9a-zA-Z]+)\\s*\\}?");
    private static Pattern QUERY_PATTERN = Pattern.compile("([&=]?)\\s*([^&=\\s]+)");
    private static final ConcurrentMap<String, Pattern> REPLACE_PARAMETER_PATTERNS = new ConcurrentHashMap();

    private ParseUtils() {
    }

    public static String interpolate(String expression, Map<String, String> params) {
        if (expression == null || expression.length() == 0) {
            throw new IllegalArgumentException("glob pattern is empty!");
        }
        if (expression.indexOf(36) < 0) {
            return expression;
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String value;
            String key = matcher.group(1);
            String string = value = params == null ? null : params.get(key);
            if (value == null) {
                value = "";
            }
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static List<String> interpolate(List<String> expressions, Map<String, String> params) {
        ArrayList<String> ret = new ArrayList<String>();
        if (null == expressions || expressions.isEmpty()) {
            return ret;
        }
        for (String expr : expressions) {
            ret.add(ParseUtils.interpolate((String)expr, params));
        }
        return ret;
    }

    public static boolean isMatchGlobPattern(String pattern, String value) {
        if ("*".equals(pattern)) {
            return true;
        }
        if (!(pattern != null && pattern.length() != 0 || value != null && value.length() != 0)) {
            return true;
        }
        if (pattern == null || pattern.length() == 0 || value == null || value.length() == 0) {
            return false;
        }
        int i = pattern.lastIndexOf(42);
        if (i == -1) {
            return value.equals(pattern);
        }
        if (i == pattern.length() - 1) {
            return value.startsWith(pattern.substring(0, i));
        }
        if (i == 0) {
            return value.endsWith(pattern.substring(i + 1));
        }
        String prefix = pattern.substring(0, i);
        String suffix = pattern.substring(i + 1);
        return value.startsWith(prefix) && value.endsWith(suffix);
    }

    public static boolean isMatchGlobPatternsNeedInterpolate(Collection<String> patternsNeedInterpolate, Map<String, String> interpolateParams, String value) {
        if (patternsNeedInterpolate != null && !patternsNeedInterpolate.isEmpty()) {
            for (String patternNeedItp : patternsNeedInterpolate) {
                String pattern;
                if (StringUtils.isEmpty((String)patternNeedItp) || !ParseUtils.isMatchGlobPattern((String)(pattern = ParseUtils.interpolate((String)patternNeedItp, interpolateParams)), (String)value)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> filterByGlobPattern(String pattern, Collection<String> values) {
        HashSet<String> ret = new HashSet<String>();
        if (pattern == null || values == null) {
            return ret;
        }
        for (String v : values) {
            if (!ParseUtils.isMatchGlobPattern((String)pattern, (String)v)) continue;
            ret.add(v);
        }
        return ret;
    }

    public static Set<String> filterByGlobPattern(Collection<String> patterns, Collection<String> values) {
        HashSet<String> ret = new HashSet<String>();
        if (null == patterns || values == null || patterns.isEmpty() || values.isEmpty()) {
            return ret;
        }
        for (String p : patterns) {
            for (String v : values) {
                if (!ParseUtils.isMatchGlobPattern((String)p, (String)v)) continue;
                ret.add(v);
            }
        }
        return ret;
    }

    public static boolean hasIntersection(String glob1, String glob2) {
        if (null == glob1 || null == glob2) {
            return false;
        }
        if (glob1.contains("*") && glob2.contains("*")) {
            int index1 = glob1.indexOf("*");
            int index2 = glob2.indexOf("*");
            String s11 = glob1.substring(0, index1);
            String s12 = glob1.substring(index1 + 1, glob1.length());
            String s21 = glob2.substring(0, index2);
            String s22 = glob2.substring(index2 + 1, glob2.length());
            if (!s11.startsWith(s21) && !s21.startsWith(s11)) {
                return false;
            }
            return s12.endsWith(s22) || s22.endsWith(s12);
        }
        if (glob1.contains("*")) {
            return ParseUtils.isMatchGlobPattern((String)glob1, (String)glob2);
        }
        if (glob2.contains("*")) {
            return ParseUtils.isMatchGlobPattern((String)glob2, (String)glob1);
        }
        return glob1.equals(glob2);
    }

    public static Map<String, String> parseQuery(String keyPrefix, String query) {
        if (query == null) {
            return new HashMap<String, String>();
        }
        if (keyPrefix == null) {
            keyPrefix = "";
        }
        Matcher matcher = QUERY_PATTERN.matcher(query);
        HashMap<String, String> routeQuery = new HashMap<String, String>();
        String key = null;
        while (matcher.find()) {
            String separator = matcher.group(1);
            String content = matcher.group(2);
            if (separator == null || separator.length() == 0 || "&".equals(separator)) {
                if (key != null) {
                    throw new IllegalStateException("Illegal query string \"" + query + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".");
                }
                key = content;
                continue;
            }
            if ("=".equals(separator)) {
                if (key == null) {
                    throw new IllegalStateException("Illegal query string \"" + query + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".");
                }
                routeQuery.put(keyPrefix + key, content);
                key = null;
                continue;
            }
            if (key != null) continue;
            throw new IllegalStateException("Illegal query string \"" + query + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".");
        }
        return routeQuery;
    }

    public static Map<String, String> parseQuery(String query) {
        return ParseUtils.parseQuery((String)"", (String)query);
    }

    public static String replaceParameter(String query, String key, String value) {
        if (query == null || query.length() == 0) {
            return key + "=" + value;
        }
        if (query.indexOf(key + "=") == -1) {
            return query + "&" + key + "=" + value;
        }
        Pattern pattern = (Pattern)REPLACE_PARAMETER_PATTERNS.get(key);
        if (pattern == null) {
            pattern = Pattern.compile(key.replaceAll("([^(_0-9A-Za-z)])", "\\\\$0") + "=[^&]+");
        }
        Matcher matcher = pattern.matcher(query);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, (key + "=" + value).replace("$", "\\$"));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String appendParamToUri(String uri, String name, String value) {
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)value)) {
            return uri;
        }
        uri = uri.indexOf(63) != -1 ? uri + "&" + name + "=" + value : uri + "?" + name + "=" + value;
        return uri;
    }

    public static String appendParamsToUri(String uri, Map<String, String> params) {
        StringBuilder buf = new StringBuilder(uri);
        boolean first = uri.indexOf(63) < 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) continue;
            if (first) {
                buf.append("?");
                first = false;
            } else {
                buf.append("&");
            }
            buf.append(key);
            buf.append("=");
            buf.append(value);
        }
        return buf.toString();
    }

    public static boolean matchEndStarPattern(String value, String pattern) {
        if (!pattern.endsWith("*")) {
            throw new IllegalArgumentException("not end star pattern!");
        }
        String perfix = pattern.substring(0, pattern.length() - 1);
        return value.startsWith(perfix);
    }
}

