/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.util;

import java.nio.ByteBuffer;

public class ByteBufferUtils {
    public static final ByteBuffer increaseBufferCapatity(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        int capacity = byteBuffer.capacity() + 32768;
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity can't be negative");
        }
        ByteBuffer result = byteBuffer.isDirect() ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        result.order(byteBuffer.order());
        byteBuffer.flip();
        result.put(byteBuffer);
        return result;
    }

    public static final void flip(ByteBuffer[] buffers) {
        if (buffers == null) {
            return;
        }
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            buffer.flip();
        }
    }

    public static final ByteBuffer gather(ByteBuffer[] buffers) {
        if (buffers == null || buffers.length == 0) {
            return null;
        }
        ByteBuffer result = ByteBuffer.allocate(ByteBufferUtils.remaining(buffers));
        result.order(buffers[0].order());
        for (int i = 0; i < buffers.length; ++i) {
            if (buffers[i] == null) continue;
            result.put(buffers[i]);
        }
        result.flip();
        return result;
    }

    public static final int remaining(ByteBuffer[] buffers) {
        if (buffers == null) {
            return 0;
        }
        int remaining = 0;
        for (int i = 0; i < buffers.length; ++i) {
            if (buffers[i] == null) continue;
            remaining += buffers[i].remaining();
        }
        return remaining;
    }

    public static final void clear(ByteBuffer[] buffers) {
        if (buffers == null) {
            return;
        }
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            buffer.clear();
        }
    }

    public static final String toHex(byte b) {
        return "" + "0123456789ABCDEF".charAt(0xF & b >> 4) + "0123456789ABCDEF".charAt(b & 0xF);
    }

    public static final int indexOf(ByteBuffer buffer, ByteBuffer pattern) {
        if (pattern == null || buffer == null) {
            return -1;
        }
        int n = buffer.remaining();
        int m = pattern.remaining();
        int patternPos = pattern.position();
        int bufferPos = buffer.position();
        if (n < m) {
            return -1;
        }
        for (int s = 0; s <= n - m; ++s) {
            boolean match = true;
            for (int i = 0; i < m; ++i) {
                if (buffer.get(s + i + bufferPos) == pattern.get(patternPos + i)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return bufferPos + s;
        }
        return -1;
    }

    public static final int indexOf(ByteBuffer buffer, ByteBuffer pattern, int offset) {
        int m;
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be greater than 0");
        }
        if (pattern == null || buffer == null) {
            return -1;
        }
        int patternPos = pattern.position();
        int n = buffer.remaining();
        if (n < (m = pattern.remaining())) {
            return -1;
        }
        if (offset < buffer.position() || offset > buffer.limit()) {
            return -1;
        }
        for (int s = 0; s <= n - m; ++s) {
            boolean match = true;
            for (int i = 0; i < m; ++i) {
                if (buffer.get(s + i + offset) == pattern.get(patternPos + i)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return offset + s;
        }
        return -1;
    }

    public static final boolean hasRemaining(ByteBuffer[] buffers) {
        if (buffers == null) {
            return false;
        }
        for (int i = 0; i < buffers.length; ++i) {
            if (buffers[i] == null || !buffers[i].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    public static final int uByte(byte b) {
        return b & 0xFF;
    }
}

