/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.util.bcel.Constants;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.ElementValue;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;

public class AnnotationEntry
implements Constants {
    private final int type_index;
    private final ConstantPool constant_pool;
    private List<ElementValuePair> element_value_pairs;

    public static AnnotationEntry read(DataInputStream file, ConstantPool constant_pool) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(file.readUnsignedShort(), constant_pool);
        int num_element_value_pairs = file.readUnsignedShort();
        annotationEntry.element_value_pairs = new ArrayList<ElementValuePair>();
        for (int i = 0; i < num_element_value_pairs; ++i) {
            annotationEntry.element_value_pairs.add(new ElementValuePair(file.readUnsignedShort(), ElementValue.readElementValue(file, constant_pool), constant_pool));
        }
        return annotationEntry;
    }

    public AnnotationEntry(int type_index, ConstantPool constant_pool) {
        this.type_index = type_index;
        this.constant_pool = constant_pool;
    }

    public String getAnnotationType() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return c.getBytes();
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.element_value_pairs.toArray(new ElementValuePair[this.element_value_pairs.size()]);
    }
}

