/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.kestrel;

import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.text.TextGetCommand;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.transcoders.TranscoderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KestrelGetCommand
extends TextGetCommand {
    public static final TranscoderUtils transcoderUtils = new TranscoderUtils(false);

    public KestrelGetCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch, Transcoder<?> transcoder) {
        super(key, keyBytes, cmdType, latch);
        this.transcoder = transcoder;
    }

    @Override
    public void dispatch() {
        if (this.returnValues.size() == 0) {
            if (!this.wasFirst) {
                this.decodeError();
            } else {
                this.countDownLatch();
            }
        } else {
            byte[] data;
            CachedData value = (CachedData)this.returnValues.values().iterator().next();
            if (!this.transcoder.isPrimitiveAsString() && (data = value.getData()).length >= 4) {
                byte[] flagBytes = new byte[4];
                System.arraycopy(data, 0, flagBytes, 0, 4);
                byte[] realData = new byte[data.length - 4];
                System.arraycopy(data, 4, realData, 0, data.length - 4);
                int flag = transcoderUtils.decodeInt(flagBytes);
                value.setFlag(flag);
                value.setData(realData);
                value.setCapacity(realData.length);
            }
            this.setResult(value);
            this.countDownLatch();
        }
    }
}

