/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.transcoders;

import java.io.UnsupportedEncodingException;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.PrimitiveTypeTranscoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTranscoder
extends PrimitiveTypeTranscoder<String> {
    private String charset = "UTF-8";
    public static final int STRING_FLAG = 0;

    public StringTranscoder(String charset) {
        this.charset = charset;
    }

    public StringTranscoder() {
        this("UTF-8");
    }

    @Override
    public String decode(CachedData d) {
        if (d.getFlag() == 0) {
            String rv = null;
            try {
                if (d.getData() != null) {
                    rv = new String(d.getData(), this.charset);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return rv;
        }
        throw new RuntimeException("Decode String error");
    }

    @Override
    public CachedData encode(String o) {
        byte[] b = null;
        try {
            b = o.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new CachedData(0, b);
    }
}

