/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.statistics.impl;

import com.google.code.yanf4j.statistics.Statistics;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleStatistics
implements Statistics {
    private boolean started = false;
    private double receiveThroughputLimit = -1.0;
    private double sendThroughputLimit = -1.0;
    private long startTime;
    private long stopTime = -1L;
    private AtomicLong recvMessageCount = new AtomicLong();
    private AtomicLong recvMessageTotalSize = new AtomicLong();
    private AtomicLong writeMessageCount = new AtomicLong();
    private AtomicLong writeMessageTotalSize = new AtomicLong();
    private AtomicLong processMessageCount = new AtomicLong();
    private AtomicLong acceptCount = new AtomicLong();
    private AtomicLong processMessageTotalTime = new AtomicLong();

    public boolean isStatistics() {
        return this.started;
    }

    public synchronized void reset() {
        if (this.started) {
            throw new IllegalStateException();
        }
        this.stopTime = -1L;
        this.startTime = -1L;
        this.recvMessageCount.set(0L);
        this.recvMessageTotalSize.set(0L);
        this.writeMessageCount.set(0L);
        this.writeMessageTotalSize.set(0L);
        this.processMessageCount.set(0L);
        this.processMessageTotalTime.set(0L);
        this.acceptCount.set(0L);
    }

    public void setReceiveThroughputLimit(double receivePacketRate) {
        this.receiveThroughputLimit = receivePacketRate;
    }

    public boolean isReceiveOverFlow() {
        if (this.getReceiveThroughputLimit() < 0.0) {
            return false;
        }
        return this.getReceiveBytesPerSecond() > this.getReceiveThroughputLimit();
    }

    public boolean isSendOverFlow() {
        if (this.getSendThroughputLimit() < 0.0) {
            return false;
        }
        return this.getSendBytesPerSecond() > this.getSendThroughputLimit();
    }

    public double getSendThroughputLimit() {
        return this.sendThroughputLimit;
    }

    public void setSendThroughputLimit(double sendThroughputLimit) {
        this.sendThroughputLimit = sendThroughputLimit;
    }

    public final double getReceiveThroughputLimit() {
        return this.receiveThroughputLimit;
    }

    public synchronized void restart() {
        this.stop();
        this.reset();
        this.start();
    }

    public long getStartedTime() {
        return this.startTime;
    }

    public double getProcessedMessageAverageTime() {
        return this.processMessageCount.get() == 0L ? 0.0 : (double)this.processMessageTotalTime.get() / (double)this.processMessageCount.get();
    }

    public long getProcessedMessageCount() {
        return this.processMessageCount.get();
    }

    public void statisticsProcess(long n) {
        if (!this.started) {
            return;
        }
        if (n < 0L) {
            return;
        }
        this.processMessageTotalTime.addAndGet(n);
        this.processMessageCount.incrementAndGet();
    }

    public synchronized void start() {
        this.startTime = System.currentTimeMillis();
        this.started = true;
    }

    public synchronized void stop() {
        this.stopTime = System.currentTimeMillis();
        this.started = false;
    }

    public void statisticsRead(long n) {
        if (!this.started) {
            return;
        }
        if (n <= 0L) {
            return;
        }
        this.recvMessageCount.incrementAndGet();
        this.recvMessageTotalSize.addAndGet(n);
    }

    public long getRecvMessageCount() {
        return this.recvMessageCount.get();
    }

    public long getRecvMessageTotalSize() {
        return this.recvMessageTotalSize.get();
    }

    public long getWriteMessageCount() {
        return this.writeMessageCount.get();
    }

    public long getWriteMessageTotalSize() {
        return this.writeMessageTotalSize.get();
    }

    public void statisticsWrite(long n) {
        if (!this.started) {
            return;
        }
        if (n <= 0L) {
            return;
        }
        this.writeMessageCount.incrementAndGet();
        this.writeMessageTotalSize.addAndGet(n);
    }

    public long getRecvMessageAverageSize() {
        return this.recvMessageCount.get() == 0L ? 0L : this.recvMessageTotalSize.get() / this.recvMessageCount.get();
    }

    public double getRecvMessageCountPerSecond() {
        long duration = this.stopTime == -1L ? System.currentTimeMillis() - this.startTime : this.stopTime - this.startTime;
        return duration == 0L ? 0.0 : (double)this.recvMessageCount.get() * 1000.0 / (double)duration;
    }

    public double getWriteMessageCountPerSecond() {
        long duration = this.stopTime == -1L ? System.currentTimeMillis() - this.startTime : this.stopTime - this.startTime;
        return duration == 0L ? 0.0 : (double)this.writeMessageCount.get() * 1000.0 / (double)duration;
    }

    public long getWriteMessageAverageSize() {
        return this.writeMessageCount.get() == 0L ? 0L : this.writeMessageTotalSize.get() / this.writeMessageCount.get();
    }

    public double getAcceptCountPerSecond() {
        long duration = this.stopTime == -1L ? System.currentTimeMillis() - this.startTime : this.stopTime - this.startTime;
        return duration == 0L ? 0.0 : (double)this.acceptCount.get() * 1000.0 / (double)duration;
    }

    public double getReceiveBytesPerSecond() {
        long duration = this.stopTime == -1L ? System.currentTimeMillis() - this.startTime : this.stopTime - this.startTime;
        return duration == 0L ? 0.0 : (double)this.recvMessageTotalSize.get() * 1000.0 / (double)duration;
    }

    public double getSendBytesPerSecond() {
        long duration = this.stopTime == -1L ? System.currentTimeMillis() - this.startTime : this.stopTime - this.startTime;
        return duration == 0L ? 0.0 : (double)this.writeMessageTotalSize.get() * 1000.0 / (double)duration;
    }

    public void statisticsAccept() {
        if (!this.started) {
            return;
        }
        this.acceptCount.incrementAndGet();
    }
}

