/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.monitor.simple;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.container.Container;
import com.alibaba.dubbo.container.spring.SpringContainer;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.RegistryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RegistryContainer
implements Container {
    public static final String REGISTRY_ADDRESS = "dubbo.registry.address";
    private final Set<String> applications = new ConcurrentHashSet();
    private final Map<String, Set<String>> providerServiceApplications = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> providerApplicationServices = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> consumerServiceApplications = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> consumerApplicationServices = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> services = new ConcurrentHashSet();
    private final Map<String, List<URL>> serviceProviders = new ConcurrentHashMap<String, List<URL>>();
    private final Map<String, List<URL>> serviceConsumers = new ConcurrentHashMap<String, List<URL>>();
    private RegistryService registry;
    private static RegistryContainer INSTANCE = null;

    public RegistryContainer() {
        INSTANCE = this;
    }

    public static RegistryContainer getInstance() {
        if (INSTANCE == null) {
            ExtensionLoader.getExtensionLoader(Container.class).getExtension("registry");
        }
        return INSTANCE;
    }

    public RegistryService getRegistry() {
        return this.registry;
    }

    public Set<String> getApplications() {
        return Collections.unmodifiableSet(this.applications);
    }

    public Set<String> getDependencies(String application, boolean reverse) {
        if (reverse) {
            HashSet<String> dependencies = new HashSet<String>();
            Set<String> services = this.providerApplicationServices.get(application);
            if (services != null && services.size() > 0) {
                for (String service : services) {
                    Set<String> applications = this.consumerServiceApplications.get(service);
                    if (applications == null || applications.size() <= 0) continue;
                    dependencies.addAll(applications);
                }
            }
            return dependencies;
        }
        HashSet<String> dependencies = new HashSet<String>();
        Set<String> services = this.consumerApplicationServices.get(application);
        if (services != null && services.size() > 0) {
            for (String service : services) {
                Set<String> applications = this.providerServiceApplications.get(service);
                if (applications == null || applications.size() <= 0) continue;
                dependencies.addAll(applications);
            }
        }
        return dependencies;
    }

    public Set<String> getServices() {
        return Collections.unmodifiableSet(this.services);
    }

    public Map<String, List<URL>> getServiceProviders() {
        return Collections.unmodifiableMap(this.serviceProviders);
    }

    public List<URL> getProvidersByService(String service) {
        List<URL> urls = this.serviceProviders.get(service);
        return urls == null ? null : Collections.unmodifiableList(urls);
    }

    public List<URL> getProvidersByHost(String host) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (host != null && host.length() > 0) {
            for (List<URL> providers : this.serviceProviders.values()) {
                for (URL url : providers) {
                    if (!host.equals(url.getHost())) continue;
                    urls.add(url);
                }
            }
        }
        return urls;
    }

    public List<URL> getProvidersByApplication(String application) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (application != null && application.length() > 0) {
            for (List<URL> providers : this.serviceProviders.values()) {
                for (URL url : providers) {
                    if (!application.equals(url.getParameter("application"))) continue;
                    urls.add(url);
                }
            }
        }
        return urls;
    }

    public Set<String> getHosts() {
        HashSet<String> addresses = new HashSet<String>();
        for (List<URL> providers : this.serviceProviders.values()) {
            for (URL url : providers) {
                addresses.add(url.getHost());
            }
        }
        for (List<URL> providers : this.serviceConsumers.values()) {
            for (URL url : providers) {
                addresses.add(url.getHost());
            }
        }
        return addresses;
    }

    public Map<String, List<URL>> getServiceConsumers() {
        return Collections.unmodifiableMap(this.serviceConsumers);
    }

    public List<URL> getConsumersByService(String service) {
        List<URL> urls = this.serviceConsumers.get(service);
        return urls == null ? null : Collections.unmodifiableList(urls);
    }

    public List<URL> getConsumersByHost(String host) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (host != null && host.length() > 0) {
            for (List<URL> consumers : this.serviceConsumers.values()) {
                for (URL url : consumers) {
                    if (!host.equals(url.getHost())) continue;
                    urls.add(url);
                }
            }
        }
        return Collections.unmodifiableList(urls);
    }

    public List<URL> getConsumersByApplication(String application) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (application != null && application.length() > 0) {
            for (List<URL> consumers : this.serviceConsumers.values()) {
                for (URL url : consumers) {
                    if (!application.equals(url.getParameter("application"))) continue;
                    urls.add(url);
                }
            }
        }
        return urls;
    }

    public void start() {
        String url = ConfigUtils.getProperty((String)REGISTRY_ADDRESS);
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("Please set java start argument: -Ddubbo.registry.address=zookeeper://127.0.0.1:2181");
        }
        this.registry = (RegistryService)SpringContainer.getContext().getBean("registryService");
        URL subscribeUrl = new URL("admin", NetUtils.getLocalHost(), 0, "", new String[]{"interface", "*", "group", "*", "version", "*", "classifier", "*", "category", "providers,consumers", "check", String.valueOf(false)});
        this.registry.subscribe(subscribeUrl, new NotifyListener(){

            public void notify(List<URL> urls) {
                if (urls == null || urls.size() == 0) {
                    return;
                }
                HashMap<String, ArrayList<URL>> proivderMap = new HashMap<String, ArrayList<URL>>();
                HashMap<String, ArrayList<URL>> consumerMap = new HashMap<String, ArrayList<URL>>();
                for (URL url : urls) {
                    Set applicationServices;
                    Set serviceApplications;
                    List<Object> list;
                    String application = url.getParameter("application");
                    if (application != null && application.length() > 0) {
                        RegistryContainer.this.applications.add(application);
                    }
                    String service = url.getServiceInterface();
                    RegistryContainer.this.services.add(service);
                    String category = url.getParameter("category", "providers");
                    if ("providers".equals(category)) {
                        if ("empty".equals(url.getProtocol())) {
                            RegistryContainer.this.serviceProviders.remove(service);
                            continue;
                        }
                        list = (ArrayList<URL>)proivderMap.get(service);
                        if (list == null) {
                            list = new ArrayList<URL>();
                            proivderMap.put(service, (ArrayList<URL>)list);
                        }
                        list.add(url);
                        if (application == null || application.length() <= 0) continue;
                        serviceApplications = (Set)RegistryContainer.this.providerServiceApplications.get(service);
                        if (serviceApplications == null) {
                            RegistryContainer.this.providerServiceApplications.put(service, new ConcurrentHashSet());
                            serviceApplications = (Set)RegistryContainer.this.providerServiceApplications.get(service);
                        }
                        serviceApplications.add(application);
                        applicationServices = (Set)RegistryContainer.this.providerApplicationServices.get(application);
                        if (applicationServices == null) {
                            RegistryContainer.this.providerApplicationServices.put(application, new ConcurrentHashSet());
                            applicationServices = (Set)RegistryContainer.this.providerApplicationServices.get(application);
                        }
                        applicationServices.add(service);
                        continue;
                    }
                    if (!"consumers".equals(category)) continue;
                    if ("empty".equals(url.getProtocol())) {
                        RegistryContainer.this.serviceConsumers.remove(service);
                        continue;
                    }
                    list = (List)consumerMap.get(service);
                    if (list == null) {
                        list = new ArrayList();
                        consumerMap.put(service, (ArrayList<URL>)list);
                    }
                    list.add(url);
                    if (application == null || application.length() <= 0) continue;
                    serviceApplications = (Set)RegistryContainer.this.consumerServiceApplications.get(service);
                    if (serviceApplications == null) {
                        RegistryContainer.this.consumerServiceApplications.put(service, new ConcurrentHashSet());
                        serviceApplications = (Set)RegistryContainer.this.consumerServiceApplications.get(service);
                    }
                    serviceApplications.add(application);
                    applicationServices = (Set)RegistryContainer.this.consumerApplicationServices.get(application);
                    if (applicationServices == null) {
                        RegistryContainer.this.consumerApplicationServices.put(application, new ConcurrentHashSet());
                        applicationServices = (Set)RegistryContainer.this.consumerApplicationServices.get(application);
                    }
                    applicationServices.add(service);
                }
                if (proivderMap != null && proivderMap.size() > 0) {
                    RegistryContainer.this.serviceProviders.putAll(proivderMap);
                }
                if (consumerMap != null && consumerMap.size() > 0) {
                    RegistryContainer.this.serviceConsumers.putAll(consumerMap);
                }
            }
        });
    }

    public void stop() {
    }
}

