/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.monitor.simple.pages;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.container.page.Menu;
import com.alibaba.dubbo.container.page.Page;
import com.alibaba.dubbo.container.page.PageHandler;
import com.alibaba.dubbo.monitor.simple.RegistryContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Menu(name="Hosts", desc="Show provider and consumer hosts", order=3000)
public class HostsPageHandler
implements PageHandler {
    public Page handle(URL url) {
        ArrayList rows = new ArrayList();
        Set<String> hosts = RegistryContainer.getInstance().getHosts();
        int providersCount = 0;
        int consumersCount = 0;
        if (hosts != null && hosts.size() > 0) {
            for (String host : hosts) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(NetUtils.getHostName((String)host) + "/" + host);
                List<URL> providers = RegistryContainer.getInstance().getProvidersByHost(host);
                List<URL> consumers = RegistryContainer.getInstance().getConsumersByHost(host);
                if (providers != null && providers.size() > 0 || consumers != null && consumers.size() > 0) {
                    URL provider = providers != null && providers.size() > 0 ? providers.iterator().next() : consumers.iterator().next();
                    row.add(provider.getParameter("application", ""));
                    row.add(provider.getParameter("owner", "") + (provider.hasParameter("organization") ? " (" + provider.getParameter("organization") + ")" : ""));
                } else {
                    row.add("");
                    row.add("");
                }
                int proviedSize = providers == null ? 0 : providers.size();
                providersCount += proviedSize;
                row.add(proviedSize == 0 ? "<font color=\"blue\">No provider</font>" : "<a href=\"providers.html?host=" + host + "\">Providers(" + proviedSize + ")</a>");
                int consumersSize = consumers == null ? 0 : consumers.size();
                consumersCount += consumersSize;
                row.add(consumersSize == 0 ? "<font color=\"blue\">No consumer</font>" : "<a href=\"consumers.html?host=" + host + "\">Consumers(" + consumersSize + ")</a>");
                rows.add(row);
            }
        }
        return new Page("Hosts", "Hosts (" + rows.size() + ")", new String[]{"Host Name/IP:", "Application", "Owner", "Providers(" + providersCount + ")", "Consumers(" + consumersCount + ")"}, rows);
    }
}

