/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

public class ScriptException
extends Exception {
    private static final long serialVersionUID = 2L;
    private final String fileName;
    private final int lineNumber;
    private final int columnNumber;

    public ScriptException(Exception exception) {
        super(exception);
        this.fileName = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public ScriptException(String message) {
        this(message, null, -1, -1);
    }

    public ScriptException(String message, String fileName, int lineNumber) {
        this(message, fileName, lineNumber, -1);
    }

    public ScriptException(String message, String fileName, int lineNumber, int columnNumber) {
        super(message);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.getMessage());
        if (this.fileName != null) {
            buffer.append("in: " + this.fileName);
        }
        if (this.lineNumber != -1) {
            buffer.append(" at line no: " + this.lineNumber);
        }
        if (this.columnNumber != -1) {
            buffer.append(" at column number: " + this.columnNumber);
        }
        return buffer.toString();
    }
}

