/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.nio.AbstractNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.DebugPoint;

public final class TCPNIOAsyncQueueWriter
extends AbstractNIOAsyncQueueWriter {
    public TCPNIOAsyncQueueWriter(NIOTransport transport) {
        super(transport);
    }

    @Override
    protected AsyncWriteQueueRecord createRecord(Connection connection, Buffer message, Future<WriteResult<Buffer, SocketAddress>> future, WriteResult<Buffer, SocketAddress> currentResult, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, SocketAddress dstAddress, boolean isEmptyRecord) {
        return TCPNIOQueueRecord.create(connection, message, future, currentResult, completionHandler, dstAddress, isEmptyRecord);
    }

    @Override
    protected int write0(NIOConnection connection, AsyncWriteQueueRecord queueRecord) throws IOException {
        int written;
        WriteResult currentResult = (WriteResult)queueRecord.getCurrentResult();
        Buffer buffer = queueRecord.getMessage();
        int oldPos = buffer.position();
        int bufferSize = buffer.remaining();
        if (bufferSize == 0) {
            written = 0;
        } else {
            TCPNIOTransport.DirectByteBufferRecord directByteBufferRecord = TCPNIOTransport.obtainDirectByteBuffer(bufferSize);
            ByteBuffer directByteBuffer = directByteBufferRecord.strongRef;
            SocketChannel socketChannel = (SocketChannel)connection.getChannel();
            TCPNIOAsyncQueueWriter.fillByteBuffer(buffer, 0, bufferSize, directByteBuffer);
            written = TCPNIOTransport.flushByteBuffer(socketChannel, directByteBuffer);
            TCPNIOTransport.releaseDirectByteBuffer(directByteBufferRecord);
        }
        if (written > 0) {
            buffer.position(oldPos + written);
        }
        ((TCPNIOConnection)connection).onWrite(buffer, written);
        if (currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
            currentResult.setDstAddress(connection.getPeerAddress());
        }
        return written;
    }

    private static void fillByteBuffer(Buffer src, int offset, int size, ByteBuffer dstByteBuffer) {
        dstByteBuffer.limit(size);
        int oldPos = src.position();
        src.position(oldPos + offset);
        src.get(dstByteBuffer);
        dstByteBuffer.position(0);
        src.position(oldPos);
    }

    @Override
    protected final void onReadyToWrite(Connection connection) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        nioConnection.enableIOEvent(IOEvent.WRITE);
    }

    private static final class TCPNIOQueueRecord
    extends AsyncWriteQueueRecord {
        private static final ThreadCache.CachedTypeIndex<TCPNIOQueueRecord> CACHE_IDX = ThreadCache.obtainIndex(TCPNIOQueueRecord.class, 2);

        public static AsyncWriteQueueRecord create(Connection connection, Buffer message, Future future, WriteResult currentResult, CompletionHandler completionHandler, Object dstAddress, boolean isEmptyRecord) {
            TCPNIOQueueRecord asyncWriteQueueRecord = ThreadCache.takeFromCache(CACHE_IDX);
            if (asyncWriteQueueRecord != null) {
                asyncWriteQueueRecord.isRecycled = false;
                asyncWriteQueueRecord.set(connection, message, future, currentResult, completionHandler, dstAddress, isEmptyRecord);
                return asyncWriteQueueRecord;
            }
            return new TCPNIOQueueRecord(connection, message, future, currentResult, completionHandler, dstAddress, isEmptyRecord);
        }

        public TCPNIOQueueRecord(Connection connection, Buffer message, Future future, WriteResult currentResult, CompletionHandler completionHandler, Object dstAddress, boolean isEmptyRecord) {
            super(connection, message, future, currentResult, completionHandler, dstAddress, isEmptyRecord);
        }

        @Override
        public void recycle() {
            this.checkRecycled();
            this.reset();
            this.isRecycled = true;
            if (Grizzly.isTrackingThreadCache()) {
                this.recycleTrack = new DebugPoint(new Exception(), Thread.currentThread().getName());
            }
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }
}

