/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.monitor.simple.pages;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.container.page.Page;
import com.alibaba.dubbo.container.page.PageHandler;
import com.alibaba.dubbo.monitor.simple.RegistryContainer;
import java.util.ArrayList;
import java.util.List;

public class ConsumersPageHandler
implements PageHandler {
    public Page handle(URL url) {
        String service = url.getParameter("service");
        String host = url.getParameter("host");
        String application = url.getParameter("application");
        if (service != null && service.length() > 0) {
            ArrayList rows = new ArrayList();
            List<URL> consumers = RegistryContainer.getInstance().getConsumersByService(service);
            if (consumers != null && consumers.size() > 0) {
                for (URL u : consumers) {
                    ArrayList<String> row = new ArrayList<String>();
                    String s = u.toFullString();
                    row.add(s.replace("&", "&amp;"));
                    row.add("<button onclick=\"if(confirm('Confirm unsubscribe consumer?')){window.location.href='unsubscribe.html?service=" + service + "&consumer=" + URL.encode((String)s) + "';}\">Unsubscribe</button>");
                    rows.add(row);
                }
            }
            return new Page("<a href=\"services.html\">Services</a> &gt; " + service + " &gt; <a href=\"providers.html?service=" + service + "\">Providers</a> | Consumers | <a href=\"statistics.html?service=" + service + "\">Statistics</a> | <a href=\"charts.html?service=" + service + "\">Charts</a>", "Consumers (" + rows.size() + ")", new String[]{"Consumer URL:", "Unsubscribe"}, rows);
        }
        if (host != null && host.length() > 0) {
            ArrayList rows = new ArrayList();
            List<URL> consumers = RegistryContainer.getInstance().getConsumersByHost(host);
            if (consumers != null && consumers.size() > 0) {
                for (URL u : consumers) {
                    ArrayList<String> row = new ArrayList<String>();
                    String s = u.toFullString();
                    row.add(s.replace("&", "&amp;"));
                    row.add("<button onclick=\"if(confirm('Confirm unsubscribe consumer?')){window.location.href='unsubscribe.html?host=" + host + "&consumer=" + URL.encode((String)s) + "';}\">Unsubscribe</button>");
                    rows.add(row);
                }
            }
            return new Page("<a href=\"hosts.html\">Hosts</a> &gt; " + NetUtils.getHostName((String)host) + "/" + host + " &gt; <a href=\"providers.html?host=" + host + "\">Providers</a> | Consumers", "Consumers (" + rows.size() + ")", new String[]{"Consumer URL:", "Unsubscribe"}, rows);
        }
        if (application != null && application.length() > 0) {
            ArrayList rows = new ArrayList();
            List<URL> consumers = RegistryContainer.getInstance().getConsumersByApplication(application);
            if (consumers != null && consumers.size() > 0) {
                for (URL u : consumers) {
                    ArrayList<String> row = new ArrayList<String>();
                    String s = u.toFullString();
                    row.add(s.replace("&", "&amp;"));
                    row.add("<button onclick=\"if(confirm('Confirm unsubscribe consumer?')){window.location.href='unsubscribe.html?application=" + application + "&consumer=" + URL.encode((String)s) + "';}\">Unsubscribe</button>");
                    rows.add(row);
                }
            }
            return new Page("<a href=\"applications.html\">Applications</a> &gt; " + application + " &gt; <a href=\"providers.html?application=" + application + "\">Providers</a> | Consumers | <a href=\"dependencies.html?application=" + application + "\">Depends On</a> | <a href=\"dependencies.html?application=" + application + "&reverse=true\">Used By</a>", "Consumers (" + rows.size() + ")", new String[]{"Consumer URL:", "Unsubscribe"}, rows);
        }
        throw new IllegalArgumentException("Please input service or host or application parameter.");
    }
}

