/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.exchange;

import com.alibaba.dubbo.common.utils.StringUtils;
import java.util.concurrent.atomic.AtomicLong;

public class Request {
    public static final String HEARTBEAT_EVENT = null;
    public static final String READONLY_EVENT = "R";
    private static final AtomicLong INVOKE_ID = new AtomicLong(0L);
    private final long mId;
    private String mVersion;
    private boolean mTwoWay = true;
    private boolean mEvent = false;
    private boolean mBroken = false;
    private Object mData;

    public Request() {
        this.mId = Request.newId();
    }

    public Request(long id) {
        this.mId = id;
    }

    public long getId() {
        return this.mId;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public boolean isTwoWay() {
        return this.mTwoWay;
    }

    public void setTwoWay(boolean twoWay) {
        this.mTwoWay = twoWay;
    }

    public boolean isEvent() {
        return this.mEvent;
    }

    public void setEvent(String event) {
        this.mEvent = true;
        this.mData = event;
    }

    public boolean isBroken() {
        return this.mBroken;
    }

    public void setBroken(boolean mBroken) {
        this.mBroken = mBroken;
    }

    public Object getData() {
        return this.mData;
    }

    public void setData(Object msg) {
        this.mData = msg;
    }

    public boolean isHeartbeat() {
        return this.mEvent && HEARTBEAT_EVENT == this.mData;
    }

    public void setHeartbeat(boolean isHeartbeat) {
        if (isHeartbeat) {
            this.setEvent(HEARTBEAT_EVENT);
        }
    }

    private static long newId() {
        return INVOKE_ID.getAndIncrement();
    }

    public String toString() {
        return "Request [id=" + this.mId + ", version=" + this.mVersion + ", twoway=" + this.mTwoWay + ", event=" + this.mEvent + ", broken=" + this.mBroken + ", data=" + (this.mData == this ? "this" : Request.safeToString(this.mData)) + "]";
    }

    private static String safeToString(Object data) {
        String dataStr;
        if (data == null) {
            return null;
        }
        try {
            dataStr = data.toString();
        }
        catch (Throwable e) {
            dataStr = "<Fail toString of " + data.getClass() + ", cause: " + StringUtils.toString((Throwable)e) + ">";
        }
        return dataStr;
    }
}

