/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.telnet.support;

import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.telnet.TelnetHandler;
import com.alibaba.dubbo.remoting.transport.ChannelHandlerAdapter;

public class TelnetHandlerAdapter
extends ChannelHandlerAdapter
implements TelnetHandler {
    private final ExtensionLoader<TelnetHandler> extensionLoader = ExtensionLoader.getExtensionLoader(TelnetHandler.class);

    @Override
    public String telnet(Channel channel, String message) throws RemotingException {
        String command;
        String prompt = channel.getUrl().getParameterAndDecoded("prompt", "dubbo>");
        boolean noprompt = message.contains("--no-prompt");
        message = message.replace("--no-prompt", "");
        StringBuilder buf = new StringBuilder();
        if ((message = message.trim()).length() > 0) {
            int i = message.indexOf(32);
            if (i > 0) {
                command = message.substring(0, i).trim();
                message = message.substring(i + 1).trim();
            } else {
                command = message;
                message = "";
            }
        } else {
            command = "";
        }
        if (command.length() > 0) {
            if (this.extensionLoader.hasExtension(command)) {
                try {
                    String result = ((TelnetHandler)this.extensionLoader.getExtension(command)).telnet(channel, message);
                    if (result == null) {
                        return null;
                    }
                    buf.append(result);
                }
                catch (Throwable t) {
                    buf.append(t.getMessage());
                }
            } else {
                buf.append("Unsupported command: ");
                buf.append(command);
            }
        }
        if (buf.length() > 0) {
            buf.append("\r\n");
        }
        if (prompt != null && prompt.length() > 0 && !noprompt) {
            buf.append(prompt);
        }
        return buf.toString();
    }
}

