/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.monitor.support;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.monitor.Monitor;
import com.alibaba.dubbo.monitor.MonitorFactory;
import com.alibaba.dubbo.monitor.MonitorService;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMonitorFactory
implements MonitorFactory {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Map<String, Monitor> MONITORS = new ConcurrentHashMap<String, Monitor>();

    public static Collection<Monitor> getMonitors() {
        return Collections.unmodifiableCollection(MONITORS.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Monitor getMonitor(URL url) {
        Monitor monitor;
        String key;
        block4: {
            url = url.setPath(MonitorService.class.getName()).addParameter("interface", MonitorService.class.getName());
            key = url.toServiceString();
            LOCK.lock();
            try {
                monitor = MONITORS.get(key);
                if (monitor == null) break block4;
                Monitor monitor2 = monitor;
                Object var6_6 = null;
                LOCK.unlock();
                return monitor2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                LOCK.unlock();
                throw throwable;
            }
        }
        monitor = this.createMonitor(url);
        if (monitor == null) {
            throw new IllegalStateException("Can not create monitor " + url);
        }
        MONITORS.put(key, monitor);
        Monitor monitor3 = monitor;
        Object var6_7 = null;
        LOCK.unlock();
        return monitor3;
    }

    protected abstract Monitor createMonitor(URL var1);
}

