/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.mina;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.transport.AbstractClient;
import com.alibaba.dubbo.remoting.transport.mina.MinaChannel;
import com.alibaba.dubbo.remoting.transport.mina.MinaCodecAdapter;
import com.alibaba.dubbo.remoting.transport.mina.MinaHandler;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public class MinaClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(MinaClient.class);
    private static final Map<String, SocketConnector> connectors = new ConcurrentHashMap<String, SocketConnector>();
    private String connectorKey;
    private SocketConnector connector;
    private volatile IoSession session;

    public MinaClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, MinaClient.wrapChannelHandler(url, handler));
    }

    protected void doOpen() throws Throwable {
        this.connectorKey = this.getUrl().toFullString();
        SocketConnector c = connectors.get(this.connectorKey);
        if (c != null) {
            this.connector = c;
        } else {
            this.connector = new SocketConnector(Constants.DEFAULT_IO_THREADS, (Executor)Executors.newCachedThreadPool(new NamedThreadFactory("MinaClientWorker", true)));
            SocketConnectorConfig cfg = this.connector.getDefaultConfig();
            cfg.setThreadModel(ThreadModel.MANUAL);
            cfg.getSessionConfig().setTcpNoDelay(true);
            cfg.getSessionConfig().setKeepAlive(true);
            int timeout = this.getTimeout();
            cfg.setConnectTimeout(timeout < 1000 ? 1 : timeout / 1000);
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new MinaCodecAdapter(this.getCodec(), this.getUrl(), this)));
            connectors.put(this.connectorKey, this.connector);
        }
    }

    protected void doConnect() throws Throwable {
        ConnectFuture future = this.connector.connect((SocketAddress)this.getConnectAddress(), (IoHandler)new MinaHandler(this.getUrl(), this));
        long start = System.currentTimeMillis();
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch finish = new CountDownLatch(1);
        future.addListener(new IoFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void operationComplete(IoFuture future) {
                try {
                    try {
                        block18: {
                            if (future.isReady()) {
                                IoSession newSession = future.getSession();
                                try {
                                    IoSession oldSession = MinaClient.this.session;
                                    if (oldSession != null) {
                                        try {
                                            if (logger.isInfoEnabled()) {
                                                logger.info("Close old mina channel " + oldSession + " on create new mina channel " + newSession);
                                            }
                                            oldSession.close();
                                            Object var5_5 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var5_6 = null;
                                            MinaChannel.removeChannelIfDisconnectd(oldSession);
                                            throw throwable;
                                        }
                                        MinaChannel.removeChannelIfDisconnectd(oldSession);
                                        {
                                        }
                                    }
                                    Object var7_8 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var7_9 = null;
                                    if (MinaClient.this.isClosed()) {
                                        try {
                                            if (logger.isInfoEnabled()) {
                                                logger.info("Close new mina channel " + newSession + ", because the client closed.");
                                            }
                                            newSession.close();
                                            Object var9_12 = null;
                                        }
                                        catch (Throwable throwable2) {
                                            Object var9_13 = null;
                                            MinaClient.this.session = null;
                                            MinaChannel.removeChannelIfDisconnectd(newSession);
                                            throw throwable2;
                                        }
                                        MinaClient.this.session = null;
                                        MinaChannel.removeChannelIfDisconnectd(newSession);
                                        {
                                            throw throwable;
                                        }
                                    }
                                    MinaClient.this.session = newSession;
                                    throw throwable;
                                }
                                if (MinaClient.this.isClosed()) {
                                    try {
                                        if (logger.isInfoEnabled()) {
                                            logger.info("Close new mina channel " + newSession + ", because the client closed.");
                                        }
                                        newSession.close();
                                        Object var9_10 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_11 = null;
                                        MinaClient.this.session = null;
                                        MinaChannel.removeChannelIfDisconnectd(newSession);
                                        throw throwable;
                                    }
                                    MinaClient.this.session = null;
                                    MinaChannel.removeChannelIfDisconnectd(newSession);
                                    {
                                        break block18;
                                    }
                                }
                                MinaClient.this.session = newSession;
                                {
                                }
                            }
                        }
                        Object var11_17 = null;
                        finish.countDown();
                        return;
                    }
                    catch (Exception e) {
                        exception.set(e);
                        Object var11_18 = null;
                        finish.countDown();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    finish.countDown();
                    throw throwable;
                }
            }
        });
        try {
            finish.await(this.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RemotingException(this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + " client-side timeout " + this.getTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion() + ", cause: " + e.getMessage(), (Throwable)e);
        }
        Throwable e = (Throwable)exception.get();
        if (e != null) {
            throw e;
        }
    }

    protected void doDisConnect() throws Throwable {
        try {
            MinaChannel.removeChannelIfDisconnectd(this.session);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    protected void doClose() throws Throwable {
    }

    protected Channel getChannel() {
        IoSession s = this.session;
        if (s == null || !s.isConnected()) {
            return null;
        }
        return MinaChannel.getOrAddChannel(s, this.getUrl(), this);
    }
}

