/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.qos.protocol;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.qos.server.Server;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Protocol;
import com.alibaba.dubbo.rpc.RpcException;
import java.util.concurrent.atomic.AtomicBoolean;

public class QosProtocolWrapper
implements Protocol {
    private final Logger logger = LoggerFactory.getLogger(QosProtocolWrapper.class);
    private static AtomicBoolean hasStarted = new AtomicBoolean(false);
    private Protocol protocol;

    public QosProtocolWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        if ("registry".equals(invoker.getUrl().getProtocol())) {
            this.startQosServer(invoker.getUrl());
            return this.protocol.export(invoker);
        }
        return this.protocol.export(invoker);
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        if ("registry".equals(url.getProtocol())) {
            this.startQosServer(url);
            return this.protocol.refer(type, url);
        }
        return this.protocol.refer(type, url);
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    private void startQosServer(URL url) {
        if (!hasStarted.compareAndSet(false, true)) {
            return;
        }
        try {
            boolean qosEnable = url.getParameter("qos.enable", true);
            if (!qosEnable) {
                this.logger.info("qos won't be started because it is disabled. Please check dubbo.application.qos.enable is configured either in system property, dubbo.properties or XML/spring boot configuration.");
                return;
            }
            int port = url.getParameter("qos.port", 22222);
            boolean acceptForeignIp = Boolean.parseBoolean(url.getParameter("qos.accept.foreign.ip", "false"));
            Server server = Server.getInstance();
            server.setPort(port);
            server.setAcceptForeignIp(acceptForeignIp);
            server.start();
        }
        catch (Throwable throwable) {
            this.logger.warn("Fail to start qos server: ", throwable);
        }
    }
}

