/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.bootstrap;

import com.alibaba.dubbo.config.DubboShutdownHook;
import com.alibaba.dubbo.config.ServiceConfig;
import java.util.ArrayList;
import java.util.List;

public class DubboBootstrap {
    private List<ServiceConfig> serviceConfigList = new ArrayList<ServiceConfig>();
    private final boolean registerShutdownHookOnStart;
    private DubboShutdownHook shutdownHook;

    public DubboBootstrap() {
        this(true, DubboShutdownHook.getDubboShutdownHook());
    }

    public DubboBootstrap(boolean registerShutdownHookOnStart) {
        this(registerShutdownHookOnStart, DubboShutdownHook.getDubboShutdownHook());
    }

    public DubboBootstrap(boolean registerShutdownHookOnStart, DubboShutdownHook shutdownHook) {
        this.shutdownHook = shutdownHook;
        this.registerShutdownHookOnStart = registerShutdownHookOnStart;
    }

    public DubboBootstrap registerServiceConfig(ServiceConfig serviceConfig) {
        this.serviceConfigList.add(serviceConfig);
        return this;
    }

    public void start() {
        if (this.registerShutdownHookOnStart) {
            this.registerShutdownHook();
        } else {
            this.removeShutdownHook();
        }
        for (ServiceConfig serviceConfig : this.serviceConfigList) {
            serviceConfig.export();
        }
    }

    public void stop() {
        for (ServiceConfig serviceConfig : this.serviceConfigList) {
            serviceConfig.unexport();
        }
        this.shutdownHook.destroyAll();
        if (this.registerShutdownHookOnStart) {
            this.removeShutdownHook();
        }
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void removeShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

