/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.threadpool.support.eager;

import com.alibaba.dubbo.common.threadpool.support.eager.TaskQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EagerThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicInteger submittedTaskCount = new AtomicInteger(0);

    public EagerThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, TaskQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public int getSubmittedTaskCount() {
        return this.submittedTaskCount.get();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.submittedTaskCount.decrementAndGet();
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.submittedTaskCount.incrementAndGet();
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException rx) {
            TaskQueue queue = (TaskQueue)super.getQueue();
            try {
                if (!queue.retryOffer(command, 0L, TimeUnit.MILLISECONDS)) {
                    this.submittedTaskCount.decrementAndGet();
                    throw new RejectedExecutionException("Queue capacity is full.");
                }
            }
            catch (InterruptedException x) {
                this.submittedTaskCount.decrementAndGet();
                throw new RejectedExecutionException(x);
            }
        }
        catch (Throwable t) {
            this.submittedTaskCount.decrementAndGet();
        }
    }
}

