/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.rest;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.protocol.rest.DubboResourceFactory;
import com.alibaba.dubbo.rpc.protocol.rest.RestServer;
import io.undertow.Undertow;
import io.undertow.servlet.api.DeploymentInfo;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class UndertowServer
implements RestServer {
    private final ResteasyDeployment deployment = new ResteasyDeployment();
    private final UndertowJaxrsServer server = new UndertowJaxrsServer();

    @Override
    public void start(URL url) {
        this.deployment.start();
        DeploymentInfo deploymentInfo = this.server.undertowDeployment(this.deployment);
        deploymentInfo.setContextPath("/");
        deploymentInfo.setDeploymentName("dubbo-rest");
        deploymentInfo.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.server.deploy(deploymentInfo);
        this.server.start(Undertow.builder().addHttpListener(url.getPort(), url.getHost()));
    }

    @Override
    public void deploy(Class resourceDef, Object resourceInstance, String contextPath) {
        if (StringUtils.isEmpty(contextPath)) {
            this.deployment.getRegistry().addResourceFactory((ResourceFactory)new DubboResourceFactory(resourceInstance, resourceDef));
        } else {
            this.deployment.getRegistry().addResourceFactory((ResourceFactory)new DubboResourceFactory(resourceInstance, resourceDef), contextPath);
        }
    }

    @Override
    public void undeploy(Class resourceDef) {
        this.deployment.getRegistry().removeRegistrations(resourceDef);
    }

    public void deploy(Class resourceDef, Object resourceInstance) {
        this.deploy(resourceDef, resourceInstance, "/");
    }

    @Override
    public void stop() {
        this.deployment.stop();
        this.server.stop();
    }
}

