/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.csv;

import com.alibaba.excel.enums.NumericCellTypeEnum;
import com.alibaba.excel.metadata.csv.CsvRow;
import com.alibaba.excel.metadata.csv.CsvSheet;
import com.alibaba.excel.metadata.csv.CsvWorkbook;
import com.alibaba.excel.metadata.data.FormulaData;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellBase;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CsvCell
extends CellBase {
    private Integer columnIndex;
    private CellType cellType;
    private NumericCellTypeEnum numericCellType;
    private final CsvWorkbook csvWorkbook;
    private final CsvSheet csvSheet;
    private final CsvRow csvRow;
    private BigDecimal numberValue;
    private String stringValue;
    private Boolean booleanValue;
    private LocalDateTime dateValue;
    private FormulaData formulaData;
    private RichTextString richTextString;
    private CellStyle cellStyle;

    public CsvCell(CsvWorkbook csvWorkbook, CsvSheet csvSheet, CsvRow csvRow, Integer columnIndex, CellType cellType) {
        this.csvWorkbook = csvWorkbook;
        this.csvSheet = csvSheet;
        this.csvRow = csvRow;
        this.columnIndex = columnIndex;
        this.cellType = cellType;
        if (this.cellType == null) {
            this.cellType = CellType._NONE;
        }
    }

    protected void setCellTypeImpl(CellType cellType) {
        this.cellType = cellType;
    }

    protected void setCellFormulaImpl(String formula) {
        FormulaData formulaData = new FormulaData();
        formulaData.setFormulaValue(formula);
        this.formulaData = formulaData;
        this.cellType = CellType.FORMULA;
    }

    protected void removeFormulaImpl() {
        this.formulaData = null;
    }

    protected void setCellValueImpl(double value) {
        this.numberValue = BigDecimal.valueOf(value);
        this.cellType = CellType.NUMERIC;
    }

    protected void setCellValueImpl(Date value) {
        if (value == null) {
            return;
        }
        this.dateValue = LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
        this.cellType = CellType.NUMERIC;
        this.numericCellType = NumericCellTypeEnum.DATE;
    }

    protected void setCellValueImpl(LocalDateTime value) {
        this.dateValue = value;
        this.cellType = CellType.NUMERIC;
        this.numericCellType = NumericCellTypeEnum.DATE;
    }

    protected void setCellValueImpl(Calendar value) {
        if (value == null) {
            return;
        }
        this.dateValue = LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
        this.cellType = CellType.NUMERIC;
    }

    protected void setCellValueImpl(String value) {
        this.stringValue = value;
        this.cellType = CellType.STRING;
    }

    protected void setCellValueImpl(RichTextString value) {
        this.richTextString = value;
        this.cellType = CellType.STRING;
    }

    public void setCellValue(String value) {
        if (value == null) {
            this.setBlank();
            return;
        }
        this.setCellValueImpl(value);
    }

    public void setCellValue(RichTextString value) {
        if (value == null || value.getString() == null) {
            this.setBlank();
            return;
        }
        this.setCellValueImpl(value);
    }

    protected SpreadsheetVersion getSpreadsheetVersion() {
        return null;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.csvRow.getRowNum();
    }

    public Sheet getSheet() {
        return this.csvRow.getSheet();
    }

    public Row getRow() {
        return this.csvRow;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public CellType getCachedFormulaResultType() {
        return this.getCellType();
    }

    public String getCellFormula() {
        if (this.formulaData == null) {
            return null;
        }
        return this.formulaData.getFormulaValue();
    }

    public double getNumericCellValue() {
        if (this.numberValue == null) {
            return 0.0;
        }
        return this.numberValue.doubleValue();
    }

    public Date getDateCellValue() {
        if (this.dateValue == null) {
            return null;
        }
        return Date.from(this.dateValue.atZone(ZoneId.systemDefault()).toInstant());
    }

    public LocalDateTime getLocalDateTimeCellValue() {
        return this.dateValue;
    }

    public RichTextString getRichStringCellValue() {
        return this.richTextString;
    }

    public String getStringCellValue() {
        return this.stringValue;
    }

    public void setCellValue(boolean value) {
        this.booleanValue = value;
        this.cellType = CellType.BOOLEAN;
    }

    public void setCellErrorValue(byte value) {
        this.numberValue = BigDecimal.valueOf(value);
        this.cellType = CellType.ERROR;
    }

    public boolean getBooleanCellValue() {
        if (this.booleanValue == null) {
            return false;
        }
        return this.booleanValue;
    }

    public byte getErrorCellValue() {
        if (this.numberValue == null) {
            return 0;
        }
        return this.numberValue.byteValue();
    }

    public void setCellStyle(CellStyle style) {
        this.cellStyle = style;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setAsActiveCell() {
    }

    public void setCellComment(Comment comment) {
    }

    public Comment getCellComment() {
        return null;
    }

    public void removeCellComment() {
    }

    public Hyperlink getHyperlink() {
        return null;
    }

    public void setHyperlink(Hyperlink link) {
    }

    public void removeHyperlink() {
    }

    public CellRangeAddress getArrayFormulaRange() {
        return null;
    }

    public boolean isPartOfArrayFormulaGroup() {
        return false;
    }

    public NumericCellTypeEnum getNumericCellType() {
        return this.numericCellType;
    }

    public CsvWorkbook getCsvWorkbook() {
        return this.csvWorkbook;
    }

    public CsvSheet getCsvSheet() {
        return this.csvSheet;
    }

    public CsvRow getCsvRow() {
        return this.csvRow;
    }

    public BigDecimal getNumberValue() {
        return this.numberValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public LocalDateTime getDateValue() {
        return this.dateValue;
    }

    public FormulaData getFormulaData() {
        return this.formulaData;
    }

    public RichTextString getRichTextString() {
        return this.richTextString;
    }

    public void setNumericCellType(NumericCellTypeEnum numericCellType) {
        this.numericCellType = numericCellType;
    }

    public void setNumberValue(BigDecimal numberValue) {
        this.numberValue = numberValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public void setDateValue(LocalDateTime dateValue) {
        this.dateValue = dateValue;
    }

    public void setFormulaData(FormulaData formulaData) {
        this.formulaData = formulaData;
    }

    public void setRichTextString(RichTextString richTextString) {
        this.richTextString = richTextString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvCell)) {
            return false;
        }
        CsvCell other = (CsvCell)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getColumnIndex() != other.getColumnIndex()) {
            return false;
        }
        Boolean this$booleanValue = this.getBooleanValue();
        Boolean other$booleanValue = other.getBooleanValue();
        if (this$booleanValue == null ? other$booleanValue != null : !((Object)this$booleanValue).equals(other$booleanValue)) {
            return false;
        }
        CellType this$cellType = this.getCellType();
        CellType other$cellType = other.getCellType();
        if (this$cellType == null ? other$cellType != null : !this$cellType.equals(other$cellType)) {
            return false;
        }
        NumericCellTypeEnum this$numericCellType = this.getNumericCellType();
        NumericCellTypeEnum other$numericCellType = other.getNumericCellType();
        if (this$numericCellType == null ? other$numericCellType != null : !((Object)((Object)this$numericCellType)).equals((Object)other$numericCellType)) {
            return false;
        }
        CsvWorkbook this$csvWorkbook = this.getCsvWorkbook();
        CsvWorkbook other$csvWorkbook = other.getCsvWorkbook();
        if (this$csvWorkbook == null ? other$csvWorkbook != null : !((Object)this$csvWorkbook).equals(other$csvWorkbook)) {
            return false;
        }
        CsvSheet this$csvSheet = this.getCsvSheet();
        CsvSheet other$csvSheet = other.getCsvSheet();
        if (this$csvSheet == null ? other$csvSheet != null : !((Object)this$csvSheet).equals(other$csvSheet)) {
            return false;
        }
        CsvRow this$csvRow = this.getCsvRow();
        CsvRow other$csvRow = other.getCsvRow();
        if (this$csvRow == null ? other$csvRow != null : !((Object)this$csvRow).equals(other$csvRow)) {
            return false;
        }
        BigDecimal this$numberValue = this.getNumberValue();
        BigDecimal other$numberValue = other.getNumberValue();
        if (this$numberValue == null ? other$numberValue != null : !((Object)this$numberValue).equals(other$numberValue)) {
            return false;
        }
        String this$stringValue = this.getStringValue();
        String other$stringValue = other.getStringValue();
        if (this$stringValue == null ? other$stringValue != null : !this$stringValue.equals(other$stringValue)) {
            return false;
        }
        LocalDateTime this$dateValue = this.getDateValue();
        LocalDateTime other$dateValue = other.getDateValue();
        if (this$dateValue == null ? other$dateValue != null : !((Object)this$dateValue).equals(other$dateValue)) {
            return false;
        }
        FormulaData this$formulaData = this.getFormulaData();
        FormulaData other$formulaData = other.getFormulaData();
        if (this$formulaData == null ? other$formulaData != null : !((Object)this$formulaData).equals(other$formulaData)) {
            return false;
        }
        RichTextString this$richTextString = this.getRichTextString();
        RichTextString other$richTextString = other.getRichTextString();
        if (this$richTextString == null ? other$richTextString != null : !this$richTextString.equals(other$richTextString)) {
            return false;
        }
        CellStyle this$cellStyle = this.getCellStyle();
        CellStyle other$cellStyle = other.getCellStyle();
        return !(this$cellStyle == null ? other$cellStyle != null : !this$cellStyle.equals(other$cellStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CsvCell;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getColumnIndex();
        Boolean $booleanValue = this.getBooleanValue();
        result = result * 59 + ($booleanValue == null ? 43 : ((Object)$booleanValue).hashCode());
        CellType $cellType = this.getCellType();
        result = result * 59 + ($cellType == null ? 43 : $cellType.hashCode());
        NumericCellTypeEnum $numericCellType = this.getNumericCellType();
        result = result * 59 + ($numericCellType == null ? 43 : ((Object)((Object)$numericCellType)).hashCode());
        CsvWorkbook $csvWorkbook = this.getCsvWorkbook();
        result = result * 59 + ($csvWorkbook == null ? 43 : ((Object)$csvWorkbook).hashCode());
        CsvSheet $csvSheet = this.getCsvSheet();
        result = result * 59 + ($csvSheet == null ? 43 : ((Object)$csvSheet).hashCode());
        CsvRow $csvRow = this.getCsvRow();
        result = result * 59 + ($csvRow == null ? 43 : ((Object)$csvRow).hashCode());
        BigDecimal $numberValue = this.getNumberValue();
        result = result * 59 + ($numberValue == null ? 43 : ((Object)$numberValue).hashCode());
        String $stringValue = this.getStringValue();
        result = result * 59 + ($stringValue == null ? 43 : $stringValue.hashCode());
        LocalDateTime $dateValue = this.getDateValue();
        result = result * 59 + ($dateValue == null ? 43 : ((Object)$dateValue).hashCode());
        FormulaData $formulaData = this.getFormulaData();
        result = result * 59 + ($formulaData == null ? 43 : ((Object)$formulaData).hashCode());
        RichTextString $richTextString = this.getRichTextString();
        result = result * 59 + ($richTextString == null ? 43 : $richTextString.hashCode());
        CellStyle $cellStyle = this.getCellStyle();
        result = result * 59 + ($cellStyle == null ? 43 : $cellStyle.hashCode());
        return result;
    }
}

