/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis;

import com.alibaba.excel.analysis.ExcelAnalyser;
import com.alibaba.excel.analysis.ExcelReadExecutor;
import com.alibaba.excel.analysis.v03.XlsSaxAnalyser;
import com.alibaba.excel.analysis.v07.XlsxSaxAnalyser;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.context.AnalysisContextImpl;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelAnalysisStopException;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import com.alibaba.excel.read.metadata.holder.ReadWorkbookHolder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.StringUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelAnalyserImpl
implements ExcelAnalyser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelAnalyserImpl.class);
    private AnalysisContext analysisContext;
    private ExcelReadExecutor excelReadExecutor;
    private boolean finished = false;

    public ExcelAnalyserImpl(ReadWorkbook readWorkbook) {
        try {
            this.analysisContext = new AnalysisContextImpl(readWorkbook);
            this.choiceExcelExecutor();
        }
        catch (RuntimeException e) {
            this.finish();
            throw e;
        }
        catch (Throwable e) {
            this.finish();
            throw new ExcelAnalysisException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void choiceExcelExecutor() throws Exception {
        ReadWorkbookHolder readWorkbookHolder = this.analysisContext.readWorkbookHolder();
        ExcelTypeEnum excelType = readWorkbookHolder.getExcelType();
        if (excelType == null) {
            this.excelReadExecutor = new XlsxSaxAnalyser(this.analysisContext, null);
            return;
        }
        switch (excelType) {
            case XLS: {
                POIFSFileSystem poifsFileSystem = readWorkbookHolder.getFile() != null ? new POIFSFileSystem(readWorkbookHolder.getFile()) : new POIFSFileSystem(readWorkbookHolder.getInputStream());
                if (poifsFileSystem.getRoot().hasEntry("EncryptedPackage")) {
                    InputStream decryptedStream = null;
                    try {
                        decryptedStream = DocumentFactoryHelper.getDecryptedStream((NPOIFSFileSystem)poifsFileSystem.getRoot().getFileSystem(), (String)this.analysisContext.readWorkbookHolder().getPassword());
                        this.excelReadExecutor = new XlsxSaxAnalyser(this.analysisContext, decryptedStream);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(decryptedStream);
                        poifsFileSystem.close();
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)decryptedStream);
                    poifsFileSystem.close();
                    return;
                }
                if (this.analysisContext.readWorkbookHolder().getPassword() != null) {
                    Biff8EncryptionKey.setCurrentUserPassword((String)this.analysisContext.readWorkbookHolder().getPassword());
                }
                this.excelReadExecutor = new XlsSaxAnalyser(this.analysisContext, poifsFileSystem);
                break;
            }
            case XLSX: {
                this.excelReadExecutor = new XlsxSaxAnalyser(this.analysisContext, null);
                break;
            }
        }
    }

    @Override
    public void analysis(List<ReadSheet> readSheetList, Boolean readAll) {
        try {
            block7: {
                if (!readAll.booleanValue() && CollectionUtils.isEmpty(readSheetList)) {
                    throw new IllegalArgumentException("Specify at least one read sheet.");
                }
                try {
                    this.excelReadExecutor.execute(readSheetList, readAll);
                }
                catch (ExcelAnalysisStopException e) {
                    if (!LOGGER.isDebugEnabled()) break block7;
                    LOGGER.debug("Custom stop!");
                }
            }
            if (this.excelReadExecutor instanceof XlsSaxAnalyser && this.analysisContext.readSheetHolder() != null) {
                this.analysisContext.readSheetHolder().notifyAfterAllAnalysed(this.analysisContext);
            }
        }
        catch (RuntimeException e) {
            this.finish();
            throw e;
        }
        catch (Throwable e) {
            this.finish();
            throw new ExcelAnalysisException(e);
        }
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.analysisContext == null || this.analysisContext.readWorkbookHolder() == null) {
            return;
        }
        ReadWorkbookHolder readWorkbookHolder = this.analysisContext.readWorkbookHolder();
        Throwable throwable = null;
        try {
            if (readWorkbookHolder.getReadCache() != null) {
                readWorkbookHolder.getReadCache().destroy();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (readWorkbookHolder.getOpcPackage() != null) {
                readWorkbookHolder.getOpcPackage().revert();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (readWorkbookHolder.getPoifsFileSystem() != null) {
                readWorkbookHolder.getPoifsFileSystem().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (this.analysisContext.readWorkbookHolder().getAutoCloseStream().booleanValue() && readWorkbookHolder.getInputStream() != null) {
                readWorkbookHolder.getInputStream().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (readWorkbookHolder.getTempFile() != null) {
                FileUtils.delete(readWorkbookHolder.getTempFile());
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        this.clearEncrypt03();
        if (throwable != null) {
            throw new ExcelAnalysisException("Can not close IO", throwable);
        }
    }

    private void clearEncrypt03() {
        if (StringUtils.isEmpty(this.analysisContext.readWorkbookHolder().getPassword()) || !ExcelTypeEnum.XLS.equals((Object)this.analysisContext.readWorkbookHolder().getExcelType())) {
            return;
        }
        Biff8EncryptionKey.setCurrentUserPassword(null);
    }

    @Override
    public ExcelReadExecutor excelExecutor() {
        return this.excelReadExecutor;
    }

    @Override
    public AnalysisContext analysisContext() {
        return this.analysisContext;
    }
}

