/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v07.handlers;

import com.alibaba.excel.analysis.v07.handlers.AbstractXlsxTagHandler;
import com.alibaba.excel.constant.BuiltinFormats;
import com.alibaba.excel.context.xlsx.XlsxReadContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.read.metadata.holder.xlsx.XlsxReadSheetHolder;
import com.alibaba.excel.util.BooleanUtils;
import com.alibaba.excel.util.PositionUtils;
import com.alibaba.excel.util.StringUtils;
import java.math.BigDecimal;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;

public class CellTagHandler
extends AbstractXlsxTagHandler {
    private static final int DEFAULT_FORMAT_INDEX = 0;

    @Override
    public void startElement(XlsxReadContext xlsxReadContext, String name, Attributes attributes) {
        XlsxReadSheetHolder xlsxReadSheetHolder = xlsxReadContext.xlsxReadSheetHolder();
        xlsxReadSheetHolder.setColumnIndex(PositionUtils.getCol(attributes.getValue("r"), xlsxReadSheetHolder.getColumnIndex()));
        CellDataTypeEnum type = CellDataTypeEnum.buildFromCellType(attributes.getValue("t"));
        xlsxReadSheetHolder.setTempCellData(new CellData(type));
        xlsxReadSheetHolder.setTempData(new StringBuilder());
        String dateFormatIndex = attributes.getValue("s");
        Integer dateFormatIndexInteger = StringUtils.isEmpty(dateFormatIndex) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(dateFormatIndex));
        XSSFCellStyle xssfCellStyle = xlsxReadContext.xlsxReadWorkbookHolder().getStylesTable().getStyleAt(dateFormatIndexInteger.intValue());
        short dataFormat = xssfCellStyle.getDataFormat();
        xlsxReadSheetHolder.getTempCellData().setDataFormat(Integer.valueOf(dataFormat));
        xlsxReadSheetHolder.getTempCellData().setDataFormatString(BuiltinFormats.getBuiltinFormat(Integer.valueOf(dataFormat), xssfCellStyle.getDataFormatString(), xlsxReadSheetHolder.getGlobalConfiguration().getLocale()));
    }

    @Override
    public void endElement(XlsxReadContext xlsxReadContext, String name) {
        XlsxReadSheetHolder xlsxReadSheetHolder = xlsxReadContext.xlsxReadSheetHolder();
        CellData tempCellData = xlsxReadSheetHolder.getTempCellData();
        StringBuilder tempData = xlsxReadSheetHolder.getTempData();
        String tempDataString = tempData.toString();
        CellDataTypeEnum oldType = tempCellData.getType();
        switch (oldType) {
            case STRING: {
                if (StringUtils.isEmpty(tempDataString)) break;
                String stringValue = xlsxReadContext.readWorkbookHolder().getReadCache().get(Integer.valueOf(tempDataString));
                tempCellData.setStringValue(stringValue);
                break;
            }
            case DIRECT_STRING: 
            case ERROR: {
                tempCellData.setStringValue(tempDataString);
                tempCellData.setType(CellDataTypeEnum.STRING);
                break;
            }
            case BOOLEAN: {
                if (StringUtils.isEmpty(tempDataString)) {
                    tempCellData.setType(CellDataTypeEnum.EMPTY);
                    break;
                }
                tempCellData.setBooleanValue(BooleanUtils.valueOf(tempData.toString()));
                break;
            }
            case NUMBER: 
            case EMPTY: {
                if (StringUtils.isEmpty(tempDataString)) {
                    tempCellData.setType(CellDataTypeEnum.EMPTY);
                    break;
                }
                tempCellData.setType(CellDataTypeEnum.NUMBER);
                tempCellData.setNumberValue(BigDecimal.valueOf(Double.parseDouble(tempDataString)));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot set values now");
            }
        }
        if (tempCellData.getStringValue() != null && xlsxReadContext.currentReadHolder().globalConfiguration().getAutoTrim().booleanValue()) {
            tempCellData.setStringValue(tempCellData.getStringValue());
        }
        tempCellData.checkEmpty();
        xlsxReadSheetHolder.getCellMap().put(xlsxReadSheetHolder.getColumnIndex(), tempCellData);
    }
}

