/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.common.filter;

import com.alibaba.metrics.Metric;
import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.MetricLevel;
import com.alibaba.metrics.MetricName;
import com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;

public class TimeMetricLevelFilter
implements MetricFilter {
    protected MetricsLevelInfo[] levelInfos = new MetricsLevelInfo[MetricLevel.getMaxValue() + 1];
    protected MetricsCollectPeriodConfig config;

    public TimeMetricLevelFilter() {
    }

    public TimeMetricLevelFilter(MetricsCollectPeriodConfig config) {
        MetricLevel[] levels;
        this.config = config;
        if (config == null) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (MetricLevel level : levels = MetricLevel.values()) {
            this.levelInfos[level.ordinal()] = new MetricsLevelInfo(false, currentTimeMillis);
        }
    }

    public void beforeReport() {
        MetricLevel[] levels;
        if (this.config == null) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (MetricLevel level : levels = MetricLevel.values()) {
            int period = this.config.period(level);
            if (period < 0) continue;
            MetricsLevelInfo metricsLevelInfo = this.levelInfos[level.ordinal()];
            if ((currentTimeMillis - metricsLevelInfo.lastReportTimeStamp) / 1000L < (long)period) continue;
            metricsLevelInfo.allow = true;
            metricsLevelInfo.lastReportTimeStamp = currentTimeMillis;
        }
    }

    public void afterReport() {
        if (this.config == null) {
            return;
        }
        for (MetricsLevelInfo info : this.levelInfos) {
            if (!info.allow.booleanValue()) continue;
            info.allow = false;
        }
    }

    public boolean matches(MetricName name, Metric metric) {
        if (this.config == null) {
            return true;
        }
        return this.levelInfos[name.getMetricLevel().ordinal()].allow;
    }

    class MetricsLevelInfo {
        Boolean allow;
        Long lastReportTimeStamp;

        public MetricsLevelInfo(boolean allow, long lastReportTimeStamp) {
            this.allow = allow;
            this.lastReportTimeStamp = lastReportTimeStamp;
        }
    }
}

