/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.instrument;

import com.alibaba.metrics.Counter;
import com.alibaba.metrics.Meter;
import com.alibaba.metrics.MetricRegistry;
import com.alibaba.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class InstrumentedExecutorService
implements ExecutorService {
    private static final AtomicLong nameCounter = new AtomicLong();
    private final ExecutorService delegate;
    private final Meter submitted;
    private final Counter running;
    private final Meter completed;
    private final Timer duration;
    private final Meter rejected;

    public InstrumentedExecutorService(ExecutorService delegate, MetricRegistry registry) {
        this(delegate, registry, "instrumented-delegate-" + nameCounter.incrementAndGet());
    }

    public InstrumentedExecutorService(ExecutorService delegate, MetricRegistry registry, String name) {
        this.delegate = delegate;
        this.submitted = registry.meter(MetricRegistry.name((String)name, (String[])new String[]{"submitted"}));
        this.running = registry.counter(MetricRegistry.name((String)name, (String[])new String[]{"running"}));
        this.completed = registry.meter(MetricRegistry.name((String)name, (String[])new String[]{"completed"}));
        this.duration = registry.timer(MetricRegistry.name((String)name, (String[])new String[]{"duration"}));
        this.rejected = registry.meter(MetricRegistry.name((String)name, (String[])new String[]{"rejected"}));
    }

    @Override
    public void execute(Runnable runnable) {
        this.submitted.mark();
        try {
            this.delegate.execute(new InstrumentedRunnable(runnable));
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        this.submitted.mark();
        try {
            return this.delegate.submit(new InstrumentedRunnable(runnable));
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result) {
        this.submitted.mark();
        try {
            return this.delegate.submit(new InstrumentedRunnable(runnable), result);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.submitted.mark();
        try {
            return this.delegate.submit(new InstrumentedCallable<T>(task));
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.submitted.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAll(instrumented);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.submitted.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAll(instrumented, timeout, unit);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        this.submitted.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAny(instrumented);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        this.submitted.mark((long)tasks.size());
        Collection<Callable<T>> instrumented = this.instrument(tasks);
        try {
            return this.delegate.invokeAny(instrumented, timeout, unit);
        }
        catch (RejectedExecutionException e) {
            this.rejected.mark();
            throw e;
        }
    }

    private <T> Collection<? extends Callable<T>> instrument(Collection<? extends Callable<T>> tasks) {
        ArrayList<InstrumentedCallable<T>> instrumented = new ArrayList<InstrumentedCallable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            instrumented.add(new InstrumentedCallable<T>(task));
        }
        return instrumented;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    private class InstrumentedCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;

        InstrumentedCallable(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public T call() throws Exception {
            InstrumentedExecutorService.this.running.inc();
            Timer.Context context = InstrumentedExecutorService.this.duration.time();
            try {
                T t = this.callable.call();
                return t;
            }
            finally {
                context.stop();
                InstrumentedExecutorService.this.running.dec();
                InstrumentedExecutorService.this.completed.mark();
            }
        }
    }

    private class InstrumentedRunnable
    implements Runnable {
        private final Runnable task;

        InstrumentedRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            InstrumentedExecutorService.this.running.inc();
            Timer.Context context = InstrumentedExecutorService.this.duration.time();
            try {
                this.task.run();
            }
            finally {
                context.stop();
                InstrumentedExecutorService.this.running.dec();
                InstrumentedExecutorService.this.completed.mark();
            }
        }
    }
}

